/*
 * Decompiled with CFR 0.152.
 */
package com.tihyo.godzilla.dimensions.infantisland;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenHugeTrees;

public class WorldGenInfantJungleTree
extends WorldGenHugeTrees {
    private static Block log = Blocks.field_150364_r;
    private static Block leaves = Blocks.field_150362_t;
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    Random rand = new Random();
    World worldObj;
    int[] basePos = new int[]{0, 0, 0};
    int heightLimit;
    int height;
    double heightAttenuation = 0.618;
    double branchDensity = 1.0;
    double branchSlope = 0.381;
    double scaleWidth = 1.0;
    double leafDensity = 0.8;
    private final boolean vinesGrow;
    int trunkSize = 2;
    int heightLimitLimit = 20;
    int leafDistanceLimit = 2;
    int[][] leafNodes;
    int blockMetadata = 3;
    private static final String __OBFID = "CL_00000400";

    public WorldGenInfantJungleTree(boolean p_i2008_1_, int treeHeight, int trunkWidth, int leavesWidthFromBase, int woodType, boolean doVinesGrow) {
        super(p_i2008_1_, treeHeight, trunkWidth, leavesWidthFromBase, woodType);
        this.trunkSize = trunkWidth;
        this.heightLimitLimit = treeHeight;
        this.leafDistanceLimit = leavesWidthFromBase;
        this.blockMetadata = woodType;
        this.vinesGrow = doVinesGrow;
    }

    void generateLeafNodeList() {
        int i;
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if ((i = (int)(1.382 + Math.pow(this.leafDensity * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            i = 1;
        }
        int[][] aint = new int[i * this.heightLimit][4];
        int j = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int k = 1;
        int l = this.basePos[1] + this.height;
        int i1 = j - this.basePos[1];
        aint[0][0] = this.basePos[0];
        aint[0][1] = j--;
        aint[0][2] = this.basePos[2];
        aint[0][3] = l;
        while (i1 >= 0) {
            float f = this.layerSize(i1);
            if (f < 0.0f) {
                --j;
                --i1;
                continue;
            }
            double d0 = 0.5;
            for (int j1 = 0; j1 < i; ++j1) {
                int[] aint2;
                int l1;
                double d2;
                double d1 = this.scaleWidth * (double)f * ((double)this.rand.nextFloat() + 0.328);
                int k1 = MathHelper.func_76128_c((double)(d1 * Math.sin(d2 = (double)this.rand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + d0));
                int[] aint1 = new int[]{k1, j, l1 = MathHelper.func_76128_c((double)(d1 * Math.cos(d2) + (double)this.basePos[2] + d0))};
                if (this.checkBlockLine(aint1, aint2 = new int[]{k1, j + this.leafDistanceLimit, l1}) != -1) continue;
                int[] aint3 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double d3 = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - aint1[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - aint1[2]), 2.0));
                double d4 = d3 * this.branchSlope;
                aint3[1] = (double)aint1[1] - d4 > (double)l ? l : (int)((double)aint1[1] - d4);
                if (this.checkBlockLine(aint3, aint1) != -1) continue;
                aint[k][0] = k1;
                aint[k][1] = j;
                aint[k][2] = l1;
                aint[k][3] = aint3[1];
                ++k;
            }
            --j;
            --i1;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(aint, 0, this.leafNodes, 0, k);
    }

    void func_150529_a(int p_150529_1_, int p_150529_2_, int p_150529_3_, float p_150529_4_, byte p_150529_5_, Block p_150529_6_) {
        int l = (int)((double)p_150529_4_ + 0.618);
        byte b1 = otherCoordPairs[p_150529_5_];
        byte b2 = otherCoordPairs[p_150529_5_ + 3];
        int[] aint = new int[]{p_150529_1_, p_150529_2_, p_150529_3_};
        int[] aint1 = new int[]{0, 0, 0};
        int j1 = -l;
        aint1[p_150529_5_] = aint[p_150529_5_];
        for (int i1 = -l; i1 <= l; ++i1) {
            aint1[b1] = aint[b1] + i1;
            j1 = -l;
            while (j1 <= l) {
                double d0 = Math.pow((double)Math.abs(i1) + 0.5, 2.0) + Math.pow((double)Math.abs(j1) + 0.5, 2.0);
                if (d0 > (double)(p_150529_4_ * p_150529_4_)) {
                    ++j1;
                    continue;
                }
                aint1[b2] = aint[b2] + j1;
                Block block1 = this.worldObj.func_147439_a(aint1[0], aint1[1], aint1[2]);
                if (!block1.isAir((IBlockAccess)this.worldObj, aint1[0], aint1[1], aint1[2]) && !block1.isLeaves((IBlockAccess)this.worldObj, aint1[0], aint1[1], aint1[2])) {
                    ++j1;
                    continue;
                }
                this.func_150516_a(this.worldObj, aint1[0], aint1[1], aint1[2], p_150529_6_, this.blockMetadata);
                ++j1;
            }
        }
    }

    float layerSize(int p_76490_1_) {
        if ((double)p_76490_1_ < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float f = (float)this.heightLimit / 2.0f;
        float f1 = (float)this.heightLimit / 2.0f - (float)p_76490_1_;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    float leafSize(int p_76495_1_) {
        return p_76495_1_ >= 0 && p_76495_1_ < this.leafDistanceLimit ? (p_76495_1_ != 0 && p_76495_1_ != this.leafDistanceLimit - 1 ? 3.0f : 2.0f) : -1.0f;
    }

    void generateLeafNode(int p_76491_1_, int p_76491_2_, int p_76491_3_) {
        int i1 = p_76491_2_ + this.leafDistanceLimit;
        for (int l = p_76491_2_; l < i1; ++l) {
            float f = this.leafSize(l - p_76491_2_);
            this.func_150529_a(p_76491_1_, l, p_76491_3_, f, (byte)1, leaves);
        }
    }

    void func_150530_a(int[] p_150530_1_, int[] p_150530_2_, Block p_150530_3_) {
        int[] aint2 = new int[]{0, 0, 0};
        int b1 = 0;
        for (int b0 = 0; b0 < 3; b0 = (int)((byte)(b0 + 1))) {
            aint2[b0] = p_150530_2_[b0] - p_150530_1_[b0];
            if (Math.abs(aint2[b0]) <= Math.abs(aint2[b1])) continue;
            b1 = b0;
        }
        if (aint2[b1] != 0) {
            byte b2 = otherCoordPairs[b1];
            byte b3 = otherCoordPairs[b1 + 3];
            int b4 = aint2[b1] > 0 ? 1 : -1;
            double d0 = (double)aint2[b2] / (double)aint2[b1];
            double d1 = (double)aint2[b3] / (double)aint2[b1];
            int[] aint3 = new int[]{0, 0, 0};
            int j = aint2[b1] + b4;
            for (int i = 0; i != j; i += b4) {
                int l;
                aint3[b1] = MathHelper.func_76128_c((double)((double)(p_150530_1_[b1] + i) + 0.5));
                aint3[b2] = MathHelper.func_76128_c((double)((double)p_150530_1_[b2] + (double)i * d0 + 0.5));
                aint3[b3] = MathHelper.func_76128_c((double)((double)p_150530_1_[b3] + (double)i * d1 + 0.5));
                int b5 = 0;
                int k = Math.abs(aint3[0] - p_150530_1_[0]);
                int i1 = Math.max(k, l = Math.abs(aint3[2] - p_150530_1_[2]));
                if (i1 > 0) {
                    if (k == i1) {
                        b5 = 4;
                    } else if (l == i1) {
                        b5 = 8;
                    }
                }
                this.func_150516_a(this.worldObj, aint3[0], aint3[1], aint3[2], p_150530_3_, this.blockMetadata);
            }
        }
    }

    void generateLeaves() {
        int j = this.leafNodes.length;
        for (int i = 0; i < j; ++i) {
            int k = this.leafNodes[i][0];
            int l = this.leafNodes[i][1];
            int i1 = this.leafNodes[i][2];
            this.generateLeafNode(k, l, i1);
        }
    }

    boolean leafNodeNeedsBase(int p_76493_1_) {
        return (double)p_76493_1_ >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        int i = this.basePos[0];
        int j = this.basePos[1];
        int k = this.basePos[1] + this.height;
        int l = this.basePos[2];
        int[] aint = new int[]{i, j, l};
        int[] aint1 = new int[]{i, k, l};
        this.func_150530_a(aint, aint1, log);
        if (this.trunkSize == 2) {
            aint[0] = aint[0] + 1;
            aint1[0] = aint1[0] + 1;
            this.func_150530_a(aint, aint1, log);
            aint[2] = aint[2] + 1;
            aint1[2] = aint1[2] + 1;
            this.func_150530_a(aint, aint1, log);
            aint[0] = aint[0] + -1;
            aint1[0] = aint1[0] + -1;
            this.func_150530_a(aint, aint1, log);
        }
    }

    void generateLeafNodeBases() {
        int j = this.leafNodes.length;
        int[] aint = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < j; ++i) {
            int[] aint1 = this.leafNodes[i];
            int[] aint2 = new int[]{aint1[0], aint1[1], aint1[2]};
            aint[1] = aint1[3];
            int k = aint[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.func_150530_a(aint, aint2, log);
        }
    }

    int checkBlockLine(int[] p_76496_1_, int[] p_76496_2_) {
        int i;
        int[] aint2 = new int[]{0, 0, 0};
        int b1 = 0;
        for (int b0 = 0; b0 < 3; b0 = (int)((byte)(b0 + 1))) {
            aint2[b0] = p_76496_2_[b0] - p_76496_1_[b0];
            if (Math.abs(aint2[b0]) <= Math.abs(aint2[b1])) continue;
            b1 = b0;
        }
        if (aint2[b1] == 0) {
            return -1;
        }
        byte b2 = otherCoordPairs[b1];
        byte b3 = otherCoordPairs[b1 + 3];
        int b4 = aint2[b1] > 0 ? 1 : -1;
        double d0 = (double)aint2[b2] / (double)aint2[b1];
        double d1 = (double)aint2[b3] / (double)aint2[b1];
        int[] aint3 = new int[]{0, 0, 0};
        int j = aint2[b1] + b4;
        for (i = 0; i != j; i += b4) {
            aint3[b1] = p_76496_1_[b1] + i;
            aint3[b2] = MathHelper.func_76128_c((double)((double)p_76496_1_[b2] + (double)i * d0));
            aint3[b3] = MathHelper.func_76128_c((double)((double)p_76496_1_[b3] + (double)i * d1));
            Block block = this.worldObj.func_147439_a(aint3[0], aint3[1], aint3[2]);
            if (!this.isReplaceable(this.worldObj, aint3[0], aint3[1], aint3[2])) break;
        }
        return i == j ? -1 : Math.abs(i);
    }

    boolean validTreeLocation() {
        int[] aint = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] aint1 = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        Block block = this.worldObj.func_147439_a(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        boolean isSoil = false;
        if (block == Blocks.field_150349_c || block == Blocks.field_150349_c) {
            isSoil = true;
        }
        if (!isSoil) {
            return false;
        }
        int i = this.checkBlockLine(aint, aint1);
        if (i == -1) {
            return true;
        }
        if (i < 6) {
            return false;
        }
        this.heightLimit = i;
        return true;
    }

    public void func_76487_a(double p_76487_1_, double p_76487_3_, double p_76487_5_) {
        this.heightLimitLimit = (int)(p_76487_1_ * 12.0);
        if (p_76487_1_ > 0.5) {
            this.leafDistanceLimit = 2;
        }
        this.scaleWidth = p_76487_3_;
        this.leafDensity = p_76487_5_;
    }

    public boolean func_76484_a(World p_76484_1_, Random p_76484_2_, int p_76484_3_, int p_76484_4_, int p_76484_5_) {
        int l = this.func_150533_a(p_76484_2_);
        if (!this.func_150537_a(p_76484_1_, p_76484_2_, p_76484_3_, p_76484_4_, p_76484_5_, l)) {
            return false;
        }
        this.func_150543_c(p_76484_1_, p_76484_3_, p_76484_5_, p_76484_4_ + l, 2, p_76484_2_);
        for (int i1 = p_76484_4_ + l - 2 - p_76484_2_.nextInt(4); i1 > p_76484_4_ + l / 2; i1 -= 2 + p_76484_2_.nextInt(4)) {
            int l1;
            float f = p_76484_2_.nextFloat() * (float)Math.PI * 2.0f;
            int j1 = p_76484_3_ + (int)(0.5f + MathHelper.func_76134_b((float)f) * 4.0f);
            int k1 = p_76484_5_ + (int)(0.5f + MathHelper.func_76126_a((float)f) * 4.0f);
            for (l1 = 0; l1 < 5; ++l1) {
                j1 = p_76484_3_ + (int)(1.5f + MathHelper.func_76134_b((float)f) * (float)l1);
                k1 = p_76484_5_ + (int)(1.5f + MathHelper.func_76126_a((float)f) * (float)l1);
                this.func_150516_a(p_76484_1_, j1, i1 - 3 + l1 / 2, k1, Blocks.field_150364_r, this.blockMetadata);
            }
            l1 = 1 + p_76484_2_.nextInt(2);
            int i2 = i1;
            for (int j2 = i1 - l1; j2 <= i2; ++j2) {
                int k2 = j2 - i2;
                this.func_150534_b(p_76484_1_, j1, j2, k1, 1 - k2, p_76484_2_);
            }
        }
        for (int l2 = 0; l2 < l; ++l2) {
            Block block = p_76484_1_.func_147439_a(p_76484_3_, p_76484_4_ + l2, p_76484_5_);
            if (block.isAir((IBlockAccess)p_76484_1_, p_76484_3_, p_76484_4_ + l2, p_76484_5_) || block.isLeaves((IBlockAccess)p_76484_1_, p_76484_3_, p_76484_4_ + l2, p_76484_5_)) {
                this.func_150516_a(p_76484_1_, p_76484_3_, p_76484_4_ + l2, p_76484_5_, Blocks.field_150364_r, this.blockMetadata);
                if (l2 > 0) {
                    if (p_76484_2_.nextInt(3) > 0 && p_76484_1_.func_147437_c(p_76484_3_ - 1, p_76484_4_ + l2, p_76484_5_)) {
                        this.func_150516_a(p_76484_1_, p_76484_3_ - 1, p_76484_4_ + l2, p_76484_5_, Blocks.field_150395_bd, 8);
                    }
                    if (p_76484_2_.nextInt(3) > 0 && p_76484_1_.func_147437_c(p_76484_3_, p_76484_4_ + l2, p_76484_5_ - 1)) {
                        this.func_150516_a(p_76484_1_, p_76484_3_, p_76484_4_ + l2, p_76484_5_ - 1, Blocks.field_150395_bd, 1);
                    }
                }
            }
            if (l2 >= l - 1) continue;
            block = p_76484_1_.func_147439_a(p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_);
            if (block.isAir((IBlockAccess)p_76484_1_, p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_) || block.isLeaves((IBlockAccess)p_76484_1_, p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_)) {
                this.func_150516_a(p_76484_1_, p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_, Blocks.field_150364_r, this.blockMetadata);
                if (l2 > 0) {
                    if (p_76484_2_.nextInt(3) > 0 && p_76484_1_.func_147437_c(p_76484_3_ + 2, p_76484_4_ + l2, p_76484_5_)) {
                        this.func_150516_a(p_76484_1_, p_76484_3_ + 2, p_76484_4_ + l2, p_76484_5_, Blocks.field_150395_bd, 2);
                    }
                    if (p_76484_2_.nextInt(3) > 0 && p_76484_1_.func_147437_c(p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_ - 1)) {
                        this.func_150516_a(p_76484_1_, p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_ - 1, Blocks.field_150395_bd, 1);
                    }
                }
            }
            if ((block = p_76484_1_.func_147439_a(p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_ + 1)).isAir((IBlockAccess)p_76484_1_, p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_ + 1) || block.isLeaves((IBlockAccess)p_76484_1_, p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_ + 1)) {
                this.func_150516_a(p_76484_1_, p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_ + 1, Blocks.field_150364_r, this.blockMetadata);
                if (l2 > 0) {
                    if (p_76484_2_.nextInt(3) > 0 && p_76484_1_.func_147437_c(p_76484_3_ + 2, p_76484_4_ + l2, p_76484_5_ + 1)) {
                        this.func_150516_a(p_76484_1_, p_76484_3_ + 2, p_76484_4_ + l2, p_76484_5_ + 1, Blocks.field_150395_bd, 2);
                    }
                    if (p_76484_2_.nextInt(3) > 0 && p_76484_1_.func_147437_c(p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_ + 2)) {
                        this.func_150516_a(p_76484_1_, p_76484_3_ + 1, p_76484_4_ + l2, p_76484_5_ + 2, Blocks.field_150395_bd, 4);
                    }
                }
            }
            if (!(block = p_76484_1_.func_147439_a(p_76484_3_, p_76484_4_ + l2, p_76484_5_ + 1)).isAir((IBlockAccess)p_76484_1_, p_76484_3_, p_76484_4_ + l2, p_76484_5_ + 1) && !block.isLeaves((IBlockAccess)p_76484_1_, p_76484_3_, p_76484_4_ + l2, p_76484_5_ + 1)) continue;
            this.func_150516_a(p_76484_1_, p_76484_3_, p_76484_4_ + l2, p_76484_5_ + 1, Blocks.field_150364_r, this.blockMetadata);
            if (l2 <= 0) continue;
            if (p_76484_2_.nextInt(3) > 0 && p_76484_1_.func_147437_c(p_76484_3_ - 1, p_76484_4_ + l2, p_76484_5_ + 1)) {
                this.func_150516_a(p_76484_1_, p_76484_3_ - 1, p_76484_4_ + l2, p_76484_5_ + 1, Blocks.field_150395_bd, 8);
            }
            if (p_76484_2_.nextInt(3) <= 0 || !p_76484_1_.func_147437_c(p_76484_3_, p_76484_4_ + l2, p_76484_5_ + 2)) continue;
            this.func_150516_a(p_76484_1_, p_76484_3_, p_76484_4_ + l2, p_76484_5_ + 2, Blocks.field_150395_bd, 4);
        }
        return true;
    }

    private void func_150543_c(World p_150543_1_, int p_150543_2_, int p_150543_3_, int p_150543_4_, int p_150543_5_, Random p_150543_6_) {
        int b0 = 2;
        for (int i1 = p_150543_4_ - b0; i1 <= p_150543_4_; ++i1) {
            int j1 = i1 - p_150543_4_;
            this.func_150535_a(p_150543_1_, p_150543_2_, i1, p_150543_3_, p_150543_5_ + 1 - j1, p_150543_6_);
        }
    }
}

