-- Creates help window links to the other scripts in the Samples folder.
-- Author: Andrew Trevorrow (andrew@trevorrow.com).

local glu = glu()

-- create the html data
local htmldata = [[
<html><title>Samples</title>
<body bgcolor="#FFFFCE">

<p>
The Samples folder contains a number of small scripts that illustrate
Glu's capabilities.  Feel free to borrow their code for use in your own scripts.

<p>
To run a script, just click on its link.
Or to open a script in your <a href="prefs:file">preferred text editor</a>,
control-click or right-click on its link.

<p>
<ul>
<li>
<a href="open:Scripts/Samples/bouncing-ball.lua">bouncing-ball.lua</a> &mdash;
An example of a simple animation.
</li>

<li>
<a href="open:Scripts/Samples/buttons.lua">buttons.lua</a> &mdash;
The <a href="Help/cplus.html">cplus</a> module supports buttons, sliders, check boxes, etc.
</li>

<li>
<a href="open:Scripts/Samples/console.lua">console.lua</a> &mdash;
A simple script that opens Glu's <a href="Help/console.html">console window</a>.
</li>

<li>
<a href="open:Scripts/Samples/coordinates.lua">coordinates.lua</a> &mdash;
Illustrates the canvas coordinates.
</li>

<li>
<a href="open:Scripts/Samples/dialogs.lua">dialogs.lua</a> &mdash;
Glu supports a number of native dialog boxes.
</li>

<li>
<a href="open:Scripts/Samples/events.lua">events.lua</a> &mdash;
Prints the results of Glu's <a href="Help/glu.html#getevent">getevent</a>
function in the console window.
</li>

<li>
<a href="open:Scripts/Samples/getdir.lua">getdir.lua</a> &mdash;
Prints the various directory paths returned by Glu's
<a href="Help/glu.html#getdir">getdir</a> function.
</li>

<li>
<a href="open:Scripts/Samples/icons.lua">icons.lua</a> &mdash;
Creates a canvas with the Glu application icon at various sizes.
</li>

<li>
<a href="open:Scripts/Samples/menus.lua">menus.lua</a> &mdash;
Shows how to create a menu bar and a pop-up menu.
</li>

<li>
<a href="open:Scripts/Samples/your-scripts.lua">your-scripts.lua</a> &mdash;
Creates clickable links to all the Lua files in
<a href="prefs:file">your scripts folder</a>.
</li>
</ul>

<p>
Note that some of the scripts
(<a href="open:Scripts/Samples/coordinates.lua">coordinates.lua</a> and
<a href="open:Scripts/Samples/icons.lua">icons.lua</a>)
don't delete the canvas when they finish.
There are a number of ways to remove the canvas and return to the
startup.lua interface: click anywhere in the viewport, hit the escape key,
or select Delete Canvas from the File menu.

</body></html>
]]

-- copy the html data to a temporary file
local htmlfile = glu.getdir("temp").."samples.html"
local f = io.open(htmlfile,"w")
if not f then
    glu.exit("Failed to create samples.html!")
end
f:write(htmldata)
f:close()

-- display the html file in the help window
glu.help(htmlfile)
