-- This script illustrates the canvas coordinates.

local cv = canvas()
local cp = require "cplus"

cvwd, cvht = 400, 200
cv.create(cvwd, cvht)
cv.position("middle")
cv.rgba(cp.blue)
cv.fill()

-- draw white pixels in top left and bottom right corners
cv.rgba(cp.white)
cv.setpixel(0, 0)
cv.setpixel(cvwd-1, cvht-1)

cv.blend(2)
cv.font("", 9)
cp.maketext("The (x,y) coordinates of the top left pixel are always (0,0).\n"..
            "x coordinates increase from left to right.\n"..
            "y coordinates increase from top to bottom.")
cp.pastetext(5, 0)

textwd, textht = cp.maketext("The (x,y) coordinates of the bottom right pixel are ("..(cvwd-1)..","..(cvht-1)..").")
cp.pastetext(cvwd-textwd-5, cvht-textht-5)

cv.font("", 12)
textwd, textht = cp.maketext("This canvas is "..cvwd.." pixels wide and "..cvht.." pixels high.")
cp.pastetext((cvwd-textwd)//2, (cvht-textht)//2)
