-- Display the results of glu.getevent in Glu's console window.

local glu = glu()
local cv = canvas()

glu.settitle("Events")
cv.create(600,400)
cv.position("middle")
cv.fill()
cv.rgba(0,0,0,255)
_, ht, _ = cv.text("text", [[
Hit keys and click inside/outside this canvas to see the
results of the getevent function in Glu's console window.

Note that the transparent pixels in the hole below belong
to the viewport, not the canvas.
]])
cv.blend(1)
cv.paste("text", 10, 10)
cv.blend(0)
cv.rgba(0,0,0,0)
cv.fill(10, ht+10, 100, 100) -- transparent rectangle
glu.update()

print([[
The strings returned by Glu's getevent function will be displayed
in this window, so move it to a position where you can see the lines
being added, then switch back to the Glu window and start clicking,
zooming, hitting keys, etc.
]])

glu.filetypes("") -- get a "file" event for any file type

while true do
    local event = glu.getevent()
    if #event > 0 then print(event) end
end
