-- This script was used to create the Glu app icons.

local cv = canvas()
local cp = require "cplus"

cv.create(768, 512)
cv.position("middle")

local function draw_icon(size, xo, yo)
    -- draw a blue stylized G
    local linewd = size//8
    cv.rgba(cp.blue)
    cp.round_rect(xo, yo, size, size, size//4, linewd, cp.cyan)
    cv.fill(xo+size//2-linewd//2, yo+size//2-linewd//2, size//2-linewd//2, linewd)
    cv.fill(xo+size//2-linewd//2, yo+size//2+linewd//2, linewd, size//4-linewd//2)
end

draw_icon(512, 0, 0)
draw_icon(256, 512, 0)
draw_icon(128, 512, 256)
draw_icon(64, 640, 256)
draw_icon(48, 512, 384)
draw_icon(32, 560, 384)
draw_icon(16, 592, 384)
