/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.xml.datatype.SecuritySupport;

class FactoryFinder {
    private static boolean debug = false;
    static Properties cacheProps = new Properties();
    static volatile boolean firstTime = true;
    static SecuritySupport ss = new SecuritySupport();

    FactoryFinder() {
    }

    private static void dPrint(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    private static Class getProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException {
        try {
            if (cl == null) {
                cl = ss.getContextClassLoader();
                if (cl == null) {
                    throw new ClassNotFoundException();
                }
                return cl.loadClass(className);
            }
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e1) {
            if (doFallback) {
                return Class.forName(className, true, FactoryFinder.class.getClassLoader());
            }
            throw e1;
        }
    }

    static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class providerClass = FactoryFinder.getProviderClass(className, cl, doFallback);
            Object instance = providerClass.newInstance();
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + providerClass + " using ClassLoader: " + cl);
            }
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        Object provider;
        block15: {
            block14: {
                FactoryFinder.dPrint("find factoryId =" + factoryId);
                try {
                    String systemProp = ss.getSystemProperty(factoryId);
                    if (systemProp != null) {
                        FactoryFinder.dPrint("found system property, value=" + systemProp);
                        return FactoryFinder.newInstance(systemProp, null, true);
                    }
                }
                catch (SecurityException se) {
                    if (!debug) break block14;
                    se.printStackTrace();
                }
            }
            try {
                String factoryClassName = null;
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            String configFile = ss.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                            File f = new File(configFile);
                            firstTime = false;
                            if (ss.doesFileExist(f)) {
                                FactoryFinder.dPrint("Read properties file " + f);
                                cacheProps.load(ss.getFileInputStream(f));
                            }
                        }
                    }
                }
                if ((factoryClassName = cacheProps.getProperty(factoryId)) != null) {
                    FactoryFinder.dPrint("found in $java.home/jaxp.properties, value=" + factoryClassName);
                    return FactoryFinder.newInstance(factoryClassName, null, true);
                }
            }
            catch (Exception ex) {
                if (!debug) break block15;
                ex.printStackTrace();
            }
        }
        if ((provider = FactoryFinder.findJarServiceProvider(factoryId)) != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        FactoryFinder.dPrint("loaded from fallback value: " + fallbackClassName);
        return FactoryFinder.newInstance(fallbackClassName, null, true);
    }

    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = ss.getContextClassLoader();
        if (cl != null) {
            is = ss.getResourceAsStream(cl, serviceId);
            if (is == null) {
                cl = FactoryFinder.class.getClassLoader();
                is = ss.getResourceAsStream(cl, serviceId);
            }
        } else {
            cl = FactoryFinder.class.getClassLoader();
            is = ss.getResourceAsStream(cl, serviceId);
        }
        if (is == null) {
            return null;
        }
        if (debug) {
            FactoryFinder.dPrint("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        }
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is));
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
            rd.close();
        }
        catch (IOException x) {
            return null;
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            FactoryFinder.dPrint("found in resource, value=" + factoryClassName);
            return FactoryFinder.newInstance(factoryClassName, cl, false);
        }
        return null;
    }

    static {
        try {
            String val = ss.getSystemProperty("jaxp.debug");
            debug = val != null && !"false".equals(val);
        }
        catch (SecurityException se) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }

        @Override
        public Throwable getCause() {
            return this.exception;
        }
    }
}

