// This is an Unreal Script
class X2Ability_EngineerAbilitySet extends X2Ability config(EngineerAbilities);

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Templates;

	Templates.AddItem(CQBTraining());
	Templates.AddItem(ExplosiveRounds());
	Templates.AddItem(FlakVest());
	Templates.AddItem(Nanobots());
	Templates.AddItem(PulseRounds());
	Templates.AddItem(DuckandCover());

	Templates.AddItem(EngBoom());

	return Templates;
}

//PulseRounds

static function X2AbilityTemplate PulseRounds()
{
	local X2AbilityTemplate                 Template;
	local X2AbilityCost_Ammo                AmmoCost;
	local X2AbilityCost_ActionPoints		ActionPointCost;
	local X2AbilityCharges					Charges;
	local X2AbilityCost_Charges				ChargeCost;
	local X2Effect_ApplyWeaponDamage        WeaponDamageEffect;
	local X2Condition_UnitProperty			UnitCondition;
	local array<name>                       SkipExclusions;

	Template= new(None, string('PulseRounds')) class'X2AbilityTemplate'; Template.SetTemplateName('PulseRounds');;;

	// Icon Properties
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_bulletswarm";
	Template.ShotHUDPriority = class'UIUtilities_Tactical'.const.CLASS_COLONEL_PRIORITY;
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.DisplayTargetHitChance = true;
	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.AbilityConfirmSound = "TacticalUI_ActivateAbility";

	// Activated by a button press; additionally, tells the AI this is an activatable
	Template.AbilityTriggers.AddItem(default.PlayerInputTrigger);

	// *** VALIDITY CHECKS *** //
	//  Normal effect restrictions (except disoriented)
	SkipExclusions.AddItem(class'X2AbilityTemplateManager'.default.DisorientedName);
	Template.AddShooterEffectExclusions(SkipExclusions);

	// Targeting Details
	// Can only shoot visible enemies
	Template.AbilityTargetConditions.AddItem(default.GameplayVisibilityCondition);
	// Can't target dead; Can't target friendlies
	Template.AbilityTargetConditions.AddItem(default.LivingHostileTargetProperty);
	// Can't shoot while dead
	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	// Only at single targets that are in range.
	Template.AbilityTargetStyle = default.SimpleSingleTarget;

	// Ammo
	AmmoCost = new class'X2AbilityCost_Ammo';
	AmmoCost.iAmmo = 0;
	Template.AbilityCosts.AddItem(AmmoCost);
	Template.bAllowAmmoEffects = false; // 	

	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;
	ActionPointCost.bConsumeAllPoints = true;
	Template.AbilityCosts.AddItem(ActionPointCost);

	Charges = new class'X2AbilityCharges';
	Charges.InitialCharges = 1;
	Template.AbilityCharges = Charges;

	ChargeCost = new class'X2AbilityCost_Charges';
	ChargeCost.NumCharges = 1;
	Template.AbilityCosts.AddItem(ChargeCost);

	//UniCondition

	UnitCondition = new class'X2Condition_UnitProperty';
	UnitCondition.ExcludeOrganic = true;
	UnitCondition.IncludeWeakAgainstTechLikeRobot = true;
	UnitCondition.ExcludeFriendlyToSource = false;

	// Damage Effect
	WeaponDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	//WeaponDamageEffect.
	WeaponDamageEffect.DamageTypes.AddItem('Electrical');
	WeaponDamageEffect.TargetConditions.AddItem(UnitCondition);
	WeaponDamageEffect.bShowImmunityAnyFailure = true;
	WeaponDamageEffect.EffectDamageValue.Damage = 12; //This will make weapon damage + set value
	Template.AddTargetEffect(WeaponDamageEffect);

	// Hit Calculation (Different weapons now have different calculations for range)
	Template.AbilityToHitCalc = default.SimpleStandardAim;
	Template.AbilityToHitOwnerOnMissCalc = default.SimpleStandardAim;

	// Targeting Method
	Template.TargetingMethod = class'X2TargetingMethod_OverTheShoulder';
	Template.bUsesFiringCamera = true;
	Template.CinescriptCameraType = "StandardGunFiring";

	// MAKE IT LIVE!
	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;
	Template.bCrossClassEligible = false;
	return Template;
}

//ExplosiveRounds (Critical Damage, +Rupture enemy making them take +2 damage on all further attacks. x2 Uses per mission, uses no ammo)

static function X2AbilityTemplate ExplosiveRounds()
{
	local X2AbilityTemplate                 Template;
	local X2AbilityCost_Ammo                AmmoCost;
	local X2AbilityCost_ActionPoints		ActionPointCost;
	local X2AbilityCharges					Charges;
	local X2AbilityCost_Charges				ChargeCost;
	local X2Effect_ApplyWeaponDamage        WeaponDamageEffect;
	local array<name>                       SkipExclusions;

	Template= new(None, string('ExplosiveRounds')) class'X2AbilityTemplate'; Template.SetTemplateName('ExplosiveRounds');;;

	// Icon Properties
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_ammo_incendiary";
	Template.ShotHUDPriority = class'UIUtilities_Tactical'.const.CLASS_COLONEL_PRIORITY;
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.DisplayTargetHitChance = true;
	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.AbilityConfirmSound = "TacticalUI_ActivateAbility";

	// Activated by a button press; additionally, tells the AI this is an activatable
	Template.AbilityTriggers.AddItem(default.PlayerInputTrigger);

	// *** VALIDITY CHECKS *** //
	//  Normal effect restrictions (except disoriented)
	SkipExclusions.AddItem(class'X2AbilityTemplateManager'.default.DisorientedName);
	Template.AddShooterEffectExclusions(SkipExclusions);

	// Targeting Details
	// Can only shoot visible enemies
	Template.AbilityTargetConditions.AddItem(default.GameplayVisibilityCondition);
	// Can't target dead; Can't target friendlies
	Template.AbilityTargetConditions.AddItem(default.LivingHostileTargetProperty);
	// Can't shoot while dead
	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	// Only at single targets that are in range.
	Template.AbilityTargetStyle = default.SimpleSingleTarget;

	// Ammo
	AmmoCost = new class'X2AbilityCost_Ammo';
	AmmoCost.iAmmo = 0;
	Template.AbilityCosts.AddItem(AmmoCost);
	Template.bAllowAmmoEffects = false; // 	

	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;
	ActionPointCost.bConsumeAllPoints = true;
	Template.AbilityCosts.AddItem(ActionPointCost);

	Charges = new class'X2AbilityCharges';
	Charges.InitialCharges = 1;
	Template.AbilityCharges = Charges;

	ChargeCost = new class'X2AbilityCost_Charges';
	ChargeCost.NumCharges = 1;
	Template.AbilityCosts.AddItem(ChargeCost);

	// Damage Effect
	WeaponDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	//WeaponDamageEffect.
	WeaponDamageEffect.bExplosiveDamage = true;
	WeaponDamageEffect.EffectDamageValue.Rupture = 1; //Rupture Value
	Template.AddTargetEffect(WeaponDamageEffect);

	// Hit Calculation (Different weapons now have different calculations for range)
	Template.AbilityToHitCalc = default.SimpleStandardAim;
	Template.AbilityToHitOwnerOnMissCalc = default.SimpleStandardAim;

	// Targeting Method
	Template.TargetingMethod = class'X2TargetingMethod_OverTheShoulder';
	Template.bUsesFiringCamera = true;
	Template.CinescriptCameraType = "StandardGunFiring";

	// MAKE IT LIVE!
	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;
	Template.bCrossClassEligible = false;
	return Template;
}

//Nanobots (HP Regen?) [WORKS!]

static function X2AbilityTemplate Nanobots()
{
	local X2AbilityTemplate                 Template;
	local X2Effect_Regeneration				RegenerationEffect;

	Template= new(None, string('Nanobots')) class'X2AbilityTemplate'; Template.SetTemplateName('Nanobots');;;
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_defend_health";

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	// Build the regeneration effect
	RegenerationEffect = new class'X2Effect_Regeneration';
	RegenerationEffect.BuildPersistentEffect(1, true, true, false, eGameRule_PlayerTurnBegin); //t,t,f original
	RegenerationEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	RegenerationEffect.HealAmount = 1;
	RegenerationEffect.MaxHealAmount = 6;
	RegenerationEffect.HealthRegeneratedName = 'Nanobots';
	Template.AddTargetEffect(RegenerationEffect);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.bCrossClassEligible = true;

	return Template;
}

//Flak Vest (+2HP)
static function X2AbilityTemplate FlakVest()
{
	local X2AbilityTemplate						Template;
	local X2Effect_PersistentStatChange         Health;

	// Icon Properties
	`CREATE_X2ABILITY_TEMPLATE(Template, 'FlakVest');
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_extrapadding";

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	Health = new class'X2Effect_PersistentStatChange';
	Health.AddPersistentStatChange(eStat_HP, 2);
	Health.BuildPersistentEffect(1, true, false, false);
	Health.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	Template.AddTargetEffect(Health);
	Template.SetUIStatMarkup(class'XLocalizedData'.default.HealthLabel, eStat_HP, 2);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//  NOTE: No visualization on purpose!
	Template.bCrossClassEligible = true;

	return Template;
}

//CQB Training (+5Dodge, +5% CRI)
static function X2AbilityTemplate CQBTraining()
{
	local X2AbilityTemplate						Template;
	local X2Effect_PersistentStatChange         Dodge;
	local X2Effect_ToHitModifier                ToCRIModifier;

	// Icon Properties
	`CREATE_X2ABILITY_TEMPLATE(Template, 'CQBTraining');
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_aggression";

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	Dodge = new class'X2Effect_PersistentStatChange';
	Dodge.AddPersistentStatChange(eStat_Dodge, 5);
	Dodge.BuildPersistentEffect(1, true, false, false);
	Dodge.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	Template.AddTargetEffect(Dodge);
	Template.SetUIStatMarkup(class'XLocalizedData'.default.DefenseLabel, eStat_Dodge, 5);

	// INCREASE CHANCE TO CRI
	ToCRIModifier = new class'X2Effect_ToHitModifier';
	ToCRIModifier.BuildPersistentEffect(1, true, true, true);
	ToCRIModifier.AddEffectHitModifier(eHit_Crit, 5, Template.LocFriendlyName, /*StandardCri*/, false, true, true, true);
	Template.AddTargetEffect(ToCRIModifier);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//  NOTE: No visualization on purpose!
	Template.bCrossClassEligible = true;

	return Template;
}

//Duck and Cover! (+3 Mobility, +10 Defense)
static function X2AbilityTemplate DuckandCover()
{
	local X2AbilityTemplate						Template;
	local X2Effect_PersistentStatChange         Mobile;
	local X2Effect_PersistentStatChange         Defense;

	// Icon Properties
	`CREATE_X2ABILITY_TEMPLATE(Template, 'DuckandCover');
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_lowprofile";

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);

	Mobile = new class'X2Effect_PersistentStatChange';
	Mobile.AddPersistentStatChange(eStat_Mobility, 3);
	Mobile.BuildPersistentEffect(1, true, false, false);
	Template.AddTargetEffect(Mobile);
	Template.SetUIStatMarkup(class'XLocalizedData'.default.MobilityLabel, eStat_Mobility, 3);

	Defense = new class'X2Effect_PersistentStatChange';
	Defense.AddPersistentStatChange(eStat_Defense, 10);
	Defense.BuildPersistentEffect(1, true, false, false);
	Defense.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	Template.AddTargetEffect(Defense);
	Template.SetUIStatMarkup(class'XLocalizedData'.default.DefenseLabel, eStat_Defense, 10);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//  NOTE: No visualization on purpose!
	Template.bCrossClassEligible = true;

	return Template;
}

//Engineer GTS "Biggest Booms"
static function X2AbilityTemplate EngBoom()
{
	local X2AbilityTemplate						Template;
	local X2AbilityTargetStyle                  TargetStyle;
	local X2AbilityTrigger						Trigger;
	local X2Effect_BiggestBooms                 BiggestBoomsEffect;

	Template= new(None, string('EngBoom')) class'X2AbilityTemplate'; Template.SetTemplateName('EngBoom');;;

	// Icon Properties
	Template.IconImage = "img:///UILibrary_PerkIcons.UIPerk_biggestbooms";

	Template.AbilitySourceName = 'eAbilitySource_Perk';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;

	TargetStyle = new class'X2AbilityTarget_Self';
	Template.AbilityTargetStyle = TargetStyle;

	Trigger = new class'X2AbilityTrigger_UnitPostBeginPlay';
	Template.AbilityTriggers.AddItem(Trigger);

	BiggestBoomsEffect = new class'X2Effect_BiggestBooms';
	BiggestBoomsEffect.BuildPersistentEffect(1, true, true, true);
	BiggestBoomsEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage,,,Template.AbilitySourceName);
	Template.AddTargetEffect(BiggestBoomsEffect);

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	//  NOTE: No visualization on purpose!

	return Template;
}
