// This is an Unreal Script
class X2StrategyElement_AcademyUnlocksEngineer extends X2StrategyElement;   //Class Data

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Templates;
		
	Templates.AddItem(EngBoom());   //Skill Data

	return Templates;
}

static function X2SoldierAbilityUnlockTemplate EngBoom()   //Skill Data
{
	local X2SoldierAbilityUnlockTemplate Template;
	local ArtifactCost Resources;

	`CREATE_X2TEMPLATE(class'X2SoldierAbilityUnlockTemplate', Template, 'EngBoom');   //Skill Data

	Template.AllowedClasses.AddItem('Engineer');   //Class Data
	Template.AbilityName = 'EngBoom';   //Skill Data
	Template.strImage = "img:///UILibrary_StrategyImages.GTS.GTS_Grenadier"; //ICON

	// Requirements
	Template.Requirements.RequiredHighestSoldierRank = 5;
	Template.Requirements.RequiredSoldierClass = 'Engineer';   //Class Data
	Template.Requirements.RequiredSoldierRankClassCombo = true;
	Template.Requirements.bVisibleIfSoldierRankGatesNotMet = true;

	// Cost
	Resources.ItemTemplateName = 'Supplies';
	Resources.Quantity = 75;
	Template.Cost.ResourceCosts.AddItem(Resources);

	return Template;
}