/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.toolheadswapper;

import de.ellpeck.toolheadswapper.ToolHeadSwapper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class RecipeSwapHead
implements IRecipe {
    private static final String[] COMPARE_BASE = new String[]{"Pickaxe", "Axe", "Shovel", "Sword", "Hoe"};
    private static final Map<String, Integer> COMPARE = new HashMap<String, Integer>();

    private static ItemStack getOutputFromInputs(InventoryCrafting inv, boolean breakWhenFound) {
        ItemStack oldTool = null;
        ItemStack newTool = null;
        boolean foundSwap = false;
        for (int iterate = 0; iterate < 2; ++iterate) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() == null) continue;
                boolean isTool = stack.func_77973_b().isRepairable();
                if (iterate == 0) {
                    if (!isTool) continue;
                    if (oldTool == null) {
                        oldTool = stack;
                        continue;
                    }
                    return null;
                }
                if (isTool) continue;
                if (oldTool == null) {
                    return null;
                }
                newTool = RecipeSwapHead.getNewTool(oldTool, stack);
                if (newTool == null) continue;
                if (breakWhenFound) {
                    return newTool;
                }
                if (!foundSwap) {
                    foundSwap = true;
                    continue;
                }
                return null;
            }
        }
        return foundSwap ? newTool : null;
    }

    private static ItemStack getNewTool(ItemStack oldStack, ItemStack repair) {
        for (Item newItem : ToolHeadSwapper.ALL_TOOLS) {
            ItemStack newStack;
            if (newItem == oldStack.func_77973_b() || newItem.func_77612_l() < oldStack.func_77973_b().func_77612_l()) continue;
            int newDamage = 0;
            if (ToolHeadSwapper.keepDurability) {
                int damageTaken = oldStack.func_77958_k() - oldStack.func_77952_i();
                newDamage = newItem.func_77612_l() - damageTaken;
            }
            if (!newItem.func_82789_a(newStack = new ItemStack(newItem, 1, newDamage), repair) || !RecipeSwapHead.areSameToolType(oldStack, newStack)) continue;
            if (oldStack.func_77942_o()) {
                newStack.func_77982_d(oldStack.func_77978_p().func_74737_b());
            }
            return newStack;
        }
        return null;
    }

    private static boolean areSameToolType(ItemStack stack1, ItemStack stack2) {
        Set toolClasses1 = stack1.func_77973_b().getToolClasses(stack1);
        Set toolClasses2 = stack2.func_77973_b().getToolClasses(stack2);
        if (toolClasses1 != null && toolClasses2 != null && !toolClasses1.isEmpty() && toolClasses1.equals(toolClasses2)) {
            return true;
        }
        String reg1 = stack1.func_77973_b().getRegistryName().toString();
        String reg2 = stack2.func_77973_b().getRegistryName().toString();
        int compared1 = -1;
        int compared2 = -1;
        for (Map.Entry<String, Integer> s : COMPARE.entrySet()) {
            String key = s.getKey();
            String keyLower = s.getKey().toLowerCase(Locale.ROOT);
            if (reg1.contains(key) || reg1.startsWith(keyLower)) {
                compared1 = s.getValue();
            }
            if (reg2.contains(key) || reg2.startsWith(keyLower)) {
                compared2 = s.getValue();
            }
            if (compared1 < 0 || compared2 < 0) continue;
            return compared1 == compared2;
        }
        return false;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return RecipeSwapHead.getOutputFromInputs(inv, false) != null;
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        return RecipeSwapHead.getOutputFromInputs(inv, false);
    }

    public int func_77570_a() {
        return 4;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return null;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        ItemStack[] stacks = new ItemStack[inv.func_70302_i_()];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = ForgeHooks.getContainerItem((ItemStack)inv.func_70301_a(i));
        }
        return stacks;
    }

    static {
        for (int i = 0; i < COMPARE_BASE.length; ++i) {
            String s = COMPARE_BASE[i];
            COMPARE.put(s, i);
            String sLower = s.toLowerCase(Locale.ROOT);
            COMPARE.put("_" + sLower, i);
            COMPARE.put(sLower + "_", i);
        }
    }
}

