/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.toolheadswapper;

import de.ellpeck.toolheadswapper.RecipeSwapHead;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;

@Mod(modid="toolheadswapper", name="Tool Head Swapper", version="1.10.2-r2", acceptedMinecraftVersions="[1.10.2]")
public class ToolHeadSwapper {
    public static final String MOD_ID = "toolheadswapper";
    public static final String NAME = "Tool Head Swapper";
    public static final String VERSION = "1.10.2-r2";
    public static final List<Item> ALL_TOOLS = new ArrayList<Item>();
    private static final List<Item> EXCEPTIONS = new ArrayList<Item>();
    public static boolean keepDurability;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        String[] exceptionNames;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        keepDurability = config.get("general", "keepDurability", true, "If tools that are created via head swapping should keep the durability of the original tool. When turned off, newly created tools will have full durability.").getBoolean();
        for (String name : exceptionNames = config.get("general", "exceptions", new String[0], "Registry names of tools that should not be able to be created via head swapping.").getStringList()) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
            if (item == null) continue;
            EXCEPTIONS.add(item);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        for (Item item : Item.field_150901_e) {
            if (EXCEPTIONS.contains(item) || !item.isRepairable()) continue;
            ALL_TOOLS.add(item);
        }
        GameRegistry.addRecipe((IRecipe)new RecipeSwapHead());
        RecipeSorter.register((String)MOD_ID, RecipeSwapHead.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }
}

