Scriptname ENC_SoulExtractorScript extends ObjectReference  

Int DoOnce
ObjectReference Property MyEffect Auto

Event OnActivate(ObjectReference akActionRef)
	If DoOnce == 0
		Debug.MessageBox("The soul extraction station will sap enchantment points from any enchanted weapon, manefesting the energy into useable soul gems. The weapon is lost in this process.")
		DoOnce = 1
	Endif
EndEvent

Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer)
	if !akItemReference.GetBaseObject() as weapon && akItemReference.GetEnchantment() != NONE
		Self.RemoveItem(akBaseItem, akOtherContainer = Game.GetPlayer())
		Debug.MessageBox("You may only extract soul energy from enchanted weapons")
	Else
		Self.GetLinkedRef().Enable(True)
		MyEffect.Enable(true)
	Endif
EndEvent

Event OnItemRemoved(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer)
	if Self.GetNumItems() < 1
		Self.GetLinkedRef().Disable(True)
		MyEffect.Disable(true)
	Endif
EndEvent