/*
 * Grace - GRaphing, Advanced Computation and Exploration of data
 * 
 * Home page: http://plasma-gate.weizmann.ac.il/Grace/
 * 
 * Copyright (c) 1991-95 Paul J Turner, Portland, OR
 * Copyright (c) 1996-99 GRACE Development Team
 * 
 * Maintained by Evgeny Stambulchik
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __BITMAPS_H_
#define __BITMAPS_H_

#define auto_width 16
#define auto_height 16
static unsigned char auto_bits[] = {
   0x00, 0x00, 0x18, 0x00, 0x18, 0x00, 0x3c, 0x00, 0x3c, 0x06, 0x66, 0x1e,
   0x7e, 0x76, 0xc3, 0x76, 0xc3, 0x06, 0x00, 0x1c, 0x00, 0x78, 0x00, 0x60,
   0x00, 0x66, 0x00, 0x7e, 0x00, 0x78, 0x00, 0x00};
#define down_width 16
#define down_height 16
static unsigned char down_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01,
   0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xc0, 0x01, 0xf8, 0x0f, 0xf0, 0x07,
   0xe0, 0x03, 0xc0, 0x01, 0x80, 0x00, 0x00, 0x00};
#define expand_width 16
#define expand_height 16
static unsigned char expand_bits[] = {
   0xfe, 0xff, 0x82, 0x83, 0xc2, 0x87, 0x02, 0x81, 0x02, 0x81, 0x4a, 0xa5,
   0x0e, 0xe1, 0xfe, 0xff, 0x0e, 0xe1, 0x4a, 0xa5, 0x02, 0x81, 0x02, 0x81,
   0xc2, 0x87, 0x82, 0x83, 0xfe, 0xff, 0x00, 0x00};
#define left_width 16
#define left_height 16
static unsigned char left_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x30, 0x00, 0x38, 0x00,
   0xfc, 0x3f, 0xfe, 0x3f, 0xfc, 0x3f, 0x38, 0x00, 0x30, 0x00, 0x20, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define right_width 16
#define right_height 16
static unsigned char right_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x0c,
   0x00, 0x1c, 0xfc, 0x3f, 0xfc, 0x7f, 0xfc, 0x3f, 0x00, 0x1c, 0x00, 0x0c,
   0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define shrink_width 16
#define shrink_height 16
static unsigned char shrink_bits[] = {
   0x54, 0x55, 0x02, 0x81, 0xc0, 0x07, 0x82, 0x83, 0x00, 0x01, 0xca, 0xa7,
   0x58, 0x34, 0x7e, 0xfc, 0x58, 0x34, 0xca, 0xa7, 0x00, 0x01, 0x82, 0x83,
   0xc0, 0x07, 0x02, 0x81, 0x54, 0x55, 0x00, 0x00};
#define up_width 16
#define up_height 16
static unsigned char up_bits[] = {
   0x00, 0x00, 0x00, 0x01, 0x80, 0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x1f,
   0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03,
   0x80, 0x03, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00};
#define zoom_width 16
#define zoom_height 16
static unsigned char zoom_bits[] = {
   0x00, 0x00, 0x70, 0x00, 0xd8, 0x00, 0x8c, 0x01, 0x06, 0x03, 0x02, 0x02,
   0x06, 0x03, 0x8c, 0x01, 0xd8, 0x03, 0x70, 0x07, 0x00, 0x0e, 0x00, 0x1c,
   0x00, 0x38, 0x00, 0x70, 0x00, 0xe0, 0x00, 0x40};

#define isom_width 16
#define isom_height 16
static unsigned char isom_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x1f, 0x08, 0x10, 0x08, 0x10,
   0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10,
   0xf8, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define noisom_width 16
#define noisom_height 16
static unsigned char noisom_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xf0, 0x07, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04,
   0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04,
   0x10, 0x04, 0xf0, 0x07, 0x00, 0x00, 0x00, 0x00};


#endif /* __BITMAPS_H_ */
