/** File computils.h
 *  
 *  Please don't change order in enums without changing gg_CreatePanelChoice calls
 */

#ifndef __COMPUTILS_H_
#define __COMPUTILS_H_

void comment_and_legend_set (int gno ,int setno ,char *buf);

/****** Finite differencing/derivating *******/

typedef enum {
  DIFF_TYPE_PLAIN
  ,DIFF_TYPE_DERIVATIVE
} DIFF_type;

typedef enum {
  DIFF_XPLACE_LEFT
  ,DIFF_XPLACE_CENTER
  ,DIFF_XPLACE_RIGHT
} DIFF_xplace;

typedef struct _DIFFParams DIFFParams;

struct _DIFFParams {
  DIFF_type   derivative;
  DIFF_xplace xplace;
  int         period;
};

void diff_set_defaults  (void);
int  diff_params_get    (DIFFParams *p);
int  diff_params_set    (DIFFParams *p);

int  do_diff	       (int gno1 ,int setno1 ,int gno2 ,int setno2);
void do_diff_command   (int gno1 ,int setno1 ,DIFF_xplace xplace);
void do_diff_command_1 (int gno1 ,int setno1 ,DIFF_xplace xplace
			,DIFF_type   derivative
			,int         period
			);


#endif /* __COMPUTILS_H_ */
