/** File fourier.h
 */

#ifndef __FOURIER_H_
#define __FOURIER_H_

#ifdef WITH_GTK
void gg_fourier_update (void);
#endif

typedef enum {
  FFT_NORM_NONE = 0
  ,FFT_NORM_SYMMETRIC
  ,FFT_NORM_FORWARD
  ,FFT_NORM_BACKWARD
} FFT_norm;


typedef enum {
  FFT_INPUT_SEG_INDEX
  ,FFT_INPUT_SEG_X
} FFT_input_segment;

typedef enum {
  FFT_XSCALE_INDEX = 0
  ,FFT_XSCALE_NU
  ,FFT_XSCALE_OMEGA
} FFT_xscale;

typedef enum {
  FFT_WINDOW_NONE = 0
  ,FFT_WINDOW_TRIANGULAR
  ,FFT_WINDOW_PARZEN    
  ,FFT_WINDOW_WELCH     
  ,FFT_WINDOW_HANNING   
  ,FFT_WINDOW_HAMMING   
  ,FFT_WINDOW_FLATTOP   
  ,FFT_WINDOW_BLACKMAN  
} FFT_filters;

typedef enum {
  FFT_OUTPUT_MAGNITUDE = 0
  ,FFT_OUTPUT_PHASE
  ,FFT_OUTPUT_RE
  ,FFT_OUTPUT_IM
  ,FFT_OUTPUT_REIM
  ,FFT_OUTPUT_APHI
  ,FFT_OUTPUT_COEFF
} FFT_ouput;

typedef enum {
  FFT_OUTSEGMT_POSITIVE
  ,FFT_OUTSEGMT_HALF_LENGTH
  ,FFT_OUTSEGMT_CENTERED
} FFT_outsegmt;



typedef struct _FFTParams FFTParams;

struct _FFTParams {
  int               invflag;
  FFT_xscale        xscale;
  FFT_norm          norm;
  FFT_input_segment insegmt;
  int          	    complexin;
  int          	    dcdump;
  double       	    oversampling;
  int          	    round2n;
  FFT_filters  	    filter;
  double       	    padding;
  FFT_outsegmt 	    outsegmt;
  FFT_ouput    	    output;
};

void fourier_set_defaults (void);
int fourier_params_get  (FFTParams *p);
int fourier_params_set  (FFTParams *p);
int fourier_nb_out_sets (FFT_ouput output);


  
void do_fourier_command (int gno1 ,int setno1 ,int invflag ,FFT_filters filter);
  
void do_fourier_command_1 (int gno1 ,int setno1 			 
			   ,int invflag
			   ,FFT_xscale xscale
			   ,int complexin
			   ,FFT_filters filter
			   ,FFT_ouput output
			   ,int insegmt ,int outsegmt);
void do_fourier_featext   (int gno1 ,int setno1 ,int *setno2);
  

int do_fourier (int gno1 ,int setno1 ,int gno2 ,int setno2 ,int setno22);

int fourier (double *jr, double *ji, int n, int iflag);


#endif /* __FOURIER_H_ */
