/** File gg_comwin.c
 *  Replace comwin.c
 *  Obsolete: replaced by edit tab in Explorer/Set
 */
#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "defines.h"
#include "parser.h"
#include "graphs.h"
#include "globals.h"
#include "utils.h"
#include "files.h"

#include "gw_list.h"

#include "gg_protos.h"
#include "ge_protos.h"
#include "gg_gtkinc.h"


static gint popup_width = 350  ,popup_height = 350;


static GtkWidget *command_item = NULL;
static GtkTextBuffer *text_buf;
static GtkWidget *follow_me_button;

static void gg_cmd_AAC_CB (GtkWidget *command_item ,gint reponse);

static void gg_comwin_open_file_CB (GtkWidget *w ,gpointer p);
static void gg_comwin_save_file_CB (GtkWidget *w ,gpointer p);
static void follow_me_init_CB      (GtkWidget *w ,gpointer p);

/**
 * Replace  open_command        comwin.c  275
 */
void gg_create_command_popup (void)
{
  GtkWidget *vb ,*menupane ,*menubar;

  if (command_item == NULL) {

    command_item = gg_CreateAACDialog ("Commands" ,gg_cmd_AAC_CB ,0 ,0 ,&vb);
    /* Menubar */
    menubar  = gg_CreateMenuBar (vb);
    menupane = gg_CreateMenu (menubar, "File", 'F', FALSE);
    gg_CreateMenuButton (menupane, "Read file"  , 'O' ,NULL ,gg_comwin_open_file_CB ,-1);
    gg_CreateMenuButton (menupane, "Save as.."  , 'O' ,NULL ,gg_comwin_save_file_CB ,-1);

    /* Label */
    text_buf = gg_CreateScrollTextItem2 (vb ,popup_width ,popup_height
					 ,"Select command lines & press apply or accept");

    follow_me_button = gg_check_new (vb ,"Follow me");
    g_signal_connect (follow_me_button ,"toggled" ,G_CALLBACK (follow_me_init_CB) ,NULL);
  }
  gtk_widget_show_all (command_item);
}


static void gg_cmd_AAC_CB (GtkWidget *command_item ,gint reponse)
{
  GtkTextIter start, end;
  gchar *s;
  static char *s0;

  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_APPLY   ) {
    if (gtk_text_buffer_get_selection_bounds (text_buf ,&start ,&end)) {
      s = gtk_text_buffer_get_text (text_buf ,&start ,&end ,FALSE);
      s0 = s;
      while ((s0 = strtok (s0 ,"\n"))  != NULL) {
	if (s0[0] == '@') s0++;
	scanner (s0);
	s0 = NULL;
      }
      gg_drawgraph ();
      gg_update_all ();
      ge_rpane_update ();
    }
  }

  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide (command_item);
  }
}

/**
 *
 */
static void gg_comwin_open_file_CB (GtkWidget *w ,gpointer p)
{
  static GtkWidget *file_select;
  static char *filename = NULL;
  FILE *fd = NULL;
  char *buf;
  int buflen;

  file_select = gg_create_file_popup ("Read file", "*.agr" ,0 ,0
 				      ,NULL
				      ,FALSE);
  if (gtk_dialog_run (GTK_DIALOG(file_select)) == GTK_RESPONSE_ACCEPT) {
    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (file_select));
    if (filename != NULL) {
      fd = fopen (filename ,"r");
      if (fd != NULL) {
	buflen = 1028;
	buf = xmalloc (buflen);
	while (read_long_line (fd ,&buf ,&buflen) == RETURN_SUCCESS) {
	  gtk_text_buffer_insert_at_cursor (text_buf ,buf ,-1);
	}
	fclose (fd);
	free (buf);
      }
    }
  }
  gtk_widget_destroy (file_select);
}

/**
 *
 */
static void gg_comwin_save_file_CB (GtkWidget *w ,gpointer p)
{
  static GtkWidget *file_select;
  GtkTextIter start ,end;
  FILE *pp;
  char *filename ,*text;
  int len;

  file_select = gg_create_file_popup ("Save as..", "*.agr" ,0 ,0
 				      ,NULL
				      ,TRUE);
  while (gtk_dialog_run (GTK_DIALOG (file_select)) != GTK_RESPONSE_CANCEL) {
    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (file_select));
    if (filename != NULL) {
      pp = grace_openw (filename);
      if (pp != NULL) {
	gtk_text_buffer_get_bounds      (text_buf ,&start ,&end);
	text = gtk_text_buffer_get_text (text_buf ,&start ,&end ,FALSE);
	len = strlen (text);
	fwrite (text, SIZEOF_CHAR, len, pp);
	grace_close (pp); 
	gtk_widget_destroy (file_select);
	return;
      }
    } else {
      errmsg ("Save commands window: cannot open file");
    }
  }
  gtk_widget_destroy (file_select);
}

/**
 *  Toggle the follow me mode (voir gg_drawgraph)
 */
static void follow_me_init_CB (GtkWidget *w ,gpointer p)
{
  follow_me_on = gg_get_int (w);
}

void gg_cmd_prt (char *buf)
{
  if (buf != NULL && text_buf != NULL) {
    if (follow_me_on) {
      gtk_text_buffer_insert_at_cursor (text_buf ,buf ,-1);
    }
  }
}
    
