/** File gg_eblockwin.c
 *  Transcripted from Motif to GTK+ by P. Vincent to
 *  Replace eblockwin.c
 */

#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "globals.h"
#include "graphs.h"
#include "draw.h"
#include "utils.h"
#include "ssdata.h"

#include "gw_list.h"

#include "gg_gutil.h"
#include "gg_gtkinc.h"
#include "gg_protos.h"
#include "ge_protos.h"

#include "zc.h"

extern GdkColor  bleuciel ,wheat;

static int block_curtype = SET_XY;
static int nncols = 0;           /* numeric columns */
static int nscols = 0;           /* string    "     */

static GtkWidget *eblock_frame = NULL;

static GtkWidget *eblock_ncols_item;
static gg_GraphSetStructure *eblock_graphset_item;
static GtkWidget *w_typ_combo;
static GtkWidget *eblock_nchoice_items[MAX_SET_COLS];
static GtkWidget *eblock_schoice_item;
static GtkWidget *auto_item;
static GtkWidget *w_nxy[2];

static void gg_eblock_AAC_CB (GtkWidget *w ,gint reponse);
static void gg_eblock_update (int gno);
static void eblock_type_choice_CB (GtkWidget *w ,gpointer p);

/**
 *  Replace  create_eblock_frame     eblockwin.c   72
 */
void gg_eblock_create_frame (int gno)
{
  GtkWidget *vb ,*hb;
  int nbtyp ,i;
  char buf[32];
  
  if (get_blockncols () == 0) {
    errmsg("Need to read block data first");
    return;
  }
  
  gg_set_wait_cursor ();
  if (eblock_frame == NULL) {
    nbtyp = NUMBER_OF_SETTYPES;
    eblock_frame         = gg_CreateAACDialog ("Edit block data" ,gg_eblock_AAC_CB ,0 ,0 ,&vb);
    eblock_ncols_item    = gg_label_new (vb ,"tmp");
    eblock_graphset_item = gg_CreateGraphSetSelector (vb ,"Load to:" ,GTK_SELECTION_BROWSE ,&wheat);
    w_typ_combo 	 = gg_combo_fun (vb ,"Set type:" ,&nbtyp ,set_types ,0);


	
    for (i = 0; i < MAX_SET_COLS; i++) {
      sprintf(buf ,"%s from column:" ,dataset_colname (i));
      if (i < 2 ) {
	hb = gg_CreateHContainer (vb);
	eblock_nchoice_items[i] = gg_combo_new (hb ,buf ,2 ,"Index");
	w_nxy[i] = gg_spin_new (hb ,"len:" ,2.0 ,1000.0 ,1.0);
	gtk_widget_set_sensitive (w_nxy[i] ,FALSE);
      } else {
	eblock_nchoice_items[i] = gg_combo_new (vb ,buf ,2 ,"Index");
      }
    }
    eblock_schoice_item = gg_combo_new (vb ,"Strings from column:" ,2 ,"None");
    auto_item           = gg_combo_new (vb ,"Autoscale graph on load:" ,5
						,"None"          /* AUTOSCALE_NONE */
						,"X"             /* AUTOSCALE_X    */
						,"Y"             /* AUTOSCALE_Y    */
						,"XY");          /* AUTOSCALE_XY   */
    gg_set_int (auto_item ,autoscale_onread);
    g_signal_connect (w_typ_combo ,"changed" ,G_CALLBACK (eblock_type_choice_CB) ,NULL);
  }

  gtk_widget_show_all (eblock_frame);
  gg_eblock_update    (gno);
  gg_unset_wait_cursor ();

}

/**
 *   Replace  update_eblock              eblockwin.c  128
 */
static void gg_eblock_update (int gno)
{
  int blocklen ,blockncols ,i ,j ,ncols;
  int *blockformats;
  char buf[128];

  if (eblock_frame == NULL) return;
  if (is_valid_gno (gno)) gg_set_int (eblock_graphset_item->graphs ,gno);
  /* TODO: check if new data arrived */
  blockncols   = get_blockncols ();
  blocklen     = get_blocknrows ();
  blockformats = get_blockformats ();

  sprintf(buf ,"Block data: %d column(s) of length %d" ,blockncols ,blocklen);
  gtk_label_set (GTK_LABEL (eblock_ncols_item) ,buf);
  
  /* Remove all entries except the first (i.e. Index or None) */
  for (i = 0; i < MAX_SET_COLS; i++) {
    for (j = nncols; j > 0; j--) {
      gtk_combo_box_remove_text (GTK_COMBO_BOX (eblock_nchoice_items[i]) ,j);
    }
  }
  for (j = nscols; j > 0; j--) {
    gtk_combo_box_remove_text (GTK_COMBO_BOX (eblock_schoice_item) ,j);
  }

  /* Recreate items */
  nncols = 0;
  nscols = 0;
  for (i = 0; i < blockncols; i++) {
    sprintf(buf ,"%d" ,i + 1);
    if (blockformats[i] != FFORMAT_STRING) {
      nncols++;
      for (j = 0; j < MAX_SET_COLS; j++) {
	gtk_combo_box_append_text (GTK_COMBO_BOX (eblock_nchoice_items[j]) ,buf);
      }
    } else {
      nscols++;
      gtk_combo_box_append_text (GTK_COMBO_BOX (eblock_schoice_item) ,buf);
    }
  }
   /* defaults settings */
  if (nncols  > 0) gg_set_int (eblock_nchoice_items[0] ,1);    /* X */
  if (nncols  > 1) gg_set_int (eblock_nchoice_items[1] ,2);    /* Y */
  if (nscols == 1) gg_set_int (eblock_schoice_item     ,1);    /* String */
  
  ncols = settype_cols (block_curtype);
  for (i = 0; i < MAX_SET_COLS; i++) {
    gtk_widget_set_sensitive (eblock_nchoice_items[i] ,(i < ncols));
  }
  gtk_widget_set_sensitive (eblock_schoice_item ,(nscols > 0));
}



/**
 *  Replace  eblock_accept_notify_proc  eblockwin.c  211
 */
static void gg_eblock_AAC_CB (GtkWidget *w ,gint reponse)
{
  int i ,gno ,setno;
  int cs[MAX_SET_COLS] ,nncols ,scol ,autoscale;
  char *s;

  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_APPLY) {
    if (!gg_GetSingleListChoice (GW_LIST(eblock_graphset_item->graphs) ,&gno)) {
      errmsg("Please select a single graph");
      return;
    }

    if (!gg_GetSingleListChoice (GW_LIST(eblock_graphset_item->sets) ,&setno)) {
    	/* no set selected; allocate new one */
      setno = NEW_SET;
    }
    nncols = settype_cols (block_curtype);
    for (i = 0; i < nncols; i++) {
      s = gtk_combo_box_get_active_text (GTK_COMBO_BOX (eblock_nchoice_items[i]));
      if (strncmp (s ,"Index" ,5) == 0) {
	cs[i] = -1;
      } else {
	sscanf (s ,"%d" ,&cs[i]); cs[i]--;
      }
    }
    s = gtk_combo_box_get_active_text (GTK_COMBO_BOX (eblock_schoice_item));
    if (strncmp (s ,"None" ,4) == 0) {
      scol = -1;
    } else {
      sscanf (s ,"%d" ,&scol); scol--;
    }
    if (block_curtype == SET_XYCMAP) {
      int nx = gg_get_int (w_nxy[0]);
      int ny = gg_get_int (w_nxy[1]);
      set_xymap_nxy (gno ,setno ,nx ,ny);
    }
    autoscale = gg_get_int (auto_item);
    create_set_fromblock (gno ,setno ,block_curtype ,nncols ,cs ,scol ,autoscale);
    gg_update_all ();
    ge_update_explorer ();
    gg_drawgraph();
  }
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide (eblock_frame);
  }
}

/**
 * replace  eblock_type_notify_proc    eblockwin.c  204
 */
static void eblock_type_choice_CB (GtkWidget *w ,gpointer p)
{
  int i;
  block_curtype = gg_get_int (w_typ_combo);
  int ncols         = settype_cols (block_curtype);
  for (i = 0; i < MAX_SET_COLS; i++) {
    gtk_widget_set_sensitive (eblock_nchoice_items[i] ,(i < ncols));
  }
  gtk_widget_set_sensitive (w_nxy[0] ,block_curtype == SET_XYCMAP);
  gtk_widget_set_sensitive (w_nxy[1] ,block_curtype == SET_XYCMAP);
}
