/** File gg_fontwin.c
 * Replace fontwin.c
 * A tool to build strings with escape sequences
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "globals.h"
#include "graphs.h"
#include "utils.h"
#include "noxprotos.h"
#include "t1fonts.h"


#include "gw_pannel.h"
#include "gw_choice.h"
#include "gw_list.h"

#include "gg_glyph_choice.h"

#include "gg_gtkinc.h"
#include "gg_protos.h"
#include "ge_protos.h"

static gint textbuf_width = 520 ,textbuf_height = 50;

extern GdkColor  bleuciel ,wheat;

extern int set_graph_title (int gno ,char *s);
extern int set_axis_label  (int gno ,int axisno ,char *s);

typedef enum {
  FWS_NORMAL
  ,FWS_UPPER_START
  ,FWS_UNDER_START
  ,FWS_INCREASE_START
  ,FWS_DECREASE_START
  ,FWS_UNDERLINE_START
  ,FWS_UNDERLINE_STOP
  ,FWS_OVERLINE_START
  ,FWS_OVERLINE_STOP
} FontWinScript;


static int FontID = 0;
static int FontSymbol ,FontZapfDingbats;


static GtkWidget *font_win = NULL;
static GtkWidget *vb;
static GtkWidget *font_item  ,*color_item ,*char_item;
static GtkTextBuffer *text_buf;

static gulong *handlers;
static gint     use_cur_obj = FALSE;   /* used when called from getree */
static GtkWidget *cur_entry = NULL;    /* used when called from gg_string_new */

static void gg_fontwin_AAC_CB   (GtkWidget *w ,gint reponse);
static void gg_font_changed_CB  (GtkWidget *w ,gpointer p);
static void gg_color_changed_CB (GtkWidget *w ,gpointer p);
static void gg_char_clicked_CB  (Gw_pannel *pannel ,gpointer p);
static void gg_script_CB 	(GtkWidget *w ,gpointer p);

void gg_fontwin_set_cur_entry (GtkWidget *entry)
{
  cur_entry = entry;
  if (cur_entry != NULL) use_cur_obj = FALSE;
}

GtkWidget *gg_fontwin_create (GtkWidget *w ,gpointer p)
{
  GtkWidget *rc;
  Gw_pannel *pannel;
  int nfonts ,i;
  GtkTextIter start ,end;

  if (font_win == NULL) {
    font_win   = gg_CreateAACDialog   ("Font tool" ,gg_fontwin_AAC_CB ,0 ,0 ,&vb);
    gg_label_new (vb ,"See the manual for a more complete list of escapes sequences");

    rc = gg_frame (vb ,"" ,&wheat ,4 ,3);
    gg_buttonA (rc ,"Normal"          ,gg_script_CB ,FWS_NORMAL);
    color_item = gg_color_new (rc ,"Color:");
    font_item  = gg_font_new  (rc ,"Font");
    char_item  = gg_glyph_new (rc ,"Char:");

    gg_buttonA (rc ,"Superscript"     ,gg_script_CB ,FWS_UPPER_START);
    gg_buttonA (rc ,"Underscript"     ,gg_script_CB ,FWS_UNDER_START);
    gg_buttonA (rc ,"Increase size"   ,gg_script_CB ,FWS_INCREASE_START);
    gg_buttonA (rc ,"Decrease size"   ,gg_script_CB ,FWS_DECREASE_START);
    gg_buttonA (rc ,"Begin underline" ,gg_script_CB ,FWS_UNDERLINE_START);
    gg_buttonA (rc ,"Stop underline"  ,gg_script_CB ,FWS_UNDERLINE_STOP);
    gg_buttonA (rc ,"Begin overline"  ,gg_script_CB ,FWS_OVERLINE_START);
    gg_buttonA (rc ,"Stop overline"   ,gg_script_CB ,FWS_OVERLINE_STOP);

    text_buf  = gg_CreateScrollTextItem2 (vb ,textbuf_width ,textbuf_height ,"Text buffer");

    pannel = GW_CHOICE (char_item)->pannel[0];
    nfonts = number_of_fonts ();
    handlers = xmalloc (nfonts * sizeof(gulong));
    for (i = 0; i < nfonts; i++) handlers[i] = 0;
    handlers[0] = g_signal_connect (pannel ,"gw_pannel" ,G_CALLBACK (gg_char_clicked_CB) ,NULL);

    g_signal_connect (font_item  ,"changed"   ,G_CALLBACK (gg_font_changed_CB)  ,NULL);
    g_signal_connect (color_item ,"gw_choice" ,G_CALLBACK (gg_color_changed_CB) ,NULL);

    FontSymbol       = get_font_by_name ("Symbol");
    FontZapfDingbats = get_font_by_name ("ZapfDingbats");
  }
  if (p == NULL) {
    use_cur_obj = FALSE;
    if (cur_entry != NULL) {
      /* we copy cur_entry into text_buf */
      gtk_text_buffer_get_bounds 	     (text_buf ,&start ,&end);
      gtk_text_buffer_delete     	     (text_buf ,&start ,&end);
      gtk_text_buffer_insert_at_cursor (text_buf ,gtk_entry_get_text (GTK_ENTRY (cur_entry)) ,-1);
    }
  } else {
    use_cur_obj = TRUE;
    cur_entry   = NULL;
    /* we copy the string pointed by p into  text_buf */
    gtk_text_buffer_get_bounds 	     (text_buf ,&start ,&end);
    gtk_text_buffer_delete     	     (text_buf ,&start ,&end);
    gtk_text_buffer_insert_at_cursor (text_buf
				      ,g_convert ((char *)p ,-1 ,"UTF-8" ,"ISO-8859-1" ,NULL ,NULL ,NULL)
				      ,-1);
  }
  gtk_widget_show_all (font_win);
  gw_choice_hide_on_click (GW_CHOICE(char_item) ,FALSE);
  return font_win;
}


static void  gg_fontwin_AAC_CB	(GtkWidget *w ,gint reponse)
{
  GtkTextIter start ,end;
  char *utf8_text ,*text;
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_APPLY   ) {
    if (use_cur_obj || cur_entry != NULL) {
      gtk_text_buffer_get_bounds      (text_buf ,&start ,&end);
      utf8_text = gtk_text_buffer_get_text (text_buf ,&start ,&end ,FALSE);
      text = g_convert (utf8_text ,-1 ,"ISO-8859-1" ,"UTF-8" ,NULL ,NULL ,NULL);
      if (use_cur_obj) {
	switch (objs[cur_obj_num].typ) {
	case Q_String:
	  objs[cur_obj_num].s = copy_string (objs[cur_obj_num].s ,text);
	  break;
	case Q_Graph:
	  set_graph_title (get_cg() ,text);
	  break;
	case Q_Axis:
	  set_axis_label (cur_parent_id ,cur_obj_id ,text);
	  break;
	case Q_Set:
	  set_legend_string (cur_parent_id ,cur_obj_id ,text);
	  break;
	default:
	  break;
	}
	ge_label_update_current (text);
      } else {
	gg_setstr (cur_entry ,text);
	g_signal_emit_by_name (cur_entry ,"activate");
      }
      gg_drawgraph ();
      set_dirtystate ();
      xfree (text);       // A FAIRE ?
      xfree (utf8_text);
    }
  }
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide (font_win);
  }
}

/**
 *  Called when font is changed:
 *     writes in the text buffer the escape sequence
 *     and update the glyph pannel
 */
static void gg_font_changed_CB (GtkWidget *w ,gpointer p)
{
  char *buf = malloc (128);
  Gw_pannel *pannel;
  FontID = gg_get_int(w);
  gg_update_glyph_choice (GW_CHOICE (char_item) ,FontID);
  sprintf (buf ,"\\f{%s}" ,get_fontalias(FontID));
  gtk_text_buffer_insert_at_cursor (text_buf ,buf ,-1);
  pannel = GW_CHOICE (char_item)->pannel[FontID];
  if (handlers[FontID] == 0) {
    handlers[FontID] = g_signal_connect (pannel ,"gw_pannel" ,G_CALLBACK (gg_char_clicked_CB) ,NULL);
  }
  gw_choice_hide_on_click (GW_CHOICE(char_item) ,FALSE);
  xfree (buf);
}

static void gg_color_changed_CB (GtkWidget *w ,gpointer p)
{
  char *buf = malloc (64);
  int color = gw_choice_get (GW_CHOICE (w));
  sprintf (buf ,"\\R{%s}" ,get_colorname (color));
  gtk_text_buffer_insert_at_cursor (text_buf ,buf ,-1);
  xfree (buf);
}


static void gg_char_clicked_CB (Gw_pannel *pannel ,gpointer p)
{
  gchar *buf_utf8 ,cn;
  gint x = pannel->x_clicked;
  gint y = pannel->y_clicked;
  gint n = gw_pannel_xy_to_n (pannel ,x ,y);
  if (n > 127) { //  && (FontID == FontSymbol || FontID == FontZapfDingbats))  {
    char *buf = malloc (10);
    sprintf (buf ,"\\#{%x}" ,n);
    buf_utf8  = g_convert (buf ,-1 ,"UTF-8" ,"ISO-8859-1" ,NULL ,NULL ,NULL);
    xfree (buf);
  } else {
    cn = (gchar)(n);
    buf_utf8  = g_convert (&cn ,1 ,"UTF-8" ,"ISO-8859-1" ,NULL ,NULL ,NULL);
  }
  gtk_text_buffer_insert_at_cursor (text_buf ,buf_utf8 ,-1);
}


static void gg_script_CB (GtkWidget *w ,gpointer p)
{
  char buf[10];
  gint n = GPOINTER_TO_INT (p);
  switch (n) {
  case FWS_NORMAL:
    sprintf (buf ,"\\N");
    break;
  case FWS_UPPER_START:
    sprintf (buf ,"\\S");
    break;
  case FWS_UNDER_START:
    sprintf (buf ,"\\s");
    break;
  case FWS_INCREASE_START:
    sprintf (buf ,"\\+");
    break;
  case FWS_DECREASE_START:
    sprintf (buf ,"\\-");
    break;
  case FWS_UNDERLINE_START:
    sprintf (buf ,"\\u");
    break;
  case FWS_UNDERLINE_STOP:
    sprintf (buf ,"\\U");
    break;
  case FWS_OVERLINE_START:
    sprintf (buf ,"\\o");
    break;
  case FWS_OVERLINE_STOP:
    sprintf (buf ,"\\O");
    break;
  }
  gtk_text_buffer_insert_at_cursor (text_buf ,buf ,-1);
}
