/* File gg_gtkinc.h     See motifinc.h */


#ifndef __GTKINC_H_
#define __GTKINC_H_

/* This enumeration is used for graphs, sets and objs */
typedef enum {
  MenuFocusCB,
  MenuHideCB,
  MenuShowCB,
  MenuDuplicateCB,
  MenuKillCB,
  MenuKillDataCB,
  MenuCopy12CB,
  MenuCopy21CB,
  MenuMove12CB,
  MenuMove21CB,
  MenuSwapCB,
  MenuNewCB,
  MenuEditSCB,
  MenuEditECB,
  MenuNewFCB,
  MenuNewSCB,
  MenuNewECB,
  MenuNewBCB,
  MenuSelectAll,
  MenuUSelectAll,
  MenuInvSelect,
  MenuPackCB,
  MenuUpdate,
  MenuEditGE,
  MenuUseFontTool,
  MenuGraphsUpdate,
  MenuAxesUpdate,
  MenuSetsUpdate,
  MenuObjsUpdate,
  MenuObjsGlue,
  MenuObjsBreak,
  MenuObjsPrune,
  MenuObjsInsert
} Menu3action;


/* menu3 are normally raised by mouse Button3 */
typedef struct {
  GtkWidget *popup;
  GtkWidget *focus;
  GtkWidget *hide;
  GtkWidget *show;
  GtkWidget *duplicate;
  GtkWidget *kill;
  GtkWidget *copy12;
  GtkWidget *copy21;
  GtkWidget *move12;
  GtkWidget *move21;
//09 GtkWidget *swap;
  GtkWidget *update;
  GtkWidget *font_tool;
} GraphMenu3Struct;

typedef struct {
  GtkWidget *popup;
  GtkWidget *label;
  GtkWidget *shownd;
  GtkWidget *showh;
  GtkWidget *hide;
  GtkWidget *show;
  GtkWidget *duplicate;
  GtkWidget *kill;
  GtkWidget *killd;
  GtkWidget *copy12;
  GtkWidget *copy21;
  GtkWidget *move12;
  GtkWidget *move21;
  GtkWidget *swap;
  GtkWidget *edit;
  GtkWidget *editge;
  GtkWidget *update;
  GtkWidget *font_tool;
} SetsMenu3Struct;

typedef struct {
  GtkWidget *popup;        /* the menu itself */
  GtkWidget *hide;
  GtkWidget *show;
  GtkWidget *duplicate;
  GtkWidget *kill;
  GtkWidget *update;
  GtkWidget *font_tool;
  GtkWidget *glue;
  GtkWidget *break_compound;
  GtkWidget *prune;
  GtkWidget *insert;
} ObjMenu3Struct;
ObjMenu3Struct *ge_CreateObjPopupEntries (ObjMenu3Struct *p ,GtkWidget *list
					  ,void (*CB) (GtkWidget *obj_list ,gpointer p));
void ge_obj_popup_menu3       (ObjMenu3Struct *p ,int n ,Qtype typ ,int id);
void ge_obj_popup_menu3_mixed (ObjMenu3Struct *p);


typedef struct {
  GtkWidget *popup;
  GtkWidget *hide;
  GtkWidget *show;
  GtkWidget *update;
} ColorbarMenu3Struct;
void ge_colorbar_popup_menu3 (ColorbarMenu3Struct *p);
ColorbarMenu3Struct *ge_CreateColorbarPopupEntries (ColorbarMenu3Struct *p ,GtkWidget *list
						    ,void (*CB) (GtkWidget *colorbar_list ,gpointer p));

typedef struct {
  GtkWidget *popup;
  GtkWidget *hide;
  GtkWidget *show;
} LegendBoxMenu3Struct;
void ge_legendbox_popup_menu3 (LegendBoxMenu3Struct *p);
LegendBoxMenu3Struct *ge_CreateLegendboxPopupEntries (LegendBoxMenu3Struct *p ,GtkWidget *list
						    ,void (*CB) (GtkWidget *legendbox_list ,gpointer p));

typedef struct {
  GtkWidget *popup;
  GtkWidget *hide;
  GtkWidget *show;
  GtkWidget *update;
  GtkWidget *font_tool;
} AxisMenu3Struct;
AxisMenu3Struct *ge_CreateAxisPopupEntries (AxisMenu3Struct *p ,GtkWidget *list
					  ,void (*CB) (GtkWidget *w ,gpointer p));
void ge_axis_popup_menu3 (AxisMenu3Struct *p);

typedef struct {
  GtkWidget *frame;
  GtkWidget *graphs;
  GtkWidget *sets;
  GraphMenu3Struct *graph_menu3;
  SetsMenu3Struct  *sets_menu3;
} gg_GraphSetStructure;

typedef struct {
  GtkWidget *box;
  gg_GraphSetStructure *src;
  gg_GraphSetStructure *dest;
} gg_SrcDestStructure;

typedef struct {
    GtkWidget *frame;
    GtkWidget *r_sel;
    GtkWidget *negate;
} gg_RestrictionStructure;


/**  Due to bug 437281 in gtk_button_set_image
 *  (corrected in the last versions only)
 *  the images for buttons must be rebuild at each call
 */

void 	gg_attach   (GtkWidget *parent, GtkWidget *child);
void    gg_set_int  (GtkWidget *w ,int val);
void    gg_set_dble (GtkWidget *w ,gdouble d);
int     gg_get_int  (GtkWidget *w);
gdouble gg_get_dble (GtkWidget *w);


void gg_SetSensitive 	   (GtkWidget *w     ,gboolean onoff);
void gg_spin_time_store_CB (GtkSpinButton *w ,gpointer p);

gint  gg_combo_get (GtkWidget *combo);
void  gg_combo_set (GtkWidget *combo ,gint index);



GtkWidget *gg_get_fileswin_graph_list ();
GtkWidget *gg_create_file_popup (char *title ,char *filter
				 ,gint popup_width ,gint popup_height
				 ,GtkWidget *extra_widget
				 ,gint save);

/************ M A N A G E   G R A P H    L I S T S ***************/
void       gg_graph_add_selector     (Gw_list *w);
void       gg_graph_update_list      (Gw_list *wl);
void       gg_graph_update_all_lists (void);
void       gg_graph_menu3_actions    (Menu3action action ,int n ,int i ,int j);
void       gg_graph_menu3_CB         (GtkWidget *graph_list ,gpointer pact);

GraphMenu3Struct *gg_CreateGraphPopupEntries (GraphMenu3Struct *p ,GtkWidget *list
					       ,void (*CB) (GtkWidget *graph_list ,gpointer p));
void       gg_graph_popup_menu3      (GraphMenu3Struct *p ,int n);
void       gg_graph_popup_menu3_CB   (GtkWidget *list ,GdkEvent *event ,GraphMenu3Struct *p);
GtkWidget *gg_CreateGraphChoice      (char *labelstr, int type_select
				      ,int width ,int height
				      ,void (* cb)(GtkTreeSelection *sel ,Gw_list *list)
				      ,GraphMenu3Struct **graph_menu3
				      );

/************ M A N A G E   S E T S   L I S T S ***************/
void  gg_set_selector_add       (Gw_list *sets ,gg_GraphSetStructure *gss);
void  gg_update_sets_list       (Gw_list *wl);
void  gg_update_all_sets_lists  (void);
void  gg_sets_menu3_actions     (Menu3action action ,int n ,int gno ,int setno ,int j);
void  gg_sets_menu3_CB  	(GtkWidget *sets_list ,gpointer pact);

SetsMenu3Struct *gg_CreateSetPopupEntries (SetsMenu3Struct *p ,GtkWidget *list
					   ,void (*CB) (GtkWidget *set_list ,gpointer p));
void  gg_sets_popup_menu3       (SetsMenu3Struct *p ,int n ,gboolean edit_in_tree);
void  gg_sets_popup_menu3_CB    (GtkWidget *list ,GdkEvent *event ,SetsMenu3Struct *p);
GtkWidget *gg_CreateSetChoice        (char *labelstr, int type_select 
				      ,int width ,int height
				      ,void (*cb)(GtkTreeSelection *sel ,Gw_list *list)
				      ,SetsMenu3Struct **sets_menu3
				      ,gg_GraphSetStructure *gss
				      );

/************ M A N A G E   G R A P H S , S E T S , S R C , D E S T   L I S T S ***************/
gg_GraphSetStructure *gg_CreateGraphSetSelector (GtkWidget *parent ,char *s
						 ,int sel_type
						 ,GdkColor *couleur);

GtkWidget *gg_get_setappwin_sets_list    (void);
void       gg_view_legend (gboolean val);
void       gg_view_comment (gboolean val);


void gg_CreateMenuSeparator (GtkWidget *parent);

GtkWidget *gg_CreateTabPage (GtkWidget *parent, char *s);         /*  motifinc.h 266 */

int gg_GetToggleButtonState (GtkWidget *w);                       /*  motifinc.h 283 */

gboolean gg_GetSingleListChoice (Gw_list *list ,int *value);      /*  motifinc.h 313 */

GtkWidget *gg_CreateFontChoice (GtkWidget *parent ,char *s);       /*  motifinc.h 341 */

GtkWidget *gg_CreateBitmapPannel (gchar *label ,gint nrows ,gint ncols
				  ,unsigned char **bits ,int width ,int height
				  ,gboolean with_num
				  );

GtkWidget *gg_CreateJustChoice (GtkWidget *parent ,char *label);  /* motifinc.h 348 */

gg_RestrictionStructure *gg_CreateRestrictionChoice (GtkWidget *parent ,char *s); /* motifinc.h 348 */

gg_SrcDestStructure *gg_CreateSrcDestSelector(GtkWidget *parent    /*  motifinc.h 359 */
					      ,int sel_type);

/* Masks for gg_GetSrcDestSettings */
#define SD_SET1_UNIQUE    0x0001
#define SD_NSET1_EQ_NSET2 0x0002
#define SD_NSET2_GIVEN    0x0004
#define SD_EXCLUSIVE      0x0008



int gg_GetSrcDestSettings (gg_SrcDestStructure *sds ,int sd_mask
			   ,int *gno1  	     ,int *gno2
			   ,int *nset1 	     ,int *nset2
			   ,int **setlist1   ,int **setlist2);

GtkWidget *gg_CreateMenuBar (GtkWidget *parent);                  /*  motifinc.h 426 */
GtkWidget *gg_CreateMenu (GtkWidget *parent, char *label, char mnemonic, int help); /* 427 */

GtkWidget *gg_CreatePanelChoice (GtkWidget *parent, char *labelstr, int nchoices, ...);


const char *gg_getstr (GtkWidget *w);                            /*  motifinc.h 442 */

void gg_SetToggleButtonState (GtkWidget *w, int value);

GtkWidget *gg_CreateListButton (GtkWidget *parent, char *label, char mnemonic
				 ,GtkWidget *list
				 ,void (*func) (GtkWidget *list ,gpointer p)
				,gint action);

GtkWidget *gg_CreateMenuButton (GtkWidget *parent, char *label, char mnemonic
				,GtkWidget *list
				,void (*func) (GtkWidget *graph_list ,gpointer p)
				,gint action);

GtkWidget *gg_CreateMenuToggle (GtkWidget *parent, char *label, char mnemonic
				,GtkWidget *list
				,void (*func) (GtkWidget *w ,gint action)
				,gboolean state);

GtkWidget *gg_CreateMenuCloseButton (GtkWidget *parent, GtkWidget *form);

gboolean gg_evalexpr (GtkWidget *widget, double *d);   
gboolean gg_evalexpri (GtkWidget *widget ,int *answer);
void gg_double_scan (GtkWidget *widget, double *d);
void gg_double_set (GtkWidget *w_entry ,int nb_car ,double *d);
GtkWidget *gg_double (GtkWidget *parent, int nb_car ,char *label ,GtkWidget **p ,double *d);


GSList *gg_menu_radio_buttons_group (GtkWidget *parent
				     ,void (*func) (GtkCheckMenuItem *item ,gpointer p)   
				     ,int active
				     ,int nchoices  ,...);
int gg_yesnowin (char *msg);


GtkWidget *gg_tableau (GtkWidget *parent ,gchar *label
		       ,GdkColor *couleur ,int nx ,int ny);

#endif /* __GTKINC_H_ */
