/**  File gg_hotwin.c
 *
 *  Replace hotwin.c
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "gw_pannel.h"
#include "gw_choice.h"
#include "gw_list.h"

#include "graphs.h"
#include "defines.h"
#include "noxprotos.h"

#include "gg_gutil.h"
#include "gg_gtkinc.h"
#include "gg_protos.h"

#define HOT_LINK   1000
#define HOT_FILES  1001
#define HOT_UNLINK 1002
#define HOT_UPDATE 1003

static gint popup_width = 400  ,list_height = 250;

static GtkWidget *hotlink_frame = NULL;
static GtkWidget *hotlink_list_item;
static GtkWidget *hotlink_set_item;
static GtkWidget *hotlink_file_item;
static GtkWidget *hotlink_file_popup = NULL;
static GtkWidget *hotlink_source_item;

static SetsMenu3Struct  *sets_menu3  = NULL;

/** update hot links displayed in scrolled list
 *  Replace update_hotlinks   hotwin.c    146
 */
void gg_update_hotlinks (void)
{
  int j;
  char buf[256];

  if (hotlink_frame != NULL) {
    gg_set_wait_cursor ();
    gw_list_clear (GW_LIST (hotlink_list_item));
    for (j = 0; j < number_of_sets (get_cg()); j++) {
      if (is_hotlinked(get_cg(), j)) {
	sprintf(buf, "G%d.S%d -> %s -> %s:%d", get_cg(), j, 
		get_hotlink_src  (get_cg (), j) == SOURCE_DISK ? "DISK" : "PIPE", 
		get_hotlink_file (get_cg (), j), is_hotlinked (get_cg(),j) );
	gw_list_append (GW_LIST (hotlink_list_item) ,buf ,j ,TRUE);
      }
    }
    gg_unset_wait_cursor ();
  }
}


static void gg_hotlinks_AAC_CB (GtkWidget *w ,gint reponse)
{
  gint i ,numset ,src ,*selsets ,cnt ,n ,setno ,gno;
  gboolean bool;
  char buf[256] ,fname[256];
  char *cstr ,*filename;

  gg_set_wait_cursor ();
  
  switch (reponse) {
  case GTK_RESPONSE_CLOSE:
    gtk_widget_hide_all (w);
    break;
  case HOT_LINK:
    selsets = gw_list_selected_list (GW_LIST (hotlink_set_item), &numset);
    src = gg_get_int (hotlink_source_item);
    strcpy (fname, gg_getstr (hotlink_file_item));

    if (numset == 0) {
      gg_errwin ("No set selected");
      gg_unset_wait_cursor();
      return;
    }
    if (fname[0] == '\0') {
      gg_errwin ("No source selected");
      free (selsets);
      gg_unset_wait_cursor ();
      return;
    }
    for( i=0; i<numset; i++ ) {
      if( numset == 1 ) {
	sprintf (buf, "G%d.S%d -> %s -> %s", get_cg (), selsets[i],
		 src==0 ? "DISK" : "PIPE", fname );
      } else {
	sprintf (buf, "G%d.S%d -> %s -> %s:%d", get_cg (), selsets[i], 
		 src == 0 ? "DISK" : "PIPE", fname, i+1);
      }
      gw_list_append (GW_LIST (hotlink_list_item) ,buf ,i ,TRUE);
      set_hotlink (get_cg (), selsets[i], i+1, fname, src==0?SOURCE_DISK:SOURCE_PIPE);
      if( numset == 1 ) {
	setcomment( get_cg(), selsets[i], fname );
      } else {
	sprintf( buf, "%s:%d", fname, i+1 );
	setcomment( get_cg(), selsets[i], buf );
      }
    }
    free (selsets);
    break;
  case HOT_UNLINK:
    selsets = gw_list_selected_list (GW_LIST (hotlink_list_item) ,&cnt);
    for (i = 0; i < cnt; i++) {
      gw_list_get (GW_LIST (hotlink_list_item)
		   ,selsets[i]
		   ,&cstr ,&n ,&bool);
      sscanf (cstr ,"G%*d.S%d", &setno);
      if (setno >= 0 && setno < number_of_sets (get_cg ())) {
	set_hotlink (get_cg (), setno, FALSE, NULL, 0);
      }
    }
    free (selsets);
    free (cstr);
    break;
  case HOT_UPDATE:
    for (gno = 0; gno < number_of_graphs(); gno++) {
      for (setno = 0; setno < number_of_sets(gno); setno++) {
	do_update_hotlink (gno, setno);
      }
    }
    gg_drawgraph ();
    break;
  case HOT_FILES:
    if (hotlink_file_popup == NULL) {
      hotlink_file_popup = gg_create_file_popup ("Select hot link file" ,"*.dat" ,0 ,0 ,NULL ,FALSE);
    }
    gtk_widget_show_all (hotlink_file_popup);
    while (gtk_dialog_run (GTK_DIALOG (hotlink_file_popup)) != GTK_RESPONSE_CANCEL) {
    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (hotlink_file_popup));
    gg_setstr (hotlink_file_item, filename);
    g_free (filename);
    }
    gtk_widget_hide (GTK_WIDGET (hotlink_file_popup));
    break;
  }
  gg_unset_wait_cursor ();

}

/**
 *  Replace create_hotlinks_popup  hotwin.c  192
 */
void gg_create_hotlinks_popup (void)
{
  static GtkWidget *vb;

  if (hotlink_frame == NULL) {
    hotlink_frame = gtk_dialog_new_with_buttons ("Hot links" ,NULL
						  ,GTK_DIALOG_DESTROY_WITH_PARENT
						  ,"Link"      ,HOT_LINK
						  ,"Files..."  ,HOT_FILES
						  ,"Unlink"    ,HOT_UNLINK
						  ,"Update"    ,HOT_UPDATE
						  ,GTK_STOCK_CLOSE   ,GTK_RESPONSE_CLOSE
						  ,NULL);
    vb = GTK_DIALOG (hotlink_frame)->vbox;

    hotlink_list_item = gw_list_new ("Links" ,"Links" ,GTK_SELECTION_MULTIPLE);
    gtk_box_pack_start_defaults (GTK_BOX (vb) ,hotlink_list_item);

    hotlink_set_item = gg_CreateSetChoice ("Link to sets" ,GTK_SELECTION_MULTIPLE
					   ,popup_width ,list_height
					   ,NULL
					   ,&sets_menu3
					   ,NULL);
    gtk_box_pack_start_defaults (GTK_BOX (vb) ,hotlink_set_item);

    hotlink_file_item   = gg_entry_new   (vb ,"To file or pipe:" ,40);
    hotlink_source_item = gg_combo_new (vb ,"Source: ", 3,
						"Disk file",
						"Pipe");
    g_signal_connect (hotlink_frame ,"delete-event" ,G_CALLBACK (gtk_widget_hide)    ,NULL);
    g_signal_connect (hotlink_frame ,"response"     ,G_CALLBACK (gg_hotlinks_AAC_CB) ,NULL);

  }
  gtk_widget_show_all (hotlink_frame);


}

