/** File gg_printwin.c
 *  Transcripted from Motif to GTK+ by P. Vincent to
 *  Replace printwin.c
 *
 *  Popup for Printer Setup
 *
 */

#define _NEED_CUPS_

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "globals.h"
#include "device.h"
#include "utils.h"
#include "plotone.h"

#include "gw_list.h"

#include "gg_gtkinc.h"
#include "gg_protos.h"
#include "gg_gutil.h"
#include "gg_gtkdrv.h"
#include "gg_page_dimensions.h" 

static gint popup_width = 350 ,popup_height = 600;

extern char print_file[];
extern GdkColor  bleuciel ,wheat;

/******** Callbacks ***********/
static void gg_create_devopts_popup    (GtkWidget *w ,gpointer p);
static void gg_create_printfiles_popup (GtkWidget *w ,gpointer p);

static void gg_printfile_button_CB     (GtkWidget *w ,gpointer p);
static void gg_use_cups_button_CB      (GtkWidget *w ,gpointer p);
static void gg_psetup_AAC_CB           (GtkWidget *w ,gint reponse);
static void gg_update_device_setup_CB  (GtkWidget *w ,gpointer p);

static int  gg_printwin_apply (void);
void gg_update_device_setup (int device_id);
static void gg_update_printer_setup(int device_id);

extern int use_cups;
#ifdef HAVE_CUPS
static void gg_printwin_browse_CB (GtkWidget *w ,gpointer p);
#endif /* HAVE_CUPS */

static PageDimensions pdim;

/****** Widgets *********/
static GtkWidget *w_frame = NULL;
static GtkWidget *w_device_frame;
static GtkWidget *w_device_id;
static GtkWidget *w_device_opts;
static GtkWidget *w_printto;
static GtkWidget *w_output_frame;
static GtkWidget *w_box_file;
static GtkWidget *w_box_prtcmd;
static GtkWidget *w_printfile;
static GtkWidget *w_browse_files;
static GtkWidget *w_print_string;
static GtkWidget *w_dsync;
//static GtkWidget *w_psync;
static GtkWidget *w_font_frame;
static GtkWidget *w_fontaa;
static GtkWidget *w_devfont;
static GtkWidget *w_use_cups;
#ifdef HAVE_CUPS
static GtkWidget *w_box_dest;
static GtkWidget *w_print_dest;
#endif /* HAVE_CUPS */

/* Variables */
static int printer_menu = FALSE;

/**
 * These two callbacks create the same popup with a different option
 */
void gg_create_page_setup_CB (GtkWidget *w ,gpointer p)
{
  printer_menu = FALSE;
  gg_create_printer_setup (tdevice);
  gtk_window_set_title (GTK_WINDOW (w_frame) ,"GraceGTK: canvas setup");
}

void gg_create_printer_setup_CB (GtkWidget *w ,gpointer p)
{
  printer_menu = TRUE;
  gg_create_printer_setup (hdevice);
  gtk_window_set_title (GTK_WINDOW (w_frame) ,"GraceGTK: printer setup");

}

#define GTK_RESPONSE_PRINT 1

/**  Popup to configure the print action
 *   Replace create_printer_setup  printwin.c 87
 */
void gg_create_printer_setup (int device)
{
  GtkWidget *vb ,*hb;
  int ndev ,ndests;
  if (w_frame == NULL) {
    gg_frame_connect (NULL);  
    w_frame = gg_CreateAACDialog ("GraceGTK: Device setup" ,gg_psetup_AAC_CB ,0 ,0 ,&vb);
    gtk_dialog_add_buttons (GTK_DIALOG(w_frame) ,GTK_STOCK_PRINT ,GTK_RESPONSE_PRINT ,NULL);

    /* Device setup */
    w_device_frame   = gg_frame (vb ,"Device setup" ,&bleuciel ,0 ,1);
    ndev = number_of_devices();
    w_device_id      = gg_combo_fun (w_device_frame ,"Device: " ,&ndev ,get_device_name ,1);
    hb               = gg_get_w_box ();
    w_device_opts    = gg_button_new (hb ,"Device options...");

    /* Output */
    w_output_frame   = gg_frame (vb ,"Output" ,&wheat ,0 ,1);
    hb               = gg_hbox_new   (w_output_frame);
    w_printto        = gg_check_new  (hb ,"Print to file");
    w_use_cups       = gg_check_new  (hb ,"Use CUPS");
    w_box_file       = gg_hbox_new   (w_output_frame);
    w_printfile      = gg_entry_new  (w_box_file ,"File name:" ,30);
    w_browse_files   = gg_button_new (w_box_file ,"Browse...");
    w_print_string   = gg_entry_new  (w_output_frame ,"Print command:" ,25);
    w_box_prtcmd     = gg_get_w_box  ();
#ifdef HAVE_CUPS
    use_cups 	     = TRUE;
    ndests   	     = device_cups_ndests ();
    w_box_dest       = gg_hbox_new   (w_output_frame);
    w_print_dest     = gg_combo_fun  (w_box_dest ,"Destination" ,&ndests ,device_cups_dest_name ,0);
    gg_buttonA (w_box_dest ,"Browse printer settings:" ,gg_printwin_browse_CB ,0);
    g_signal_connect (w_printto        ,"toggled" ,G_CALLBACK (gg_use_cups_button_CB)     ,NULL);
    g_signal_connect (w_use_cups       ,"toggled" ,G_CALLBACK (gg_use_cups_button_CB)     ,NULL);
#else
    use_cups 	     = FALSE;
    ndests   	     = 0;
#endif /* HAVE_CUPS */

    /* Page dimensions */
    gg_page_dimensions_new (vb ,&pdim);

    /* Fonts */
    w_font_frame = gg_frame (vb ,"Fonts" ,&wheat ,0 ,1);
    w_fontaa  = gg_check_new (w_font_frame ,"Enable font antialiasing");
    w_devfont = gg_check_new (w_font_frame ,"Use device fonts"); //  gg_to_be_done_CB

    gg_update_printer_setup (device);

    g_signal_connect (w_device_id      ,"changed" ,G_CALLBACK (gg_update_device_setup_CB) ,NULL);
    g_signal_connect (w_device_opts    ,"clicked" ,G_CALLBACK (gg_create_devopts_popup)   ,NULL);
    g_signal_connect (w_browse_files   ,"clicked" ,G_CALLBACK (gg_create_printfiles_popup),NULL);
    g_signal_connect (w_printto        ,"toggled" ,G_CALLBACK (gg_printfile_button_CB)    ,NULL);

    gtk_widget_show_all (w_frame);
    /* set defaults */
    gg_setstr 		   (w_print_string ,get_print_cmd());
    gg_set_int		   (w_printto ,TRUE);
    gg_set_int		   (w_use_cups ,FALSE);
    gg_printfile_button_CB (w_printto ,NULL);
    gg_use_cups_button_CB  (w_use_cups ,NULL);
  } else {
    gtk_widget_show_all (w_frame);
  }
}

/******** C A L L B A C K S ***********/

/**
 *   Replace  update_printer_setup  printwin.c  224
 */
static void gg_update_printer_setup (int device_id)
{
  if (w_frame) {
    gg_set_int (w_device_id ,device_id);
    gg_update_device_setup (device_id);
  }
}

/**
 *  Replace update_device_setup  printwin.c 232
 */
void gg_update_device_setup (int device_id)
{
  char *bufptr;
  static Page_geometry pg;
  Device_entry dev;
  if (w_frame == NULL) return;
  dev = get_device_props (device_id);
  pg = dev.pg;

  /* Page dimensions */
  pdim.device_id = device_id;
  gg_page_dimensions_update (&pdim);

  gtk_widget_set_sensitive (w_device_frame ,printer_menu);
  gtk_widget_set_sensitive (w_output_frame ,printer_menu);
  gtk_widget_set_sensitive (w_font_frame   ,printer_menu);
  if (printer_menu == FALSE) return;

  if (print_file == NULL || print_file[0] == '\0') {
    strcpy (print_file, mybasename (get_docname()));
  }
#ifdef HAVE_CUPS
#else
  gg_setstr (w_print_string, get_print_cmd ());
#endif /* HAVE_CUPS */

  /* Replace existing filename extension */
  bufptr = strrchr (print_file, '.');
  if (bufptr) {
    *(bufptr + 1) = '\0';
  } else {
    strcat (print_file, ".");
  }
  strcat (print_file, dev.fext);
  gg_setstr (w_printfile, print_file);

  //22  gtk_widget_set_sensitive (device_setup_frame ,dev.type  != DEVICE_TERM);
  gtk_widget_set_sensitive (w_device_opts ,dev.setup != NULL);

  /* Le switch (dev.type) sert a distinguer pageSetup de printerSetup */
  switch (dev.type) {
  case DEVICE_TERM:
    gtk_window_set_title (GTK_WINDOW (w_frame) ,"Page setup");
    break;
  case DEVICE_FILE:
    gtk_window_set_title (GTK_WINDOW (w_frame) ,"Output file setup");
    gg_set_int (w_printto ,TRUE);
    break;
  case DEVICE_PRINT:
    gtk_window_set_title (GTK_WINDOW (w_frame) ,"Printer setup");
    gg_set_int (w_printto ,get_ptofile ());
    break;
  }
  gtk_widget_set_sensitive (w_output_frame ,dev.type != DEVICE_TERM);
  /* Fonts */
  gtk_widget_set_sensitive (w_font_frame ,dev.type  != DEVICE_TERM);
  gg_set_int (w_fontaa  ,dev.fontaa);
  gg_set_int (w_devfont ,dev.devfonts);
}

/**********************************************************/

/**
 *   Replace a call to set_printer_proc   printwin.c 343
 */
static void gg_psetup_AAC_CB (GtkWidget *w ,gint reponse)
{
  gint device_id;
  if (reponse == GTK_RESPONSE_ACCEPT ||
      reponse == GTK_RESPONSE_APPLY  ||
      reponse == GTK_RESPONSE_PRINT   ) {
    gg_printwin_apply ();
    device_id = gg_get_int (w_device_id);
    gg_update_printer_setup (device_id);
    if (reponse == GTK_RESPONSE_PRINT)  gg_do_print_CB (w ,NULL);
  }
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide_all (w_frame);
  }

}

/**
 *   Replace set_printer_proc    printwin.c 343
 */
static int gg_printwin_apply (void)
{
  gint seldevice;
  Device_entry dev;
  if (printer_menu) {
    seldevice = gg_get_int (w_device_id);
    dev       = get_device_props (seldevice);
    if (dev.type != DEVICE_TERM) {
      hdevice = seldevice;
      set_ptofile (gg_get_int (w_printto));
      if (get_ptofile ()) {
	strcpy (print_file, gtk_entry_get_text (GTK_ENTRY (w_printfile)));
      } else {
#ifdef HAVE_CUPS
#else
	set_print_cmd (gtk_entry_get_text (GTK_ENTRY (w_print_string)));
#endif /* HAVE_CUPS */
      }
    }
    dev.devfonts = gg_get_int (w_devfont);
    dev.fontaa   = gg_get_int (w_fontaa);
  }
  return RETURN_SUCCESS;
}

/**
 *   Replace do_device_toggle   printwin.c 431
 */
static void gg_update_device_setup_CB (GtkWidget *w ,gpointer p)
{
  int device_id = gg_get_int (w);
  gg_update_device_setup (device_id);
}

/**
 *  Replace do_pr_toggle    printwin.c  436
 */

void gg_set_orient (int orientation)
{
  if (w_frame != NULL) {
    gg_set_int (w_dsync ,orientation);
  }
}

/*****************************************************************/

/**
 *  Replace create_printfiles_popup  printwin.c 556
 *  and     do_prfilesel_proc        printwin.c 548
 */
static void gg_create_printfiles_popup (GtkWidget *w ,gpointer p)
{
  gint device_id ,response;
  Device_entry dev;
  const gchar *default_filename;
  char *filename;
  GtkWidget *gg_print_to_file_select;
  char buf[10];

  gg_set_wait_cursor();
  device_id = gg_get_int (w_device_id);
  dev       = get_device_props (device_id);
  strcpy (buf ,"*.");
  strcat (buf+2 ,dev.fext);
  gg_print_to_file_select = gg_create_file_popup ("Select print file", buf
						  ,popup_width ,popup_height
						  ,NULL
						  ,TRUE);

  default_filename = gtk_entry_get_text (GTK_ENTRY (w_printfile));
  gtk_file_chooser_set_current_name (GTK_FILE_CHOOSER(gg_print_to_file_select)
				     ,default_filename);

  response = gtk_dialog_run (GTK_DIALOG(gg_print_to_file_select));
  if (response == GTK_RESPONSE_ACCEPT) {
    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(gg_print_to_file_select));
    gg_setstr (w_printfile ,filename);
  }
  gtk_widget_hide_all (gg_print_to_file_select);
}

/**
 *   Replace  void create_devopts_popup      printwin.c 582
 */
static void gg_create_devopts_popup  (GtkWidget *w ,gpointer p)
{
  int device_id;
  Device_entry dev;

  device_id = gg_get_int (w_device_id);
  dev       = get_device_props(device_id);
  if (dev.setup == NULL) {
    /* Should never come to here */
    errmsg ("No options can be set for this device");
  } else {
    (dev.setup)();
  }
}

/** Print in a file or to the printer
 *  Replace MENU_PRINT  xmgrace.c 505
 *  and    do_print_cb  printwin.c  653
 */
void gg_do_print_CB (GtkWidget *w ,gpointer p)
{
  gg_set_wait_cursor ();
  use_cups = gg_get_int (w_use_cups);
  do_hardcopy ();
  gg_unset_wait_cursor ();
}


/****************** CUPS support ******************/

/* See device.c */

#ifdef HAVE_CUPS

extern int cups_idest;   /* the destination number */

static GtkWidget *w_cups_dialog;
static GtkWidget *w_cups_noteb;
static GtkWidget *w_cups_noteb_tabs[5];
static GtkWidget *w_cups_noteb_options[5][40];

static void gg_printwin_browse_AAC_CB (GtkWidget *w ,gint reponse);

static PrintDest *pd;
static PrintOption *po;
static char *po_choices (int k)
{
  return po->choices[k];
}

/**
 *  Services the "Browse printer settings:" button
 */
static void gg_printwin_browse_CB (GtkWidget *w ,gpointer p)
{
  int i ,j ,igen;
  GtkWidget *vb ,*ta; 
  char buf[128];
  cups_idest = gg_get_int (w_print_dest);
  PrintDest *pd = device_cups_get_printdest (cups_idest);
  snprintf (buf ,128 ,"GraceGTK: CUPS setup : %s" ,pd->printer);
  w_cups_dialog = gg_CreateAACDialog (buf ,gg_printwin_browse_AAC_CB ,0 ,0 ,&vb);
  w_cups_noteb 	= gtk_notebook_new ();
  gtk_box_pack_start_defaults (GTK_BOX (vb) ,w_cups_noteb);
  igen = 0;
  for (i = 0; i < pd->nogroups; i++) {
    PrintOptGroup *og 	 = &pd->ogroups[i];
    w_cups_noteb_tabs[i] = gg_CreateTabPage (w_cups_noteb ,og->text);
    ta 			 = gg_frame (w_cups_noteb_tabs[i] ,NULL  ,&wheat ,2 ,40);
    for (j = 0; j < og->nopts && j < 40; j++) {
      po 			 = &og->opts[j];
      w_cups_noteb_options[i][j] = gg_combo_fun2 (ta ,po->text ,&(po->nchoices) ,po_choices ,po->defaut);
    }
    if (compare_strings (og->text, "General") == TRUE) igen = i;
  }
 gtk_widget_show_all (w_cups_dialog);
 gtk_notebook_set_current_page (GTK_NOTEBOOK (w_cups_noteb) ,igen);
 }

/**
 * Services the "GraceGTK: CUPS setup" dialog
 */
static void gg_printwin_browse_AAC_CB (GtkWidget *w ,gint reponse)
{
  int i ,j;
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    cups_idest = gg_get_int (w_print_dest);
    pd   = device_cups_get_printdest (cups_idest);
    for (i = 0; i < pd->nogroups; i++) {
      PrintOptGroup *og = &pd->ogroups[i];
      for (j = 0; j < og->nopts && j < 40; j++) {
	po->selected = gg_get_int (w_cups_noteb_options[i][j]);
      }
    }
  }
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_destroy (w_cups_dialog);
  }
}

static void gg_printfile_button_CB (GtkWidget *w ,gpointer p)
{
  if (gg_get_int (w_printto)) {
    gtk_window_set_title (GTK_WINDOW (w_frame) ,"Output file setup");
    gtk_widget_set_sensitive (w_use_cups ,FALSE);
    gtk_widget_show_all (w_box_file);
    gtk_widget_hide_all (w_box_prtcmd);
    gtk_widget_hide_all (w_box_dest);
  } else {
    gtk_window_set_title (GTK_WINDOW (w_frame) ,"Printer setup");
    gtk_widget_hide_all (w_box_file);
    gtk_widget_set_sensitive (w_use_cups ,TRUE);
  }
}

static void gg_use_cups_button_CB (GtkWidget *w ,gpointer p)
{
  if (gg_get_int (w_printto)) {
    gtk_widget_show_all (w_box_file);
    gtk_widget_hide_all (w_box_prtcmd);
    gtk_widget_hide_all (w_box_dest);
  } else {
    if (gg_get_int (w_use_cups)) {
      gtk_widget_hide_all (w_box_prtcmd);
      gtk_widget_show_all (w_box_dest);
    } else {
      gtk_widget_show_all (w_box_prtcmd);
      gtk_widget_hide_all (w_box_dest);
    }
  }
}

#else  /* HAVE_CUPS is undefined */

static void gg_printfile_button_CB (GtkWidget *w ,gpointer p)
{
  gtk_widget_set_sensitive (w_use_cups ,FALSE);
  if (gg_get_int (w_printto)) {
    gtk_window_set_title (GTK_WINDOW (w_frame) ,"Output file setup");
    gtk_widget_show_all (w_box_file);
    gtk_widget_hide_all (w_box_prtcmd);
  } else {
    gtk_window_set_title (GTK_WINDOW (w_frame) ,"Printer setup");
    gtk_widget_hide_all (w_box_file);
    gtk_widget_show_all (w_box_prtcmd);
  }
}

static void gg_use_cups_button_CB (GtkWidget *w ,gpointer p)
{
}

#endif /* HAVE_CUPS */
