/**  File gg_regionwin.c
 *  Transcripted from Motif to GTK+ by P. Vincent to
 *   Replace regionwin.c
 */


#include <gtk/gtk.h>

#include "defines.h"
#include "globals.h"
#include "noxprotos.h"
#include "utils.h"

#include "gw_list.h"

#include "gg_gtkinc.h"
#include "gg_protos.h"
#include "gg_events.h"

extern int regiontype;	/* in regionutils.c */

static GtkWidget *define_region_item;
static GtkWidget *define_type_item;

static GtkWidget *status_frame;
static GtkTextBuffer *status_panel;

static char buf[256];


/**
 *  Replace   do_define_region    regionwin.c   75
 */
static void gg_define_region_CB (GtkWidget *widget ,gint response ,gpointer p)
{
  if (response == GTK_RESPONSE_OK) {
    int rtype = gg_get_int (define_type_item);
    nr = gg_get_int (define_region_item);
    gg_define_region (nr, rtype);
  } else if (response == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide_all (widget);
  }
}



/**
 *  Replace   create_define_frame    regionwin.c   83
 */
void gg_create_regiondef_popup (void)
{
  static GtkWidget *top ,*vb;

  if (top == NULL) {
    top = gtk_dialog_new_with_buttons ("Define region"   ,NULL
				       ,GTK_DIALOG_DESTROY_WITH_PARENT
				       ,GTK_STOCK_OK     ,GTK_RESPONSE_OK
				       ,GTK_STOCK_CLOSE ,GTK_RESPONSE_CLOSE
				       ,NULL);
				       
    vb = GTK_DIALOG (top)->vbox;

    define_region_item = gg_combo_new (vb ,"Define region:" ,6
					       ,"0" ,"1" ,"2" ,"3" ,"4");
    define_type_item   = gg_combo_new (vb ,"Region type:" ,11
					     ,"Inside polygon"
					     ,"Outside polygon"
					     ,"Above line"
					     ,"Below line"
					     ,"Left of line"
					     ,"Right of line"
					     ,"In Horiz. Range"
					     ,"In Vert. Range"
					     ,"Out of Horiz. Range"
					     ,"Out of Vert. Range");

    g_signal_connect (top ,"delete-event" ,G_CALLBACK (gtk_widget_hide)    ,NULL);
    g_signal_connect (top ,"response"     ,G_CALLBACK (gg_define_region_CB) ,NULL);
  }
  gtk_widget_show_all (top);
}

static GtkWidget *clear_region_item;


/**
 *  Replace   do_clear_region    regionwin.c   131
 */
static void gg_clear_region_CB (GtkWidget *widget ,gint response ,gpointer p)
{
  int i;

  if (response == GTK_RESPONSE_OK) {
    if (gg_get_int (clear_region_item) == MAXREGION) {
      for (i = 0; i < MAXREGION; i++) {
	kill_region (i);
      }
    } else {
      kill_region (gg_get_int (clear_region_item));
    }
    gg_drawgraph();
  } else if (response == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide_all (widget);
  }
}


/**
 *  Replace   create_clear_frame    regionwin.c   147
 */
void gg_create_regionclear_popup (void)
{
  static GtkWidget *top, *vb;

  if (top == NULL) {
    top = gtk_dialog_new_with_buttons ("Clear region"   ,NULL
				       ,GTK_DIALOG_DESTROY_WITH_PARENT
				       ,GTK_STOCK_OK     ,GTK_RESPONSE_OK
				       ,GTK_STOCK_CLOSE ,GTK_RESPONSE_CLOSE
				       ,NULL);
    vb = GTK_DIALOG (top)->vbox;

    clear_region_item = gg_combo_new (vb ,"Clear region:" ,7
					      ,"0" ,"1" ,"2" ,"3" ,"4" ,"All");

    g_signal_connect (top ,"delete-event" ,G_CALLBACK (gtk_widget_hide)    ,NULL);
    g_signal_connect (top ,"response"     ,G_CALLBACK (gg_clear_region_CB) ,NULL);
  }
  gtk_widget_show_all (top);
}


//  /**
//   *  Replace   create_area_frame    regionwin.c   180
//   */
//  // GtkWidget *gg_arealab ,*gg_perimlab;
//  // 
//  // 
//  void gg_create_area_ppopup (void)
//  {
//    static GtkWidget *top, *vb;
//  
//  //  if (top == NULL) {
//  //    top = gg_CreateAACDialog ("Area/perimeter" ,
//  //
//  //gtk_dialog_new_with_buttons ("Define region"   ,NULL
//  // 				       ,GTK_DIALOG_DESTROY_WITH_PARENT
//  // 				       ,GTK_STOCK_OK ,GTK_RESPONSE_CLOSE
//  // 				       ,NULL);
//  //     vb = GTK_DIALOG (top)->vbox;
//  // 
//  //     clear_region_item = gg_combo_new (vb ,"Area/perimeter" ,4
//  // 					      ,"Area" ,"Perimeter" ,"Close");
//  // 
//  // 
//  // 
//  //     g_signal_connect (top ,"delete-event" ,G_CALLBACK (gtk_widget_hide)    ,NULL);
//  //     g_signal_connect (top ,"response"     ,G_CALLBACK (gg_clear_region_CB) ,NULL);
//  //   }
//  }



static GtkWidget *reporton_region_item;
static GtkWidget *reporton_type_item;

/**
 *  Replace   do_reporton_region    regionwin.c   222
 */
static void gg_reporton_region_CB (GtkWidget *widget ,gint response ,gpointer p)
{
  if (response == GTK_RESPONSE_OK) {
    
    int regno =  gg_get_int (reporton_region_item);
    int type  =  gg_get_int (reporton_type_item);
    reporton_region (get_cg (), regno, type);
  } else if (response == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide_all (widget);
  }
}

/**
 *  Replace  create_reporton_frame     regionwin.c   231
 */
void gg_create_reporton_popup (void)
{
  static GtkWidget *top ,*vb;

  if (top == NULL) {
    top = gtk_dialog_new_with_buttons ("Report on region"   ,NULL
				       ,GTK_DIALOG_DESTROY_WITH_PARENT
				       ,GTK_STOCK_OK     ,GTK_RESPONSE_OK
				       ,GTK_STOCK_CLOSE ,GTK_RESPONSE_CLOSE
				       ,NULL);
    vb = GTK_DIALOG (top)->vbox;

    reporton_region_item = gg_combo_new (vb ,"Report on sets in region:" ,8
						 ,"0" ,"1" ,"2" ,"3" ,"4"
						 ,"Inside world" ,"Outside world");

    reporton_type_item = gg_combo_new (vb ,"Report type:" ,3
					       ,"Sets" ,"Points");

    g_signal_connect (top ,"delete-event" ,G_CALLBACK (gtk_widget_hide)    ,NULL);
    g_signal_connect (top ,"response"     ,G_CALLBACK (gg_reporton_region_CB) ,NULL);
  }
  gtk_widget_show_all (top);
}


/**
 *  Replace    set_status_label   regionwin.c   268
 */
//  clear_status         regionwin.c   279

/**
 *  Replace    update_status_popup   regionwin.c   287
 */
static void gg_update_status (void)
{
  GtkTextIter start ,end;
  int rno;

  gtk_text_buffer_get_bounds     (status_panel ,&start ,&end);
  gtk_text_buffer_delete         (status_panel ,&start ,&end);
  sprintf(buf, " Region\t# Active\t  Type\n");
  gtk_text_buffer_insert_at_cursor (status_panel ,buf ,-1);
  for (rno = 0; rno < MAXREGION; rno++) {
    sprintf (buf, "  %2d \t %3s \t %6s\n", rno, on_or_off (rg[rno].active),
	     region_types (rg[rno].type, 0));
    gtk_text_buffer_insert_at_cursor (status_panel ,buf ,-1);
  }
}

static void gg_update_status_CB (GtkWidget *widget ,gint response ,gpointer p)
{
  if (response == GTK_RESPONSE_OK) {
    gg_update_status ();
  } else if (response == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide_all (widget);
  }


}


/**
 *  Replace    define_status_popup   regionwin.c   305
 */
void gg_define_status_popup (void)
{
  static GtkWidget *vb;

  if (status_frame == NULL) {
    status_frame = gtk_dialog_new_with_buttons ("Status" ,NULL
				       ,GTK_DIALOG_DESTROY_WITH_PARENT
				       ,"Update"        ,GTK_RESPONSE_OK
				       ,GTK_STOCK_CLOSE ,GTK_RESPONSE_CLOSE
				       ,NULL);
    vb = GTK_DIALOG (status_frame)->vbox;
    status_panel = gg_CreateScrollTextItem2 (vb ,200 ,200 ,"Status");
    g_signal_connect (status_frame ,"delete-event" ,G_CALLBACK (gtk_widget_hide)     ,NULL);
    g_signal_connect (status_frame ,"response"     ,G_CALLBACK (gg_update_status_CB) ,NULL);
  }
  gg_update_status ();
  gtk_widget_show_all (status_frame);
}





/**
 *  Replace   define_region    regionwin.c   375
 */
void gg_define_region (int nr ,int rtype)
{
  kill_region(nr);
  gg_drawgraph();
  switch (rtype) {
  case 0:
    regiontype = REGION_POLYI;
    gg_do_select_region ();
	break;
    case 1:
	regiontype = REGION_POLYO;
	gg_do_select_region ();
	break;
    case 2:
	regiontype = REGION_ABOVE;
	gg_set_action (DO_NOTHING);
	gg_set_action (DEF_REGION1ST);
	break;
    case 3:
	regiontype = REGION_BELOW;
	gg_set_action (DO_NOTHING);
	gg_set_action (DEF_REGION1ST);
	break;
    case 4:
	regiontype = REGION_TOLEFT;
	gg_set_action (DO_NOTHING);
	gg_set_action (DEF_REGION1ST);
	break;
    case 5:
	regiontype = REGION_TORIGHT;
	gg_set_action (DO_NOTHING);
	gg_set_action (DEF_REGION1ST);
	break;
    case 6:
        regiontype= REGION_HORIZI;
	gg_set_action (DO_NOTHING);
	gg_set_action (DEF_REGION1ST);
	break;
    case 7:
        regiontype= REGION_VERTI;
	gg_set_action (DO_NOTHING);
	gg_set_action (DEF_REGION1ST);
	break;
    case 8:
        regiontype= REGION_HORIZO;
	gg_set_action (DO_NOTHING);
	gg_set_action (DEF_REGION1ST);
	break;
    case 9:
        regiontype= REGION_VERTO;
	gg_set_action (DO_NOTHING);
	gg_set_action (DEF_REGION1ST);
	break;
    }
}
