#ifndef __GW_LIST_H__
#define __GW_LIST_H__


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtkliststore.h>
#include <gtk/gtkadjustment.h>



G_BEGIN_DECLS

#define GW_LIST_TYPE            (gw_list_get_type ())
#define GW_LIST(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj) ,GW_LIST_TYPE ,Gw_list))
#define GW_LIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass)  ,GW_LIST_TYPE ,Gw_listClass))
#define IS_GW_LIST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj) ,GW_LIST_TYPE))
#define IS_GW_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass)  ,GW_LIST_TYPE))


typedef struct _Gw_list       Gw_list;
typedef struct _Gw_listClass  Gw_listClass;

typedef struct {
  GtkWidget *liste;    /* the gw_list used */
  gint userdata;              /* a user data */
  void *func;          /* the function called for each selected row */
  void *final;         /*  the function called after */
} Gw_listData;


enum { GW_LIST_STR_COL       /* string printed in the column 1*/
       ,GW_LIST_NUM_COL      /* number */
       ,GW_LIST_BOOL_COL     /* visibility flag */
       ,GW_LIST_NB_COLS };

struct _Gw_list
{
  GtkScrolledWindow swlist;

  GtkAdjustment *h ,*v; 
  GtkWidget    *view;
  GtkTreeModel *model;
  GtkListStore *store;
  gint         type_select;
  gboolean     *selected;
  gint         nb_selected;
  gint         last_selected;
};

struct _Gw_listClass
{
  GtkScrolledWindowClass parent_class;

  void (* gw_list) (Gw_list *ttt);
};

GType       gw_list_get_type     (void);
GtkWidget*  gw_list_new          (char *title ,char *title_col1 ,gint type_select);

void        gw_list_append  	      (Gw_list *ttt ,gchar *buf ,gint n ,gboolean bool);
void        gw_list_clear   	      (Gw_list *ttt);
gboolean    gw_list_set     	      (Gw_list *ttt ,gint row ,gchar *buf ,gint n ,gboolean bool);
gboolean    gw_list_get 	      (Gw_list *ttt ,gint row ,gchar **buf ,gint *n ,gboolean *bool);
void        gw_list_remove  	      (Gw_list *ttt ,gint row);
void        gw_list_get_selected_rows (Gw_list *ttt ,gboolean *rows ,gint *last);
gint        *gw_list_selected_list    (Gw_list *ttt ,gint *ns);
gint        gw_list_get_first_selected_row_num (Gw_list *ttt);
void        gw_list_select            (Gw_list *ttt ,gint row);
void        gw_list_select_all        (Gw_list *ttt);
void        gw_list_unselect_all      (Gw_list *ttt);
void        gw_list_inverse_selection (Gw_list *ttt);
gint        gw_list_count_rows        (Gw_list *ttt);
gint        gw_list_count_rows_selected (Gw_list *ttt);

void        gw_list_connect (GtkWidget *button
			     ,void (*func) (gint userdata ,gint nbsel ,gchar *buf ,gint i ,gboolean bool)
			     ,void (*final) (GtkWidget *liste  ,gpointer puserdata)
			     ,GtkWidget *liste ,gint userdata
			     );
G_END_DECLS

#endif /* __GW_LIST_H__ */

