/**
 *  File nn_cmd.h utilities for printing commands
 */

#ifndef __NN_CMD_H_
#define __NN_CMD_H_

void nn_cmd_all     (int al);
void nn_cmd_undo_on (int sw);
void nn_cmd_prefix (char *pref);

void nn_cmd_set_filep  (FILE *fp);
FILE *nn_cmd_get_filep (void);
void nn_cmd_set_time   (void *w ,long int sec ,long int usec);

/* one integer variable */
void nn_cmd_2i 		(int *old1 ,int *old2 ,int new1 ,int new2 ,char *fmt);
void nn_cmd_i         	(int *old ,int new ,const char *fmt);
void nn_cmd_fmt       	(int *old ,int new ,const char *fmt);
void nn_cmd_font      	(int *old ,int new ,const char *fmt);
void nn_cmd_cmap      	(int *old ,int new ,const char *fmt);
void nn_cmd_on_off    	(int *old ,int new ,const char *fmt);
void nn_cmd_linecolor   (int *old ,int new ,const char *fmt);
void nn_cmd_in_out    	(int *old ,int new ,const char *fmt);
void nn_cmd_para_perp 	(int *old ,int new ,const char *fmt);
void nn_cmd_auto_spec 	(int *old ,int new ,const char *fmt);
void nn_cmd_tick_spec 	(int *old ,int new ,const char *fmt);
void nn_cmd_t_f       	(int *old ,int new ,const char *fmt);
void nn_cmd_w_v       	(LocType *old ,LocType new ,const char *fmt);
void nn_cmd_placemnt  	(PlacementType *old ,PlacementType new ,const char *fmt);

/* one double variable */
void nn_cmd_d      (double *old ,double new ,const char *fmt);
/* 2 doubles */
void nn_cmd_2d (double *old1 ,double *old2 ,double new1 ,double new2 ,char *fmt);
/* 4 doubles */
void nn_cmd_4d (double *old1 ,double *old2 ,double *old3 ,double *old4
	       ,double new1 ,double new2  ,double new3  ,double new4
		,const char *fmt);

/* a string */
void nn_cmd_str    (char **old ,char *new ,const char *fmt);
void nn_cmd_strn (int n ,char *old ,char *new ,const char *fmt);

void nn_cmd_world 	(world 	*old ,world new ,const char *fmt);
void nn_cmd_view  	(view  	*old ,view  new ,const char *fmt);
void nn_cmd_region_type (int   	*old ,int   new ,const char *fmt);
void nn_cmd_region_line (region *old ,int   i   ,const char *fmt);
void nn_cmd_graph_scale (int    *old ,int gno ,int axisno  ,const char *fmt);

/* undo / redo interface */
void nn_cmd_undo_new     (void);
void nn_cmd_undo_destroy (void);
void nn_cmd_undo_start (int with_gno ,int gno);
void nn_cmd_undo_end   (int with_gno ,int gno);
int  nn_cmd_undo_undo  (void);
int  nn_cmd_undo_redo  (void);
void nn_cmd_undo_store (int wipe_with);

void nn_cmd_legendbox 	    (int gno ,legend *old ,QDobject *oobj ,int all ,int undo_on);
void nn_cmd_layer_collapsed (int i ,int layer);

#endif /* __NN_CMD_H_ */
