/**
 *   File nn_tree.h
 */

#ifndef __NN_TREE_H_
#define __NN_TREE_H_

#include "defines.h"

#define ORPHAN -2

#ifdef DEBUG
void print_objs (void);
void print_tree (void);
void check_tree (void);
#endif /* DEBUG */

void nn_init_node  	      (int i ,Qtype typ);
void nn_get_link_info         (int i ,int *links);
void nn_set_link_info 	      (int i ,int *links);
int  nn_get_father 	      (int i);
int  nn_get_last_brother      (int i);

void nn_insert_brother_after  (int i ,int b);
void nn_append_brother 	      (int elder  ,int b);
void nn_insert_child   	      (int elder ,int c);
void nn_append_child   	      (int elder ,int c);

void nn_insert_typed_brother (Qtype typ ,int elder ,int b);
void nn_append_typed_brother (int elder ,int b);
void nn_append_typed_child   (Qtype typ ,int elder ,int c);
void nn_prune                (int i);
void nn_swap_nodes 	     (int i1 ,int i2);
void nn_move_as_child        (int elder ,int c);


void nn_traverse_stop          (int swt);
void nn_traverse_child_first   (int start
				,void (*f1) (int i ,int depth)
				,void (*f2) (int i ,int depth));
void nn_traverse_with_middle   (int start
				,void (*f1) (int i ,int depth)
				,void (*f2) (int i ,int depth)
				,void (*f3) (int i ,int depth));

void nn_kill_node     (int i ,int depth);
void nn_kill_branch   (int i);
void nn_kill_youngers (int i);

#endif /* __NN_TREE_H_ */
