/** File pars_tree.h
 */

#ifndef __PARS_TREE_H_
#define __PARS_TREE_H_


#define PARSER_TYPE_VOID    0
#define PARSER_TYPE_EXPR    1
#define PARSER_TYPE_VEXPR   2
#define PARSER_TYPE_PUSH    3

//flow  typedef enum  {
//flow    PARSER_TYPE_VOID    0
//flow    ,PARSER_TYPE_EXPR    1
//flow    ,PARSER_TYPE_VEXPR   2
//flow  } ParserType;


typedef enum  {
  PTREE_ROOT
  ,PTREE_COMMAND
  ,PTREE_IF_BEGIN
  ,PTREE_BRACE_CLOSE
} ParsTreeNodeType;


typedef struct _ParsTreeNode ParsTreeNode;

struct _ParsTreeNode {
  ParsTreeNodeType typ;
  ParsTreeNode     *elder ,*brother ,*child;
  char             *cmd;
};

ParsTreeNode *ptree_init 	   (void);
ParsTreeNode *ptree_node_new       (ParsTreeNodeType typ);
ParsTreeNode *ptree_child_append   (ParsTreeNode *node ,ParsTreeNodeType typ ,char *cmd);
ParsTreeNode *ptree_brother_append (ParsTreeNode *node ,ParsTreeNodeType typ ,char *cmd);
int           ptree_node_free      (ParsTreeNode *node);
ParsTreeNode *ptree_if_begin       (ParsTreeNode *node);
int           ptree_brace_close    (ParsTreeNode *node);



#endif /* __PARS_TREE_H_ */
