/** File  wu.c
 *  Management of update popups
 *
 *  The Wu system allows to build simultaneously two windows:
 *  + the "normal" windows
 *  + the "update" windows made of check buttons allowing to
 *                 choose the items for a selective update
 */

#include <gtk/gtk.h>

#include "defines.h"
#include "utils.h"

#include "gw_list.h"

#include "gg_gutil.h"
#include "gg_gtkinc.h"
#include "gg_frame.h"

#include "wu.h"

static GtkWidget *uvbox;   /* the box produced by gg_CreateAACDialog for the update window */
static gboolean update_on = FALSE;

void wu_uvbox_set (GtkWidget *u)
{
  uvbox = u;
}

void wu_update_on (gboolean on)
{
  update_on = on;
}

void wu_reset_u (Wu wu)
{
  gg_set_int (wu.u ,FALSE);
}

/********** F R A M E  with  C O L O U R  B A C K G R O U N D ***********
 * If nx==0 , it is a Vbox
 * If ny==0 , it is a Hbox
 * Else, it is a table using the gg_frame_attach/ii/xx/yy  procedure
 */
/* get values */

void wu_get_int (Wu wu ,int *n)
{
  if (gg_get_int (wu.u)) {
    *n = gg_get_int (wu.w);
  }
}

void wu_get_dble (Wu wu ,double *d)
{
  if (gg_get_int (wu.u)) {
    *d = gg_get_dble (wu.w);
  }
}

gboolean wu_evalexpr (Wu wu ,double *answer)
{
  if (gg_get_int (wu.u)) {
    return gg_evalexpr (wu.w ,answer);
  }
  return RETURN_SUCCESS;
}


void wu_get_op (Wu wu ,PlacementType *op)
{
  if (gg_get_int (wu.u)) {
    *op = gg_get_int (wu.w);
  }
}
