/*
 * GraceGTK - GRaphing, Advanced Computation and Exploration of data
 * 
 * Home page: http://gracegtk.sourceforge.net
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#ifdef HAVE_FCNTL_H
#  include <fcntl.h>
#endif

/* for globals.h */
#define MAIN
#include "globals.h"

#include "utils.h"
#include "files.h"
#include "ssdata.h"

#include "graphs.h"
#include "graphutils.h"
#include "plotone.h"

#include "device.h"
#include "devlist.h"
#ifndef NONE_GUI
#ifdef WITH_GTK
#  include <gtk/gtk.h>
#  include "noxprotos.h"
#  include "gg_protos.h"
#  include "gg_gtkdrv.h"
#endif    /* WITH_GTK */
#endif
#include "parser.h"

#include "fourier.h"

extern char batchfile[];
extern char print_file[];
extern int install_cmap;

extern Input_buffer *ib_tbl;
extern int ib_tblsize;

int inpipe = FALSE;


#if defined(DEBUG)    
    extern int yydebug;
#endif

#ifdef WITH_GTK
int gg_initialize_gui(int *argc, char **argv);
void gg_start_gtk_gui (int *argc, char **argv);
#endif

/**
 * Initialize the API
 *  Compare to ../src/main.c 
 */

void gg_api_init (void)
{
  static int argc = 0;
  static char **argv = NULL;
  char *s;
  int cur_graph;	        /* default (current) graph */
  int sigcatch = TRUE;		/* we handle signals ourselves */

  reset_project_version();    	/* set version */
  if ((s = getenv("GRACEGTK_HOME")) != NULL) {
    set_grace_home(s);    	/* grace home directory */
  }
  init_username();    		/* define the user's name */
  init_userhome();    		/* define the user's home dir */
  set_workingdir(NULL);    	/* set the starting directory */
  if ((s = getenv("GRACE_PRINT_CMD")) != NULL) {
    set_print_cmd(s);     	/* print command */
  }
  /* if no print command defined, print to file by default */
  s = get_print_cmd();
  if (s == NULL || s[0] == '\0') {
    set_ptofile(TRUE);
  } else {
    set_ptofile(FALSE);
  }
  if ((s = getenv("GRACE_EDITOR")) != NULL) {
    set_editor(s);     /* editor */
  }
  if ((s = getenv("GRACE_HELPVIEWER")) != NULL) {
    set_help_viewer(s);  	 /* check for changed help file viewer command */
  }
  set_program_defaults();    	 /* initialize plots, strings, graphs */
  initialize_nonl();    	 /* initialize the nonl-fit parameters */
  fourier_set_defaults ();    	 /* initialize transform parameters */
  diff_set_defaults    ();
  init_symtab();    		 /* initialize the parser symbol table */

  /* initialize the rng */
#ifdef HAVE_X11
  srand48(100L);
#else
  srand(100L);
#endif    

  /* initialize T1lib */
  if (init_t1() != RETURN_SUCCESS) {
    errmsg("T1lib --> Broken or incomplete installation - read the FAQ!");
    exit (1);
  }
  // #endif
  
  initialize_cmap();    	/* initialize colormap data */

  if (gg_initialize_gui (&argc, argv) != RETURN_SUCCESS) {
    errmsg("Failed initializing GTK GUI, exiting");
    exit(1);
  }
  tdevice = register_gtk_drv (); 
  select_device(tdevice);
  hdevice = register_ps_drv();
  register_eps_drv ();

#ifdef HAVE_LIBPDF
  register_pdf_drv();
#endif
  register_mif_drv();
  register_svg_drv();
  register_pnm_drv();
#ifdef HAVE_LIBJPEG
  register_jpg_drv();
#endif
#ifdef HAVE_LIBPNG
  register_png_drv();
#endif
  register_mf_drv();

  /* check whether locale is correctly set */
  if (init_locale() != RETURN_SUCCESS) {
    errmsg("Invalid or unsupported locale");
  }
  set_locale_num (FALSE);  /* default is POSIX */
  getparms ("gracerc");    /* load startup file */
  new_project (NULL);      /* load default template */
  
  cur_graph = get_cg();

  if (sigcatch == TRUE) {
    installSignal ();   /* Process events. */
  }

  gg_start_gtk_gui (&argc ,argv);
}
