/**
 *  File ge_colorbar.c
 *
 *  Manage menus for Q_Colorbar
 */

#define _GE_COLORBAR_

#include <gtk/gtk.h>

#include "globals.h"

#include "defines.h"
#include "utils.h"

#include "gw_choice.h"
#include "gw_list.h"

#include "gg_gutil.h"
#include "gg_gtkinc.h"
#include "gg_protos.h"
#include "gg_events.h"

#include "ge_protos.h"
#include "ng_objects.h"
#include "wu.h"
#include "zc.h"

#include "ge_tree.h"

#include "gg_icons_xfig.h"

extern GdkColor  bleuciel ,wheat;

/* From ge.c */
extern Ge_tree *get_getree (void);

/* Follow me variables */
static QDobject oa;

static GtkWidget *titre_item = NULL;
static GtkWidget *vbox 	     = NULL;

/************************************************************/
static int menu_finalized 	= FALSE;
static int block_instant_update = FALSE;

/**************************************************************/
/*  Widgets for QDobject struct  elements (see defines.h 483) */
static Wu start;
static Wu stop;
static Wu nticks;
static Wu color;
static Wu linew;
static Wu lines;
static Wu font;
static Wu charsize;
static Wu just;
static spin2Struct xy1 ,xy2;
static Wu layer;
static Wu hidden;
/**************************************************************/
static int iobj = -1;

static void ge_colorbar_autoscale_CB (GtkWidget *w ,gpointer p);

GtkWidget *ge_colorbar_create_menu (GtkWidget *parent)
{
  GtkWidget *vbox1 ,*hbox ,*fr ,*bt ,*w_blank;
  char buf[32];

  if (titre_item == NULL) {
    gint d = gg_get_depth ();
    vbox = gg_CreateVContainer (parent);
    sprintf (buf ,"Graph  Colorbar");
    titre_item = gg_label_new (vbox ,buf);
    gg_frame_connect (ge_colorbar_apply_CB);

    fr = gg_frame (vbox ,"Colorbar scale" ,&wheat ,2 ,2);
    start.w  = gg_entry_new (fr, "Start:", 14);
    stop.w   = gg_entry_new (fr, "Stop:" , 14);
    nticks.w = gg_spin_new  (fr ,"Nb ticks" ,2.0 ,31. ,1.0);
    gg_buttonA (fr ,"Autoscale" ,ge_colorbar_autoscale_CB ,0);

    fr = gg_frame (vbox ,"Frame, ticks & labels style" ,&wheat ,2 ,4);
    linew.w    = gg_spin_new  	 (fr ,"Line width:" ,0.0 ,MAX_LINEWIDTH ,0.5);
    w_blank    = gg_label_new 	 (fr ,NULL);
    lines.w    = gg_lines_new 	 (fr ,"Line style:");
    color.w    = gg_color_new 	 (fr ,"Color");
    just.w     = gg_combo_new    (fr  ,"Place:" ,4
				  ,"None"          /* ZC_LABELS_NONE */
				  ,"Right"         /* ZC_LABELS_RIGHT */
				  ,"Left");        /* ZC_LABELS_LEFT */
    w_blank    = gg_label_new 	 (fr ,NULL);
    font.w     = gg_font_new     (fr  ,"Font:");
    charsize.w = gg_charsize_new (fr  ,"Font size");

    /* --------------- Bottom widgets  ------------------ */

    vbox1 = gtk_vbox_new (FALSE, 3);
    gtk_box_pack_end (GTK_BOX (vbox) ,vbox1 , FALSE, TRUE, 1);    
    /* Localization of the  colorbar*/
    fr = gg_frame (vbox1 ,"Colorbar corners" ,&wheat ,0 ,1);
    /* gg_spin2d use gtk_box_pack_end, thus must be in reverse order */
    gg_spin2d (fr ,&xy2 ,-10.0 ,10.0 ,0.01);
    gg_spin2d (fr ,&xy1 ,-10.0 ,10.0 ,0.01);
    layer.w = gg_layer_new (vbox1 ,"Layer");

    hbox 	   = gg_CreateHContainer (vbox1);
    hidden.w = gg_check_new (hbox ,"Hide");
    bt 	   = gg_buttonB (hbox ,22 ,d ,move_bits   ,gg_act_on_cur_obj_CB ,MOVE_OBJ_1ST  ,"Move colorbar"); 
    bt 	   = gg_buttonB (hbox ,22 ,d ,scale_bits  ,gg_act_on_cur_obj_CB ,SCALE_OBJ_1ST ,"Scale colorbar");

    /* --------------- Callbacks --------------- */
    menu_finalized = TRUE;
    gg_frame_connect (NULL);
  }
  return vbox;
}



/**
 *  Update the rpane and the handles
 */
void ge_colorbar_update (int i)
{
  QDobject *po;
  int gno ,setno;
  plotarr p;
  char buf[32];
  if (titre_item != NULL) {
    if (obj_get_plotarr (i ,&po ,&gno ,&setno ,&p) == RETURN_SUCCESS) {
      block_instant_update = TRUE;
      gg_setstr_d   (start.w ,"%g" ,p.contour.z1 ,buf);
      gg_setstr_d   (stop.w  ,"%g" ,p.contour.z2 ,buf);
      gg_set_int    (nticks.w      ,p.contour.nticks);
      gg_set_int    (color.w       ,po->color  );
      gg_set_int    (lines.w       ,po->lines  );
      gg_set_dble   (linew.w       ,po->linew  );
      gg_set_int    (just.w        ,po->just );
      gg_set_int    (font.w        ,po->font );
      gg_set_dble   (charsize.w    ,po->charsize);
      gg_spin2d_set (&xy1  ,"X1="  ,po->x1 ,"Y1=" ,po->y1);
      gg_spin2d_set (&xy2  ,"X2="  ,po->x2 ,"Y2=" ,po->y2);
      gg_set_int    (hidden.w      ,po->hidden);
      gg_set_int    (layer.w       ,po->layer);
      set_graph_plotarr (gno ,setno ,&p);
      iobj = i;
      block_instant_update = FALSE;
    
    //15 provisoire
    p.contour.type     = 1;
    p.contour.spacing  = 0;
    }
  }
}

/**
 * "i" is the index of the colorbar in objs[]
 * "dummy"  is to be called by tree traversal
 */
void ge_colorbar_apply (int dummy ,int i)
{
  QDobject *po;
  int gno ,setno;
  plotarr p;
  Contour ocontour;
  double z1 ,z2;
  if (titre_item != NULL) {
    if (obj_get_plotarr (i ,&po ,&gno ,&setno ,&p) == RETURN_SUCCESS) {
      ocontour = p.contour;
      z1     = gg_get_dble (start.w);
      z2     = gg_get_dble (stop.w);
      if (z1 < z2) {
	p.contour.z1 = z1;
	p.contour.z2 = z2;
      } else {
	errmsg ("Stop must be greater than start.");
	return;
      }
      obj_copy (&oa ,po);                         /* undo/redo and follow_me_on */
      p.contour.nticks = gg_get_int  (nticks.w);
      po->color  	     = gg_get_int  (color.w);
      po->lines  	     = gg_get_int  (lines.w);
      po->linew  	     = gg_get_dble (linew.w);
      po->just         = gg_get_int  (just.w);
      po->font         = gg_get_int  (font.w);
      po->charsize     = gg_get_dble (charsize.w);
      po->x1     	     = gg_get_dble (xy1.spin1);
      po->y1     	     = gg_get_dble (xy1.spin2);
      po->x2     	     = gg_get_dble (xy2.spin1);
      po->y2     	     = gg_get_dble (xy2.spin2);
      po->hidden 	     = gg_get_int  (hidden.w);
      po->layer  	     = gg_get_int  (layer.w);


      //15 provisoire  (faire aussi undo/redo)
      p.contour.type     = 1;
      p.contour.spacing  = 0;

      set_graph_plotarr (gno ,setno ,&p);
      ge_tree_need_update  (!ge_select_current ());
      gg_update_layers_hbox ();
      set_dirtystate ();
      gg_drawgraph   ();

      /* undo/redo and follow_me_on */
      nm_cmd_colorbar (&oa ,po ,&ocontour ,&(p.contour) ,gno ,setno ,FALSE ,TRUE);
    }
  }
}

/**************** C A L L B A C K S ****************/

void ge_colorbar_apply_CB (GtkWidget *w ,gpointer p)
{
  if (instant_update && menu_finalized && block_instant_update == FALSE) {
    ge_colorbar_apply (0 ,cur_obj_num);
  }
}

static void ge_colorbar_autoscale_CB (GtkWidget *w ,gpointer pp)
{
  QDobject *po;
  int gno ,setno;
  plotarr p;
  if (obj_get_plotarr (iobj ,&po ,&gno ,&setno ,&p) == RETURN_SUCCESS) {
    p.contour.nticks  = gg_get_int (nticks.w);
    set_graph_plotarr (gno ,setno ,&p);
    zc_autoscale (iobj);
    ge_colorbar_update (iobj);
#if defined (HAVE_CONTOURS)
    zc_label_free_list (gno ,setno);
#endif  /* HAVE_CONTOURS */
    set_dirtystate ();
    gg_drawgraph   ();    
  }
}


/***************************** Button 3 menu **************************/

static GtkWidget *u_colorbar_dialog = NULL;

/**
 *  ge_colorbar_menu3_CB creates and execute the menu
 *                  when set(s) are clicked with mouse button 3
 *  Called by ge_tree_CB via ge_colorbar_popup_menu3 
 *  Compare to gg_colorbar_menu_CB
 *  Compare to ge_graph_menu3_CB and ge_axis_menu3_CB
 */

static GtkWidget *ge_colorbar_u_new (void);
static void  	  ge_colorbar_u_AAC_CB (GtkWidget *widget ,gint reponse);

ColorbarMenu3Struct *ge_CreateColorbarPopupEntries (ColorbarMenu3Struct *p ,GtkWidget *list
					  ,void (*CB) (GtkWidget *colorbar_list ,gpointer p))
{
  GtkWidget *menu;
  if (p  == NULL) {
    p = xmalloc (sizeof (ColorbarMenu3Struct));
    menu = gtk_menu_new ();
    p->popup 	 = menu;
    p->hide  	 = gg_CreateMenuButton (menu ,"Hide"          ,'H'  ,list ,CB ,MenuHideCB);
    p->show  	 = gg_CreateMenuButton (menu ,"Show"          ,'S'  ,list ,CB ,MenuShowCB);
    p->update 	 = gg_CreateMenuButton (menu ,"Update"        ,' '  ,list ,CB ,MenuObjsUpdate);
  }
  return (p);
}

/**
 *  
 *  Called by ge_tree_CB when Button3 is pressed and
 *  selected objects are colorbars
 */
void ge_colorbar_popup_menu3 (ColorbarMenu3Struct *p)
{
  gtk_menu_popup (GTK_MENU(p->popup) ,NULL ,NULL ,NULL ,NULL ,3
		  ,gtk_get_current_event_time () );
}

/**
 * identical to ge_obj_hide ()
 */
static void ge_colorbar_hide (int action ,int num)
{
  int hide = (action == MenuHideCB);
  objs[num].hidden = hide;
  ge_hidden_update (objs[num].typ ,objs[num].id ,objs[num].father_typ ,objs[num].father_id ,hide);
}

void ge_colorbar_menu3_CB  (GtkWidget *w ,gpointer pact)
{
  gint action = GPOINTER_TO_INT (pact);
  switch (action) {
    case MenuHideCB:
    case MenuShowCB:
      if (ge_selection_for_each (action ,ge_colorbar_hide)) {
	gg_drawgraph();
      }
      break;
  case MenuObjsUpdate:
    ge_colorbar_u_new ();
    wu_update_on (TRUE);
    break;
  }
}


/************** COLLECTIVE and SELECTIVE UPDATE of COLORBAR *******************/

#define U_RESET 1001

static GtkWidget *u_x1 ,*u_y1;
static GtkWidget *u_x2 ,*u_y2;

static GtkWidget *ge_colorbar_u_new (void)
{
  GtkWidget *vb ,*ta ,*w_blank;
  if (u_colorbar_dialog == NULL) {
    u_colorbar_dialog = gg_CreateAACDialog ("Update params." ,ge_colorbar_u_AAC_CB ,0 ,0 ,&vb);
    gtk_dialog_add_buttons (GTK_DIALOG (u_colorbar_dialog) ,"Reset" ,U_RESET ,NULL);
    gg_label_new (vb ,"Choose items to update in the selected colorbar(s)");

    ta 	     = gg_frame     (vb ,"Colorbar layer" ,&wheat ,4,1);
    layer.u  = gg_check_new (ta, "Layer");

    ta 	     = gg_frame     (vb ,"Colorbar scale" ,&wheat ,4 ,1);
    start.u  = gg_check_new (ta ,"Start:");
    stop.u   = gg_check_new (ta ,"Stop:");
    nticks.u = gg_check_new (ta ,"Nb ticks");

    ta 	       = gg_frame     (vb ,"Frame, ticks & labels style" ,&wheat ,4 ,3);
    linew.u    = gg_check_new (ta ,"Line width");
    lines.u    = gg_check_new (ta ,"Line style");
    color.u    = gg_check_new (ta ,"Color");
    just.u     = gg_check_new (ta ,"Place");
    font.u     = gg_check_new (ta ,"Font:");
    charsize.u = gg_check_new (ta ,"Font size");
    w_blank    = gg_label_new (ta ,NULL);
    w_blank    = gg_label_new (ta ,NULL);
    u_x1       = gg_check_new (ta, "X1");
    u_y1       = gg_check_new (ta, "Y1");
    u_x2       = gg_check_new (ta, "X2");
    u_y2       = gg_check_new (ta, "Y2");
  }
  gtk_widget_show_all (u_colorbar_dialog);
  return u_colorbar_dialog;
}

void ge_colorbar_u_apply (int action ,int num)
{
  QDobject *po;
  int gno ,setno;
  plotarr p;
  if (obj_get_plotarr (num ,&po ,&gno ,&setno ,&p) == RETURN_SUCCESS) {
    wu_get_int  (nticks   ,&(p.contour.nticks));
    wu_get_dble (start    ,&(p.contour.z1));
    wu_get_dble (stop     ,&(p.contour.z2));
    wu_get_int  (color 	  ,&(po->color));
    wu_get_int 	(lines 	  ,&(po->lines));
    wu_get_dble (linew 	  ,&(po->linew));
    wu_get_int 	(just  	  ,&(po->just));
    wu_get_int 	(font  	  ,&(po->font));
    wu_get_dble (charsize ,&(po->charsize));
    wu_get_int 	(hidden   ,&(po->hidden));
    wu_get_int 	(layer    ,&(po->layer));
    if (gg_get_int (u_x1)) po->x1 = gg_get_dble (xy1.spin1);
    if (gg_get_int (u_y1)) po->y1 = gg_get_dble (xy1.spin2);
    if (gg_get_int (u_x2)) po->x2 = gg_get_dble (xy2.spin1);
    if (gg_get_int (u_y2)) po->y2 = gg_get_dble (xy2.spin2);
    set_graph_plotarr (gno ,setno ,&p);
  }
}

static void ge_colorbar_u_AAC_CB (GtkWidget *widget ,gint reponse)
{
  if (reponse == U_RESET) { 
    gg_set_int (layer.u	   ,FALSE);    
    gg_set_int (start.u	   ,FALSE);    
    gg_set_int (stop.u	   ,FALSE);    
    gg_set_int (nticks.u   ,FALSE);    
    gg_set_int (linew.u	   ,FALSE);          
    gg_set_int (lines.u	   ,FALSE);    
    gg_set_int (color.u	   ,FALSE);     
    gg_set_int (just.u	   ,FALSE);     
    gg_set_int (font.u	   ,FALSE);    
    gg_set_int (charsize.u ,FALSE); 
    gg_set_int (u_x1  	   ,FALSE); 
    gg_set_int (u_y1  	   ,FALSE); 
    gg_set_int (u_x2  	   ,FALSE); 
    gg_set_int (u_y2  	   ,FALSE); 
  } else if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_APPLY) {
    if (ge_selection_for_each (0 ,ge_colorbar_u_apply)) {
      gg_update_layers_hbox ();
      set_dirtystate ();
      gg_drawgraph  ();
    }
  }
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide (u_colorbar_dialog);
  }
  wu_update_on (FALSE);
}
