#ifndef __GE_TREE_H__
#define __GE_TREE_H__


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkscrolledwindow.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtktreestore.h>
#include <gtk/gtkadjustment.h>

G_BEGIN_DECLS

#define GE_TREE_TYPE            (ge_tree_get_type ())
#define GE_TREE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GE_TREE_TYPE, Ge_tree))
#define GE_TREE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GE_TREE_TYPE, Ge_treeClass))
#define IS_GE_TREE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GE_TREE_TYPE))
#define IS_GE_TREE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GE_TREE_TYPE))


typedef struct _Ge_tree       Ge_tree;
typedef struct _Ge_treeClass  Ge_treeClass;

typedef struct {
  GtkWidget *liste;    /* the ge_tree used */
  gint userdata;              /* a user data */
  void *func;          /* the function called for each selected row */
  void *final;         /*  the function called after */
} Ge_treeData;


enum { GE_TREE_TYP
       ,GE_TREE_ID
       ,GE_TREE_PARENT_TYP
       ,GE_TREE_PARENT_ID
       ,GE_TREE_ID_STR
       ,GE_TREE_LABEL
       ,GE_TREE_HIDDEN
       ,GE_TREE_STYLE_COLUMN
       ,GE_TREE_WEIGHT_COLUMN
       ,GE_TREE_NB_COLS };

struct _Ge_tree
{
  GtkScrolledWindow swlist;

  GtkAdjustment *h ,*v; 
  GtkWidget    *view;
  GtkTreeModel *model;
  GtkTreeStore *store;
  gint         type_select;
  gboolean     *selected;
  gint         nb_selected;
  gint         last_selected;
};

struct _Ge_treeClass
{
  GtkScrolledWindowClass parent_class;

  void (* ge_tree) (Ge_tree *ttt);
};

GType       ge_tree_get_type     (void);
GtkWidget* ge_tree_new (char *title
			,char *title_col1
			,char *title_col2
			,void  title_col2_edited (GtkCellRendererText *cell,
						  gchar               *path_string,
						  gchar               *new_text,
						  gpointer             user_data));


void        ge_tree_append       (Ge_tree *ttt ,GtkTreeIter *parent ,GtkTreeIter **child
				  ,gint typ        ,gint id
				  ,gint father_typ ,gint father_id
				  ,gchar *sid ,gchar *label
				  ,gboolean hidden);

void        ge_tree_clear   	      (Ge_tree *ttt);


void        ge_tree_unselect_all      (Ge_tree *ttt);

gboolean ge_tree_get_selected (Ge_tree *ttt
			       ,gint *typ        ,gint *id
			       ,gint *father_typ ,gint *father_id
			       ,gchar **sid ,gchar **label
			       ,gboolean *hidden);
gint     ge_tree_sel_is_homogeneous (Ge_tree *ttt ,gint *typ);
gint 	 ge_tree_sel_is_in_range    (Ge_tree *ttt ,gint start ,gint stop ,gboolean *with_type);

GtkTreePath  *ge_tree_get_graph_path (Ge_tree *ttt ,gint gno);

gboolean ge_tree_get_iter (Ge_tree *ttt ,gint father_typ ,gint father_id ,gint typ ,gint id ,GtkTreeIter *iter);
gboolean ge_tree_remove   (Ge_tree *ttt ,gint father_typ ,gint father_id ,gint typ ,gint id);
gboolean ge_tree_expand   (Ge_tree *ttt ,gint father_typ ,gint father_id ,gint typ ,gint id);
gboolean ge_tree_select   (Ge_tree *ttt ,gint father_typ ,gint father_id ,gint typ ,gint id);
gboolean ge_tree_select_root (Ge_tree *ttt);

G_END_DECLS

#endif /* __GE_TREE_H__ */

