/** File "gg_frame.h"
 *
 */


#ifndef __GG_FRAME_H_
#define __GG_FRAME_H_

#define LINES_BM_HEIGHT 15
#define LINES_BM_WIDTH  64

typedef struct {
  int value;
  char *label;
} gg_OptionItem;

GtkWidget *gg_frame_n (gint un ,GtkWidget *parent ,gchar *label ,GdkColor *couleur ,int nx ,int ny);
GtkWidget *gg_frame   	       (GtkWidget *parent ,gchar *label ,GdkColor *couleur ,int nx ,int ny);
void 	   gg_frame_attach     (GtkWidget *parent, GtkWidget *child);

void 	   gg_frame_set_n  (int un);
GtkWidget *gg_get_w_box    (void);
GtkWidget *gg_get_w_label  (void);

/********** C O N N E C T   F O R   I N S T A N T   U P D A T E **********/
void gg_frame_connect (void (*fun) (GtkWidget *w ,gpointer p));
void gg_frame_connect_with_gpointer (void (*fun) (GtkWidget *w ,gpointer p)  ,gpointer p);

/********** Widgets to be attached into a frame ********/
GtkWidget *gg_vbox_new 	 (GtkWidget *parent);
GtkWidget *gg_hbox_new 	 (GtkWidget *parent);
GtkWidget *gg_hbox_n_new (GtkWidget *parent ,int n);
GtkWidget *gg_angle_new  (GtkWidget *parent, char *s);
GtkWidget *gg_button_new (GtkWidget *parent, char *s);

void       gg_buttonA (GtkWidget *parent ,char *s
		       ,void (*func) (GtkWidget *w ,gpointer p)
		       ,gint action);

GtkWidget *gg_buttonB (GtkWidget *parent ,int side ,int depth
		      ,const unsigned char *bits
		      ,void (*cb) (GtkWidget *w ,gpointer p)
		      ,gint action
		       ,const gchar *tip);

void  	   gg_buttonT (GtkWidget *parent ,char *s
		       ,void (*func) (GtkWidget *w ,gpointer p)
		       ,gint action
		       ,const char *tip);

GtkWidget *gg_charsize_new (GtkWidget *parent ,char *s);
GtkWidget *gg_check_new    (GtkWidget *parent ,char *s);
void 	   gg_checkA 	   (GtkWidget *parent ,char *s
			    ,void (*func) (GtkWidget *w ,gpointer p)
			    ,gint action);

GtkWidget *gg_color_new    (GtkWidget *parent ,char *s);
GtkWidget *gg_combo_fun    (GtkWidget *parent ,char *s ,int *nb_item ,char*(*fun) (int i) ,int active);
GtkWidget *gg_combo_fun2   (GtkWidget *parent ,char *s ,int *nb_item ,char*(*fun) (int i) ,int active);
GtkWidget *gg_combo_new    (GtkWidget *parent, char *labelstr, int nchoices,...);
GtkWidget *gg_entry_new    (GtkWidget *parent ,char *s ,int len);
GtkWidget *gg_string_new   (GtkWidget *parent ,char *s ,int len);
GtkWidget *gg_font_new     (GtkWidget *parent ,char *s);
GtkWidget *gg_format_new   (GtkWidget *parent ,char *s);
GtkWidget *gg_just_new     (GtkWidget *parent ,char *s);
GtkWidget *gg_label_new    (GtkWidget *parent, char *s);
GtkWidget *gg_lines_new    (GtkWidget *parent ,char *label);
GtkWidget *gg_order_new    (GtkWidget *parent ,char *label);

GtkWidget *gg_pannelB (gchar *s ,gint nrows ,gint ncols
				  ,unsigned char **bits ,int width ,int height
				  ,gboolean with_num
		       );

GtkWidget *gg_pattern_new  (GtkWidget *parent ,char *s);

GtkWidget *gg_scale_new    (GtkWidget *parent ,char *s ,double min ,double max ,double delta);
GtkWidget *gg_spin_new 	   (GtkWidget *parent ,char *s ,double min ,double max ,double incr);
GtkWidget *gg_layer_new    (GtkWidget *parent ,char *s);

typedef struct {
  GtkWidget *box;
  GtkWidget *label1;
  GtkWidget *spin1;
  gchar     *s1;
  GtkWidget *label2;
  GtkWidget *spin2;
  gchar     *s2;
} spin2Struct;     /* Used also by gg_entries2d */

void gg_spin2d     (GtkWidget *parent ,spin2Struct *sp2
		    ,gdouble xmin ,gdouble xmax ,gdouble dx);
void gg_spin2d_set (spin2Struct *sp2
		    ,gchar *s1 ,double x1
		    ,gchar *s2 ,double x2);
void gg_spin2i_set (spin2Struct *sp2
		    ,gchar *s1 ,int x1
		    ,gchar *s2 ,int x2);

void gg_spin2e     (GtkWidget *parent ,spin2Struct *sp2
		    ,gdouble xmin ,gdouble xmax ,gdouble dx);

typedef struct {
  GtkWidget *box1 ,*label1 ,*entry1;
  GtkWidget *box2 ,*label2 ,*entry2;
} entry2Struct;

#endif /* __GG_FRAME_H_ */
