/**  gg_locatewin.c
 *  Transcripted from Motif to GTK+ by P. Vincent to
 *  Replace locatewin.c
 */

#include <stdio.h>
#include <gtk/gtk.h>

#include "graphs.h"


#include "gw_pannel.h"
#include "gw_choice.h"
#include "gw_list.h"

#include "gg_gutil.h"
#include "gg_gtkinc.h"
#include "gg_protos.h"

extern GdkColor  bleuciel ,wheat;

static GtkWidget *locator_frame = NULL;

static GtkWidget *fixedp_item   ,*delta_item;
static GtkWidget *loc_formatx   ,*loc_formaty;
static GtkWidget *loc_precx     ,*loc_precy;
static GtkWidget *locx_item     ,*locy_item;

static void gg_locator_AAC_CB (GtkWidget *w ,gint reponse);


/**  
 *  Replace  update_locator_items   locatewin.c  64
 */
void gg_update_locator_items (int gno)
{
  if (locator_frame != NULL) {
    GLocator locator;
    char buf[32];
    
    if (get_graph_locator(gno ,&locator) != RETURN_SUCCESS) return;
    
    gg_set_int (fixedp_item ,locator.pointset);
    gg_set_int (delta_item  ,locator.pt_type);
    gg_set_int (loc_formatx ,locator.fx);
    gg_set_int (loc_formaty ,locator.fy);
    gg_set_int (loc_precx   ,locator.px);
    gg_set_int (loc_precy   ,locator.py);
    
    gg_setstr_d (locx_item ,"%g" ,locator.dsx ,buf);
    gg_setstr_d (locy_item ,"%g" ,locator.dsy ,buf);
    }
}

/**  Create the locator Panel
 *  Replace   create_locator_frame  locatewin.c  91
 */
void gg_create_locator_frame ()
{
  GtkWidget *rc ,*rc2 ,*locator_panel;

    
  if (locator_frame == NULL) {
    locator_frame = gg_CreateAACDialog ("Locator props" ,gg_locator_AAC_CB ,0 ,0
					,&locator_panel);
    delta_item = gg_combo_new (locator_panel ,"Locator display type:" ,7
			       ,"World (X,Y)"
			       ,"DX, DY"
			       ,"Distance"
			       ,"Phi, Rho"
			       ,"Viewport (X,Y)"
			       ,"Pixels (X,Y)");
	
    rc = gg_frame (locator_panel ,"X properties" ,&wheat ,0 ,1);
    loc_formatx = gg_format_new (rc ,"Format:");
    loc_precx   = gg_combo_new (rc ,"Precision:" ,11
					,"0" ,"1" ,"2" ,"3" ,"4"
					,"5" ,"6" ,"7" ,"8" ,"9");

    rc = gg_frame (locator_panel ,"Y properties" ,&wheat ,0 ,1);
    loc_formaty = gg_format_new (rc ,"Format:");
    loc_precy   = gg_combo_new (rc ,"Precision:" ,11
					,"0" ,"1" ,"2" ,"3" ,"4"
					,"5" ,"6" ,"7" ,"8" ,"9");

    rc = gg_frame (locator_panel ,"Fixed point" ,&bleuciel ,0 ,1);
    fixedp_item = gg_check_new (rc ,"Enable");
    rc2 = gg_CreateHContainer (rc);
    locx_item = gg_entry_new (rc2 ,"X:" ,10);
    locy_item = gg_entry_new(rc2 ,"Y:" ,10);
    }
    
    gg_update_locator_items (get_cg());
    gtk_widget_show_all (locator_frame);
    
    gg_unset_wait_cursor();
}

/**
 *  Replace locator_define_notify_proc  
 */
static void gg_locator_AAC_CB (GtkWidget *w ,gint reponse)
{
  GLocator locator;
  int gno;


  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_APPLY   ) {
    gno = get_cg();
    
    if (get_graph_locator (gno, &locator) != RETURN_SUCCESS) return;
    
    locator.pt_type  = gg_get_int (delta_item);
    locator.fx       = gg_get_int (loc_formatx);
    locator.fy       = gg_get_int (loc_formaty);
    locator.px       = gg_get_int (loc_precx);
    locator.py       = gg_get_int (loc_precy);
    locator.pointset = gg_get_int (fixedp_item);
    gg_evalexpr (locx_item, &locator.dsx ); 
    gg_evalexpr (locy_item, &locator.dsy ); 
    set_graph_locator (gno, &locator);
    gg_drawgraph();
  }
  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide (w);
  }

}
