/**  gg_miscwin.c  For the Edit/Preferences menu
 *  Transcripted from Motif to GTK+ by P. Vincent to
 *  Replace miscwin.c
 */

#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <gtk/gtk.h>

#include "globals.h"
#include "utils.h"
#include "noxprotos.h"

#include "gw_list.h"

#include "gg_gutil.h"
#include "gg_gtkinc.h"
#include "gg_protos.h"

static gint popup_width = 300 ,popup_height = 600;

extern GdkColor  bleuciel ,wheat;
extern int cursortype;

static GtkWidget *props_frame = NULL;
static GtkWidget *vb;

/************************************************************/
#ifdef DEBUG
static GtkWidget *w_debug;
#endif
static GtkWidget *w_noask               ,*w_dc;
static GtkWidget *w_graph_focus_choice  ,*w_graph_drawfocus_choice;
static GtkWidget *w_autoredraw_type     ,*w_cursor_type;
static GtkWidget *w_instant_update;
static GtkWidget *w_max_path            ,*w_safe_mode;
static GtkWidget *w_scrollper           ,*w_shexper;
static GtkWidget *w_linkscroll;
static GtkWidget *w_hint                ,*w_date;
static GtkWidget *w_two_digits_years    ,*w_wrap_year;
static GtkWidget *w_legend;
/************************************************************/

void gg_props_frame_AAC_CB (GtkWidget *w ,gint reponse);

void gg_create_props_frame (void)
{
  GtkWidget *rc ,*rc1; // ,*vb1 ,*rc2 ,*rc3 ,*hb ,*ta;

  gg_set_wait_cursor();

  if (props_frame == NULL) {
    props_frame = gg_CreateAACDialog ("Preferences" ,gg_props_frame_AAC_CB
				      ,popup_width ,popup_height
				      ,&vb);
    rc1 = gg_frame (vb ,"Responsiveness" ,&wheat ,0 ,1);
#ifdef DEBUG
    w_debug = gg_spin_new (rc1 ,"Debug level:" , 0.0, 8.0, 1.0);
#endif
    w_noask = gg_check_new (rc1, "Don't ask questions");
    w_dc    = gg_check_new (rc1, "Allow double clicks on canvas");
    w_graph_focus_choice = gg_combo_new (rc1 ,"Graph focus switch" ,4
						    ,"Button press"     /* FOCUS_CLICK */
						    ,"As set"           /* FOCUS_SET    */
						    ,"Follows mouse");  /* FOCUS_FOLLOWS */
    w_graph_drawfocus_choice = gg_check_new (rc1, "Display focus markers");
    w_autoredraw_type        = gg_check_new (rc1, "Auto redraw");
    w_instant_update         = gg_check_new (rc1, "Instantaneous update");
    w_cursor_type            = gg_check_new (rc1, "Crosshair cursor");
    w_legend                 = gg_check_new (rc1, "Set legend of sets created by data transform");

    rc1 = gg_frame (vb ,"Restrictions" ,&bleuciel ,0 ,1);
    w_max_path  = gg_spin_new  (rc1 ,"Max drawing path length:" ,0.0, 1.0e6, 1000);
    w_safe_mode = gg_check_new (rc1, "Run in safe mode");

    rc1 = gg_frame (vb ,"Scroll/zoom" ,&wheat ,0 ,1);
    w_scrollper  = gg_scale_new 	   (rc1 ,"Scroll %" ,0.0 ,200.0 ,20.0);
    w_shexper    = gg_scale_new 	   (rc1 ,"Zoom %"   ,0.0 ,200.0 ,20.0);
    w_linkscroll = gg_check_new (rc1 ,"Linked scrolling");
#if defined WITH_XMHTML || defined WITH_LIBHELP
    w_force_external_viewer =
      gg_check_new (rc1,"Use external help viewer for local documents");
#endif        

    rc1 = gg_frame (vb ,"Dates" ,&bleuciel ,0 ,1);
    w_hint 		  = gg_combo_new (rc1 ,"Date hint" ,5
				      ,"ISO" ,"European" ,"US" ,"None");
    w_date 		  = gg_entry_new   (rc1 ,"Reference date:" ,20);
    rc = gg_CreateHContainer(rc1);
    w_two_digits_years = gg_check_new (rc ,"Two-digit year span");
    w_wrap_year        = gg_entry_new   (rc ,"Wrap year:" ,4);
  }

  gtk_widget_show_all (props_frame);
  gg_update_props_items();

  gg_unset_wait_cursor ();
}

/**
 *  Replace props_define_notify_proc   miscwin.c  236
 */
void gg_props_frame_AAC_CB (GtkWidget *w ,gint reponse)
{
  double jul;

  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_APPLY   ) {
#ifdef DEBUG
    set_debuglevel (gg_get_int (w_debug));
#endif
    noask    	       = gg_get_int (w_noask);
    allow_dc 	       = gg_get_int (w_dc);
    focus_policy       = gg_get_int (w_graph_focus_choice);
    draw_focus_flag    = gg_get_int (w_graph_drawfocus_choice);

    scrolling_islinked = gg_get_int (w_linkscroll);
    auto_redraw	       = gg_get_int (w_autoredraw_type);
    instant_update     = gg_get_int (w_instant_update);
    cursortype         = gg_get_int (w_cursor_type);
    legend_for_new_set = gg_get_int (w_legend);
#if defined WITH_XMHTML || defined WITH_LIBHELP
    force_external_viewer = gg_get_int (w_force_external_viewer);
#endif
    set_max_path_limit ( gg_get_int   (w_max_path));
    safe_mode 	       = gg_get_int   (w_safe_mode);
    scrollper 	       = gg_get_dble  (w_scrollper) / 100.0;
    shexper   	       = gg_get_dble  (w_shexper)   / 100.0;

    switch (gg_get_int (w_hint)) {
    case 0 :
        set_date_hint (FMT_iso);
        break;
    case 1 :
        set_date_hint (FMT_european);
        break;
    case 2 :
        set_date_hint (FMT_us);
        break;
    default :
        set_date_hint (FMT_nohint);
        break;
    }
    if (parse_date_or_number (gg_getstr(w_date), TRUE, &jul)
        == RETURN_SUCCESS) {
        set_ref_date (jul);
    } else {
        errmsg("Invalid date");
    }
    allow_two_digits_years (gg_get_int (w_two_digits_years));
    set_wrap_year (atoi (gg_getstr (w_wrap_year)));

    gg_drawgraph();
    gg_unset_wait_cursor ();
  }

  if (reponse == GTK_RESPONSE_ACCEPT || reponse == GTK_RESPONSE_CLOSE) {
    gtk_widget_hide_all (props_frame);
  }
}


/**
 *  Replace update_props_items   miscwin.c  170
 */
void gg_update_props_items(void)
{
  int itest = 0;
  int iv;
  int y, m, d, h, mm, sec;
  char date_string[64], wrap_year_string[64];
    
  if (props_frame == NULL) return;
#ifdef DEBUG
  if (get_debuglevel () > 8) {
    gg_errwin("Debug level > 8, resetting to 0");
    set_debuglevel (0);
  }
  gg_set_int (w_debug, (double) get_debuglevel());
#endif
  gg_set_int (w_noask    ,noask);
  gg_set_int (w_dc       ,allow_dc);

  //	if (focus_policy == FOCUS_SET) {
  //	    itest = 1;
  //	} else if (focus_policy == FOCUS_CLICK) {
  //	    itest = 0;
  //	} else if (focus_policy == FOCUS_FOLLOWS) {
  //	    itest = 2;
  //	}
  gg_set_int  (w_graph_focus_choice  ,itest);
  gg_set_int  (w_graph_drawfocus_choice ,draw_focus_flag);
    
  gg_set_int  (w_linkscroll         ,scrolling_islinked);
  gg_set_int  (w_autoredraw_type    ,auto_redraw);
  gg_set_int  (w_instant_update     ,instant_update);
  gg_set_int  (w_cursor_type        ,cursortype);
  gg_set_int  (w_legend             ,legend_for_new_set);
#if defined WITH_XMHTML || defined WITH_LIBHELP
  gg_set_int  (w_force_external_viewer, force_external_viewer);
#endif

  gg_set_int  (w_max_path          ,(double) get_max_path_limit());
  gg_set_int  (w_safe_mode         ,safe_mode);
  iv = (int) rint(100*scrollper);
  gg_set_int  (w_scrollper ,iv);
  iv = (int) rint(100*shexper);
  gg_set_int  (w_shexper ,iv);
  switch (get_date_hint()) {
  case FMT_iso :
    itest = 0;
    break;
  case FMT_european :
    itest = 1;
    break;
  case FMT_us :
    itest = 2;
    break;
  default :
    itest = FMT_nohint;
    break;
  }
  gg_set_int      (w_hint        ,itest);
  jul_to_cal_and_time (0.0, ROUND_SECOND, &y, &m, &d, &h, &mm, &sec);
  sprintf        (date_string, "%d-%02d-%02d %02d:%02d:%02d",
		  y, m, d, h, mm, sec);
  gg_setstr       (w_date        ,date_string);
  gg_set_int      (w_two_digits_years   ,two_digits_years_allowed());
  sprintf         (wrap_year_string, "%04d", get_wrap_year());
  gg_setstr       (w_wrap_year, wrap_year_string);
  gg_SetSensitive (w_wrap_year ,two_digits_years_allowed() ? TRUE:FALSE);
}
