/** File gg_monwin.c
 *  Transcripted from Motif to GTK+ by P. Vincent to
 *  Replace monwin.c
 */

#include <string.h>
#include <gtk/gtk.h>

#include "graphs.h"
#include "utils.h"
#include "files.h"

#include "gw_list.h"

#include "gg_gutil.h"
#include "gg_gtkinc.h"
#include "gg_protos.h"

static gint popup_width = 450 ,popup_height = 150;

extern GdkDisplay *gg_disp;

typedef struct _gg_console_ui
{
  GtkWidget *mon_frame;
  GtkTextBuffer *monText;
  GtkWidget *wmon_frame;
  GtkWidget *wmon_text_item;
  int popup_only_on_errors;
  int action;
} gg_console_ui;

static gg_console_ui *ui = NULL;

void gg_console_save_CB (GtkWidget *w ,gpointer p)
{
  static GtkWidget *fpop;
  GtkTextIter start ,end;
  FILE *pp;
  char *filename ,*text;
  int len;

  fpop = gg_create_file_popup ("Grace : Save logs", "*.log"
			       ,popup_width ,popup_height
			       ,NULL
			       ,TRUE);
  while (gtk_dialog_run (GTK_DIALOG (fpop)) != GTK_RESPONSE_CANCEL) {
    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(fpop));
    pp = grace_openw (filename);
    if (pp == NULL) {
      errmsg ("Save logs: cannot open file");
      return;
    }
    gtk_text_buffer_get_bounds      (ui->monText ,&start ,&end);
    text = gtk_text_buffer_get_text (ui->monText ,&start ,&end ,FALSE);
    len = strlen (text);
    fwrite (text, SIZEOF_CHAR, len, pp);
    grace_close(pp); 
  }
  gtk_widget_destroy (fpop);
}
void gg_clear_results_CB (GtkWidget *w ,gpointer p)
{
  GtkTextIter start ,end;
  gtk_text_buffer_get_bounds (ui->monText ,&start ,&end);
  gtk_text_buffer_delete     (ui->monText ,&start ,&end);
}

/**
 *  Replace   popup_on    monwin.c   121
 */
static void gg_popup_on_CB  (GtkWidget *w ,gint action)
{
  ui->popup_only_on_errors = gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (w));
}

/**
 *  Replace   create_monitor_frame    monwin.c   65
 */
void gg_create_monitor_frame (int force, char *msg)
{

  if (ui == NULL) {
    GtkWidget *vb ,*menupane ,*menubar;

    ui = xmalloc (sizeof (gg_console_ui));

    ui->popup_only_on_errors = FALSE;

    ui->mon_frame = gtk_dialog_new();
    gtk_window_set_title (GTK_WINDOW(ui->mon_frame) ,"Console");
    gtk_widget_set_size_request (GTK_WIDGET(ui->mon_frame)
				 ,popup_width ,popup_height);
    vb = GTK_DIALOG (ui->mon_frame)->vbox;

 
    /* Menubar */
    menubar = gg_CreateMenuBar (vb);

    menupane = gg_CreateMenu (menubar, "File", 'F', FALSE);
    gg_CreateMenuButton (menupane, "Save...", 'S' ,NULL ,gg_console_save_CB ,-1);
    gg_CreateMenuCloseButton (menupane, ui->mon_frame);

    menupane = gg_CreateMenu (menubar, "Edit", 'E', FALSE);
    gg_CreateMenuButton (menupane ,"Clear" ,'C' ,NULL ,gg_clear_results_CB ,-1);

    menupane = gg_CreateMenu (menubar, "Options", 'O', FALSE);
    gg_CreateMenuToggle (menupane ,"Popup only on errors", 'e'  ,NULL ,gg_popup_on_CB ,FALSE);
 
    menupane = gg_CreateMenu (menubar, "Help", 'H', TRUE);
   // A COMPLETER

    ui->monText = gg_CreateScrollTextItem2 (vb ,popup_width ,3*popup_height
					    ,"Messages:");
    g_signal_connect (ui->mon_frame ,"delete-event" ,G_CALLBACK (gtk_widget_hide) ,NULL);
    force = FALSE;
  }
  if (msg != NULL) {
    gtk_text_buffer_insert_at_cursor (ui->monText ,msg ,-1);
  }
  if (force || ui->popup_only_on_errors == FALSE) {
    gtk_widget_show_all (ui->mon_frame);
    gdk_display_flush (gg_disp);
  }
}

/**
 *  Replace   stufftextwin    monwin.c   188
 */
void gg_stufftextwin (char *msg)
{
  gg_create_monitor_frame (FALSE, msg);
}

/**
 *  Replace   errwin    monwin.c   193
 */
void gg_errwin (const char *msg)
{
    char *buf;
    
    buf = copy_string (NULL, "[Error] ");
    buf = concat_strings (buf, msg);
    buf = concat_strings( buf, "\n");
    
    gg_create_monitor_frame (TRUE, buf);
    
    xfree(buf);
}


/**
 *  Replace    create_monitor_frame_cb   monwin.c   206
 */
void gg_create_monitor_frame_CB (GtkWidget w ,gpointer p)
{
    gg_create_monitor_frame (TRUE, NULL);
}

