#ifndef __GW_PANNEL_H__
#define __GW_PANNEL_H__


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkdialog.h>


G_BEGIN_DECLS

#define GW_PANNEL_TYPE            (gw_pannel_get_type ())
#define GW_PANNEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GW_PANNEL_TYPE, Gw_pannel))
#define GW_PANNEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GW_PANNEL_TYPE, Gw_pannelClass))
#define IS_GW_PANNEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GW_PANNEL_TYPE))
#define IS_GW_PANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GW_PANNEL_TYPE))


typedef struct _Gw_pannel       Gw_pannel;
typedef struct _Gw_pannelClass  Gw_pannelClass;

struct _Gw_pannel
{
  GtkDialog dialog;
  
  GtkWidget *table;
  GtkWidget **buttons;
  GdkColor  **bg;
  gboolean  row_first;          /* TRUE: n++ <=> y++ (the default);  FALSE : n++ <=> x++ */
  gboolean  with_num;           /* T: the number "n" is printed in the button */

  /* GTK bug 437281 (corrected in new versions of GTK) implies
   * to recreate bitmap image before each gtk_button_set_image,
   * thus to store bitmap with, height and mask
   */
  char      **bitmaps;          /* pointer to bitmaps arrays */
  gint      *width ,*height;    /* size_vary=F: only the first element of arrays is allocated and used */
  GdkBitmap **mask;             /* idem */
  gboolean  size_vary;          /* T: the width and height of bitmaps are functions of "n" */
  gboolean  hide_on_click;      /* default is TRUE */
  
  /* Auxilliary variables */
  GdkDrawable *win;     /* To solve pb with gdk_pixmap_create_from_data */
  gint      depth;      /* of the pixmap */
  /* Il semble que  gtk_dialog_attach_defaults met nrows=ncols = max (nrows,ncols)
   * donc je rajoute nlignes, ncolons et nrc.  
   */
  gint  nlignes;    /* number of rows     in the pannel */
  gint  ncolons;    /* number of columns  in the pannel */
  gint  nrc;        /* number of places   in the pannel */
  gint  last;       /* last element initialized in the pannel */
  gint  x_clicked;  /* col index */
  gint  y_clicked;  /* row index */
  GdkColor *fg;
  gint active;
};

struct _Gw_pannelClass
{
  GtkDialogClass parent_class;

  void (* gw_pannel) (Gw_pannel *ttt);
};

GType       gw_pannel_get_type (void);

GtkWidget*  gw_pannel_new 	  	    (char *title ,guint nrows ,guint ncols ,GdkDrawable *win);

void        gw_pannel_set_bitmaps_defaults  (Gw_pannel *ttt ,gint depth ,gboolean size_vary);


void        gw_pannel_attach_color_button   (Gw_pannel *ttt ,GtkWidget *button
					     ,GdkColor *bg ,char *name
					     ,gint nx ,gint ny);
void 	    gw_pannel_update_color_button   (Gw_pannel *ttt ,gint n ,GdkColor *bg ,char *name);

void        gw_pannel_bitmap_button_set     (Gw_pannel *ttt ,GtkWidget *button ,gint n);

void        gw_pannel_bitmap_button_attach  (Gw_pannel *ttt ,GtkWidget *button ,gint n
					     ,unsigned char *bitmap ,gint width ,gint height);

gint        gw_pannel_xy_to_n               (Gw_pannel *ttt ,gint x ,gint y);

void        gw_pannel_n_to_xy               (Gw_pannel *ttt ,gint n ,gint *x ,gint *y);

void        gw_pannel_numbering             (Gw_pannel *ttt ,gboolean with_num);
void        gw_pannel_set_row_first         (Gw_pannel *ttt ,gboolean row_first);
void        gw_pannel_hide_on_click         (Gw_pannel *ttt ,gboolean hide_on_click);
void 	    gw_pannel_resize 		    (Gw_pannel *ttt ,guint nrows ,guint ncols);
GtkWidget*  gw_pannel_button_get 	    (Gw_pannel *ttt ,guint n);

G_END_DECLS

#endif /* __GW_PANNEL_H__ */

