/**
 *  File nn_cmd_axis.c for printing axis related commands
 *  Called by ge_axis_apply in ge_axis.c
 *  Models for format in params.c
 *   Copyright (c) 2010 P. Vincent.    See GNU GPL ../LICENCE
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "globals.h"
#include "defines.h"
#include "utils.h"
#include "graphutils.h"
#include "t1fonts.h"
#include "ng_objects.h"
#include "nn_cmd.h"

/* c: function to call, v: variable, f: format */
#define NCB(c,v,f) c(&(oobj->v) ,objs[num].v ,f)
#define NCO(c,v,f) c(&(old->v)  ,t->v ,f)
#define NCO2(c,v1,v2,f) c(&(old->v1)  ,&(old->v2) ,t->v1 ,t->v2 ,f)

extern void gg_cmd_prt (char *buf);
extern int  gg_strcmp  (char *s1 ,const char *s2);
extern void nn_cmd_prt (char *buf);
/**
 * Print commands reflecting axis parameters
 *  See  params.c 235
 *  Can also change the "world" params for xg1 and xg2  (A FAIRE)
 */
void nn_cmd_axis (int gno ,int axisno ,tickmarks *old ,world *w_old ,QDobject *oobj 
		  ,int all ,int undo_on)
{
  tickmarks *t;
  int num ,j;
  char buf[1028] ,prefix[20] , tmpstr1[64];
  world w;
 
  nn_cmd_undo_on (undo_on);
  nn_cmd_undo_start(TRUE ,gno);

  sprintf (buf ,"@ with g%1d\n" ,gno);
  gg_cmd_prt (buf);

  t   = get_graph_tickmarks (gno ,axisno);
  num = obj_tid_get_num (Q_Axis ,axisno ,Q_Graph ,gno);
  sprintf (prefix ,"@    %s " ,axis_name[axisno]);
  nn_cmd_all (all);
  nn_cmd_prefix (prefix);

  if (undo_on) {
    NCO (nn_cmd_on_off    ,active 	,"%s %s\n");
  } else {
    if (axisno > Y_AXIS) {
      sprintf (buf ,"%s %s\n" ,prefix ,on_or_off (t->active));
      nn_cmd_prt (buf);
      if (t->active == FALSE) return;
    }
  }
  NCB (nn_cmd_i         ,layer          ,"%s layer %d\n");
  NCO (nn_cmd_t_f       ,zero   	,"%s type zero %s\n");
  NCO2 (nn_cmd_2d       ,offsx ,offsy 	,"%s offset %f , %f\n");
  NCO (nn_cmd_on_off    ,t_drawbar      ,"%s bar %s\n");
  NCO (nn_cmd_i         ,t_drawbarcolor ,"%s bar color %d\n");
  NCO (nn_cmd_i         ,t_drawbarlines ,"%s bar linestyle %d\n");
  NCO (nn_cmd_d         ,t_drawbarlinew ,"%s bar linewidth %.1f\n");
  /* label */
  NCO (nn_cmd_str       ,label.s        ,"%s label \"%s\"\n");
  NCO (nn_cmd_para_perp ,label_layout 	,"%s label layout %s\n");
  NCO (nn_cmd_auto_spec ,label_place 	,"%s label place %s\n");
  if (t->label_place == TYPE_SPEC) {
    NCO2 (nn_cmd_2d ,label.x1 ,label.y1 ,"%s label place %f, %f\n");
  }
  NCO (nn_cmd_d        ,label.charsize	,"%s label char size %f\n");
  NCO (nn_cmd_i        ,label.font    	,"%s label font %d\n");
  NCO (nn_cmd_i        ,label.color   	,"%s label color %d\n");
  NCO (nn_cmd_placemnt ,label_op      	,"%s label place %s\n");
  /* ticks */
  NCO (nn_cmd_on_off   ,t_flag        	,"%s tick %s\n");
  NCO (nn_cmd_d        ,tmajor        	,"%s tick major %.12g\n");
  NCO (nn_cmd_i        ,nminor        	,"%s tick minor ticks %d\n");
  NCO (nn_cmd_i        ,t_autonum     	,"%s tick default %d\n");
  NCO (nn_cmd_t_f      ,t_round       	,"%s tick place rounded %s\n");
  NCO (nn_cmd_in_out   ,t_inout       	,"%s tick %s\n");
  /* ticks major */
  NCO (nn_cmd_d        ,props.size     	,"%s tick major size %f\n");
  NCO (nn_cmd_i        ,props.color    	,"%s tick major color %d\n");
  NCO (nn_cmd_d        ,props.linew    	,"%s tick major linewidth %.1f\n");
  NCO (nn_cmd_i        ,props.lines    	,"%s tick major linestyle %d\n");
  NCO (nn_cmd_on_off   ,props.gridflag 	,"%s tick major grid %s\n");
  /* ticks minor */
  NCO (nn_cmd_i        ,mprops.color    ,"%s tick minor color %d\n");
  NCO (nn_cmd_d        ,mprops.linew    ,"%s tick minor linewidth %.1f\n");
  NCO (nn_cmd_i        ,mprops.lines    ,"%s tick minor linestyle %d\n");
  NCO (nn_cmd_on_off   ,mprops.gridflag ,"%s tick minor grid %s\n");
  NCO (nn_cmd_d        ,mprops.size     ,"%s tick minor size %f\n");
  /* ticks label */
  NCO (nn_cmd_on_off    ,tl_flag         ,"%s ticklabel %s\n");
  NCO (nn_cmd_fmt       ,tl_format       ,"%s ticklabel format %s\n");
  NCO (nn_cmd_i         ,tl_prec         ,"%s ticklabel prec %d\n");
  NCO (nn_cmd_str       ,tl_formula      ,"%s ticklabel formula \"%s\"\n");
  nn_cmd_strn (64 ,old->tl_appstr ,t->tl_appstr ,"%s ticklabel append \"%s\"\n");
  nn_cmd_strn (64 ,old->tl_prestr ,t->tl_prestr ,"%s ticklabel prepend \"%s\"\n");
  NCO (nn_cmd_i         ,tl_angle        ,"%s ticklabel angle %d\n");
  NCO (nn_cmd_i         ,tl_skip         ,"%s ticklabel skip %d\n");
  NCO (nn_cmd_i         ,tl_staggered    ,"%s ticklabel stagger %d\n");
  NCO (nn_cmd_placemnt  ,tl_op           ,"%s ticklabel place %s\n");
  NCO (nn_cmd_auto_spec ,tl_gaptype      ,"%s ticklabel offset %s\n");
  NCO2 (nn_cmd_2d       ,tl_gap.x ,tl_gap.y ,"%s ticklabel offset %f , %f\n");
  NCO (nn_cmd_auto_spec ,tl_starttype    ,"%s ticklabel start type %s\n");
  NCO (nn_cmd_d         ,tl_start        ,"%s ticklabel start %f\n");
  NCO (nn_cmd_auto_spec ,tl_stoptype     ,"%s ticklabel stop type %s\n");
  NCO (nn_cmd_d         ,tl_stop         ,"%s ticklabel stop %f\n");
  NCO (nn_cmd_d         ,tl_charsize     ,"%s ticklabel char size %f\n");
  NCO (nn_cmd_font      ,tl_font         ,"%s ticklabel font %d\n");
  NCO (nn_cmd_i         ,tl_color        ,"%s ticklabel color %d\n");
  /* Special ticks */
  NCO (nn_cmd_placemnt  ,t_op            ,"%s tick place %s\n");
  NCO (nn_cmd_tick_spec ,t_spec          ,"%s tick spec type %s\n");
  

  if (t->t_spec != TICKS_SPEC_NONE) {
    /* No differential print for special ticks because interpreter 
       lacks a command to set only one tick */
    sprintf (buf ,"%s tick spec %d\n" ,prefix ,t->nticks);
    nn_cmd_prt (buf);
    for (j = 0; j < t->nticks; j++) {
      sprintf(tmpstr1 ,sformat ,t->tloc[j].wtpos);
      nn_cmd_prt (buf);
      if (t->tloc[j].type == TICK_TYPE_MAJOR) {
	sprintf (buf ,"%s tick major %d ,%s\n" ,prefix ,j ,tmpstr1);
	nn_cmd_prt (buf);
	if (t->t_spec == TICKS_SPEC_BOTH) {
	  sprintf (buf ,"%s ticklabel %d ,\"%s\"\n" ,prefix ,j ,PSTRING(t->tloc[j].label));
	  nn_cmd_prt (buf);
	}
      } else {
	sprintf (buf ,"%s tick minor %d ,%s\n" ,prefix ,j ,tmpstr1);
	nn_cmd_prt (buf);
      }
    }
  }

  if (undo_on) {
   get_graph_world (gno ,&w);
   nn_cmd_prefix ("@   ");
   nn_cmd_world (w_old ,w ,"%s    world %.12g, %.12g, %.12g, %.12g\n");
  }
  /* undo/redo */
  if (undo_on) nn_cmd_undo_end (TRUE ,gno);
}
