/** File "zcP.h"  
 *
 */
#ifndef __ZCP_H_
#define __ZCP_H_

/* The color names and RGB values are borrowed to Scilab-5.3
 * using  6 colors  as a base, except for cmap_frgb_grey and cmap_frgb_rainbow
 *  http://www.scilab.org/
 */


static fRGB cmap_frgb_jet[] = {
  {   0.0 ,   0.0 , 0.83 }
 ,{   0.0 ,   0.5 , 1.0  }
 ,{   0.16,   1.0 , 0.83 }
 ,{   0.83,   1.0 , 0.16 }
 ,{   1.00,   0.5 , 0.0  }
 ,{   0.83,   0.0 , 0.0  }
}; 

static fRGB cmap_frgb_hot[] = {
 {    0.5 ,   0.0 , 0.0  }
,{   1.   ,  0.   , 0.   }
,{   1.   ,  0.5  , 0.   }
,{   1.   ,  1.   , 0.   }
,{   1.   ,  1.   , 0.5  }
,{   1.   ,  1.   , 1.   }
}; 

static fRGB cmap_frgb_grey[] = {
  {   0.0 ,   0.0 , 0.0 }
  ,{   1.   ,  1.   , 1.   }
}; 

static fRGB cmap_frgb_winter[] = {
   {  0. ,   0.   ,  1.   }
  ,{  0. ,   0.2  ,  0.9  }
  ,{  0. ,   0.4  ,  0.8  }
  ,{  0. ,   0.6  ,  0.7  }
  ,{  0. ,   0.8  ,  0.6  }
  ,{  0. ,   1.   ,  0.5  }
};

static fRGB cmap_frgb_spring[] = {
   {  1. ,   0.  ,   1.  }
  ,{  1. ,   0.2 ,   0.8 }
  ,{  1. ,   0.4 ,   0.6 }
  ,{  1. ,   0.6 ,   0.4 }
  ,{  1. ,   0.8 ,   0.2 }
  ,{  1. ,   1.  ,   0.  }
};

static fRGB cmap_frgb_summer[] = {
   {  0.   ,  0.5  ,  0.4  }
  ,{  0.2  ,  0.6  ,  0.4  }
  ,{  0.4  ,  0.7  ,  0.4  }
  ,{  0.6  ,  0.8  ,  0.4  }
  ,{  0.8  ,  0.9  ,  0.4  }
  ,{  1.   ,  1.   ,  0.4  }
};

static fRGB cmap_frgb_autumn[] = {
   {  1. ,  0.  ,   0.  }
  ,{  1. ,  0.2 ,   0.  }
  ,{  1. ,  0.4 ,   0.  }
  ,{  1. ,  0.6 ,   0.  }
  ,{  1. ,  0.8 ,   0.  }
  ,{  1. ,  1.  ,   0.  }
};

static fRGB cmap_frgb_rainbow[] = {
   { 1.    ,  0.25  ,  0.   } 
  ,{ 1.    ,  0.75  ,  0.   } 
  ,{ 0.75  ,  1.    ,  0.   } 
  ,{ 0.25  ,  1.    ,  0.   } 
  ,{ 0.    ,  1.    ,  0.25 } 
  ,{ 0.    ,  1.    ,  0.75 } 
  ,{ 0.    ,  0.75  ,  1.   } 
  ,{ 0.    ,  0.25  ,  1.   } 
  ,{ 0.25  ,  0.    ,  1.   } 
  ,{ 0.75  ,  0.    ,  1.   }  
};

static fRGB cmap_frgb_bone[] = {  
    {  0.     ,  0.     ,  0.0625    }
   ,{  0.175  ,  0.175  ,  0.3       }
   ,{  0.35   ,  0.4125 ,  0.475     }
   ,{  0.525  ,  0.65   ,  0.65      }
   ,{  0.7625 ,  0.825  ,  0.825     }
   ,{  1.     ,  1.     ,  1.        }
};

static fRGB cmap_frgb_copper[] = {  
    { 0.   ,  0.   ,   0.   }
   ,{ 0.25 ,  0.16 ,   0.1  }
   ,{ 0.5  ,  0.32 ,   0.2  }
   ,{ 0.75 ,  0.48 ,   0.3  }
   ,{ 1.   ,  0.64 ,   0.4  }
   ,{ 1.   ,  0.8  ,   0.5  }
};

static fRGB cmap_frgb_ocean[] = {  
    {  0.    ,  0.     ,  0.0833333    }
   ,{  0.    ,  0.     ,  0.25         }
   ,{  0.    ,  0.125  ,  0.4166667    }
   ,{  0.    ,  0.375  ,  0.5833333    }
   ,{  0.25  ,  0.625  ,  0.75         }
   ,{  0.75  ,  0.875  ,  0.9166667    }
};

static fRGB cmap_frgb_white[] = {
  {   1.   ,  1.   , 1. }
  ,{  1.   ,  1.   , 1.   }
}; 

static ZCmap zcmap_predef[] = {
  { CmapGraceGTK  ,"GraceGTK cmap"    ,-1  ,NULL }
  ,{ CmapJet  	  ,"Jet colormap"      ,6  ,cmap_frgb_jet }
  ,{ CmapHot  	  ,"Hot colormap"      ,6  ,cmap_frgb_hot }
  ,{ CmapGrey 	  ,"Grey colormap"     ,2  ,cmap_frgb_grey }
  ,{ CmapWinter   ,"Winter colormap"   ,6  ,cmap_frgb_winter }
  ,{ CmapSpring   ,"Spring colormap"   ,6  ,cmap_frgb_spring }
  ,{ CmapSummer   ,"Summer colormap"   ,6  ,cmap_frgb_summer }
  ,{ CmapAutumn   ,"Autumn colormap"   ,6  ,cmap_frgb_autumn }
  ,{ CmapRainbow  ,"Rainbow colormap"  ,10 ,cmap_frgb_rainbow }
  ,{ CmapBone     ,"Bone colormap"     ,6  ,cmap_frgb_bone }
  ,{ CmapCopper   ,"Copper colormap"   ,6  ,cmap_frgb_copper }
  ,{ CmapOcean    ,"Ocean colormap"    ,6  ,cmap_frgb_ocean }
  ,{ CmapWhite 	  ,"White colormap"    ,2  ,cmap_frgb_white }
};


#endif /*__ZCP_H_  */
