export const province: string[] = [
  '北京市',
  '天津市',
  '上海市',
  '重庆市',
  '河北省',
  '山西省',
  '辽宁省',
  '吉林省',
  '黑龙江省',
  '江苏省',
  '浙江省',
  '安徽省',
  '福建省',
  '江西省',
  '山东省',
  '河南省',
  '湖北省',
  '湖南省',
  '广东省',
  '海南省',
  '四川省',
  '贵州省',
  '云南省',
  '陕西省',
  '甘肃省',
  '青海省',
  '台湾省',
  '内蒙古自治区',
  '广西壮族自治区',
  '西藏自治区',
  '宁夏回族自治区',
  '新疆维吾尔自治区',
  '香港特别行政区',
  '澳门',
  '台湾',
];
const provinceSchema = province.reduce((acc, curr) => {
  return {
    ...acc,
    [curr]: { enumValueCode: curr, enumValueName: curr },
  };
}, {});
export const nodePropertiesSchema = [
  {
    type: 'company',
    typeName: '公司',
    propertySchemaList: [
      {
        code: 'name',
        name: 'name',
        dataType: 'STRING',
        desc: '公司名称',
        enumValueSchemaMap: null,
      },
      {
        code: 'companyType',
        name: 'companyType',
        dataType: 'ENUM',
        desc: '类型',
        enumValueSchemaMap: {
          OTHER: { enumValueCode: 'OTHER', enumValueName: '其他(非上市)' },
          Listed: { enumValueCode: 'Listed', enumValueName: '上市公司' },
        },
      },
      {
        code: 'industry',
        name: 'industry',
        dataType: 'STRING',
        desc: '行业',
        enumValueSchemaMap: null,
      },
      {
        code: 'phone',
        name: 'phone',
        desc: '电话',
        dataType: 'STRING',
        enumValueSchemaMap: null,
      },
      {
        code: 'USCC',
        name: 'USCC',
        desc: '统一社会信用代码',
        dataType: 'NUMBER',
        enumValueSchemaMap: null,
      },
      {
        code: 'registered capital',
        name: 'registered capital',
        desc: '注册资本',
        dataType: 'NUMBER',
        enumValueSchemaMap: null,
      },
      {
        code: 'number of participants',
        name: 'number of participants',
        dataType: 'NUMBER',
        desc: '参保人数',
        enumValueSchemaMap: null,
      },
      {
        code: 'register prov',
        name: 'register prov',
        dataType: 'ENUM',
        desc: '注册省份',
        enumValueSchemaMap: provinceSchema,
        // {
        //     福建省: { enumValueCode: '福建省', enumValueName: '福建省' },
        //     西藏自治区: { enumValueCode: '西藏自治区', enumValueName: '西藏自治区' },
        //     贵州省: { enumValueCode: '贵州省', enumValueName: '贵州省' },
        //     湖北省: { enumValueCode: '湖北省', enumValueName: '湖北省' },
        //     湖南省: { enumValueCode: '湖南省', enumValueName: '湖南省' },
        //     广东省: { enumValueCode: '广东省', enumValueName: '广东省' },
        //     重庆: { enumValueCode: '重庆', enumValueName: '重庆市' },
        //     澳门特别行政区: { enumValueCode: '澳门特别行政区', enumValueName: '澳门特别行政区' },
        //     香港特别行政区: { enumValueCode: '香港特别行政区', enumValueName: '香港特别行政区' },
        //     四川省: { enumValueCode: '四川省', enumValueName: '四川省' },
        //     安徽省: { enumValueCode: '安徽省', enumValueName: '安徽省' },
        //     新疆维吾尔自治区: {
        //         enumValueCode: '新疆维吾尔自治区',
        //         enumValueName: '新疆维吾尔自治区',
        //     },
        //     江苏省: { enumValueCode: '江苏省', enumValueName: '江苏省' },
        //     天津: { enumValueCode: '天津', enumValueName: '天津市' },
        //     吉林省: { enumValueCode: '吉林省', enumValueName: '吉林省' },
        //     宁夏回族自治区: { enumValueCode: '宁夏回族自治区', enumValueName: '宁夏回族自治区' },
        //     河南省: { enumValueCode: '河南省', enumValueName: '河南省' },
        //     河北省: { enumValueCode: '河北省', enumValueName: '河北省' },
        //     广西壮族自治区: { enumValueCode: '广西壮族自治区', enumValueName: '广西壮族自治区' },
        //     上海: { enumValueCode: '上海', enumValueName: '上海市' },
        //     海南省: { enumValueCode: '海南省', enumValueName: '海南省' },
        //     江西省: { enumValueCode: '江西省', enumValueName: '江西省' },
        //     云南省: { enumValueCode: '云南省', enumValueName: '云南省' },
        //     甘肃省: { enumValueCode: '甘肃省', enumValueName: '甘肃省' },
        //     山东省: { enumValueCode: '山东省', enumValueName: '山东省' },
        //     陕西省: { enumValueCode: '陕西省', enumValueName: '陕西省' },
        //     浙江省: { enumValueCode: '浙江省', enumValueName: '浙江省' },
        //     未知: { enumValueCode: '未知', enumValueName: '未知' },
        //     内蒙古自治区: { enumValueCode: '内蒙古自治区', enumValueName: '内蒙古自治区' },
        //     青海省: { enumValueCode: '青海省', enumValueName: '青海省' },
        //     辽宁省: { enumValueCode: '辽宁省', enumValueName: '辽宁省' },
        //     黑龙江省: { enumValueCode: '黑龙江省', enumValueName: '黑龙江省' },
        //     北京: { enumValueCode: '北京', enumValueName: '北京市' },
        //     山西省: { enumValueCode: '山西省', enumValueName: '山西省' },
        // },
      },
    ],
  },
];
