PrefabFiles = {
"lightsaber",
"crystal",
}

Assets = 
{
Asset("ATLAS", "images/inventoryimages/lightsaber_icon.xml"),
Asset("IMAGE", "images/inventoryimages/lightsaber_icon.tex"),
}

local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local TECH = GLOBAL.TECH
local TUNING = GLOBAL.TUNING
local difficulty = GetModConfigData("LSdifficulty")
local total_day = 480
local Chop = GLOBAL.ACTIONS.CHOP.fn
GLOBAL.FUELTYPE.ELECTRIC = "ELECTRIC"
GLOBAL.Ability = GetModConfigData("LSability")=="yes"
TUNING.LIGHTSABER =
{
	LEECHES_HEALTH = 7,
	SPEED_MULT = 1.25,
	DAMAGE = {
		EASY = 34,
		NORMAL = 28,
	},
	ELECTRICITY = {
		FUEL = {
			EASY = total_day * 2,
			NORMAL = total_day * 1,
		},
		PERISH = {
			EASY = total_day * 20,
			NORMAL = total_day * 10,
		},
	},
	DIAMONDVALUES = {
		RED = 5,
		BLUE = 5,
		GREEN = 6,
		YELLOW = 6,
		WHITE = 10,
		PURPLE = 7,
	},
}
local function updaterecipe()
	if difficulty == "easy" then
		electricvalue = TUNING.LIGHTSABER.ELECTRICITY.FUEL.EASY
		TUNING.LIGHTSABER_DAMAGE = TUNING.LIGHTSABER.DAMAGE.EASY
		TUNING.LIGHTSABER_PERISHTIME = TUNING.LIGHTSABER.ELECTRICITY.PERISH.EASY
		diamondloot = 2
	else
		electricvalue = TUNING.LIGHTSABER.ELECTRICITY.FUEL.NORMAL
		TUNING.LIGHTSABER_DAMAGE = TUNING.LIGHTSABER.DAMAGE.NORMAL
		TUNING.LIGHTSABER_PERISHTIME = TUNING.LIGHTSABER.ELECTRICITY.PERISH.NORMAL
	end
end
updaterecipe()

STRINGS.NAMES.REDSABER = "Redsaber"
STRINGS.RECIPE_DESC.REDSABER = "Ignites target"

STRINGS.NAMES.BLUESABER = "Bluesaber"
STRINGS.RECIPE_DESC.BLUESABER = "Freezes target"

STRINGS.NAMES.GREENSABER = "Greensaber"
STRINGS.RECIPE_DESC.GREENSABER = "Chop tree faster"

STRINGS.NAMES.YELLOWSABER = "Yellowsaber"
STRINGS.RECIPE_DESC.YELLOWSABER = "Regen HP"

STRINGS.NAMES.WHITESABER = "Whitesaber"
STRINGS.RECIPE_DESC.WHITESABER = "Spawn lightning to large creature"

STRINGS.NAMES.RINGSABER = "Ringsaber"
STRINGS.RECIPE_DESC.RINGSABER = "Short range teleportation"

STRINGS.NAMES.SWORDSABER = "Swordsaber"
STRINGS.RECIPE_DESC.SWORDSABER = "Deals more damage to monster creature"

STRINGS.NAMES.PURPLESABER = "Purplesaber"
STRINGS.RECIPE_DESC.PURPLESABER = "Leeches target's health"

STRINGS.NAMES.DARKSABER = "Darksaber"
STRINGS.RECIPE_DESC.DARKSABER = "Deals more damage when dusk and night"

STRINGS.NAMES.PURPLECRYSTAL = "Purple Crystal"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.PURPLECRYSTAL = "I believe it came from universe"

STRINGS.NAMES.GREENCRYSTAL = "Green Crystal"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GREENCRYSTAL = "Green and Peace"

STRINGS.NAMES.YELLOWCRYSTAL = "Yellow Crystal"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.YELLOWCRYSTAL = "A shiny crystal"

STRINGS.NAMES.REDCRYSTAL = "Red Crystal"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.REDCRYSTAL = "Warm and natural"

STRINGS.NAMES.BLACKCRYSTAL = "Black Crystal"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLACKCRYSTAL = "A Sorcerer's Stone"

STRINGS.NAMES.WHITECRYSTAL = "White Crystal"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WHITECRYSTAL = "Vahalla stone"

STRINGS.NAMES.BLUECRYSTAL = "Blue Crystal"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLUECRYSTAL = "It's a stone cool"

STRINGS.TABS.SABER = "Saber"
RECIPETABS['SABER'] = {str = "SABER", sort=5, icon = "lightsaber_icon.tex", icon_atlas = "images/inventoryimages/lightsaber_icon.xml"}

AddPrefabPostInit("transistor", function(inst) if not inst.components.fuel then inst:AddComponent("fuel") end inst.components.fuel.fuelvalue = electricvalue inst.components.fuel.fueltype = "ELECTRIC" end)
AddRecipe ( "whitecrystal", { Ingredient("redcrystal", 1, "images/inventoryimages/crystal/redcrystal.xml"), Ingredient("greencrystal", 1, "images/inventoryimages/crystal/greencrystal.xml"), Ingredient("bluecrystal", 1, "images/inventoryimages/crystal/bluecrystal.xml")}, RECIPETABS.REFINE, TECH.MAGIC_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/crystal/whitecrystal.xml", "whitecrystal.tex")
AddRecipe ( "blackcrystal", { Ingredient("whitecrystal", 1, "images/inventoryimages/crystal/whitecrystal.xml"), Ingredient("nightmarefuel", 1)}, RECIPETABS.REFINE, TECH.MAGIC_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/crystal/blackcrystal.xml", "blackcrystal.tex")
STRINGS.RECIPE_DESC.WHITECRYSTAL = "Holy crystal"
STRINGS.RECIPE_DESC.BLACKCRYSTAL = "A crystal with full black magic"

local function LScolour(colour)
	local warnasaber = colour.."saber"
	local imgr = "images/inventoryimages/crystal/"..colour.."crystal.xml"
	if colour == "green" then berlian = colour.."crystal"
	elseif colour == "purple" then berlian = colour.."crystal"
	elseif colour == "yellow" then berlian = colour.."crystal"
	elseif colour == "blue" then berlian = colour.."crystal"
	elseif colour == "white" then berlian = colour.."crystal"
	elseif colour == "dark" then berlian = "blackcrystal" imgr = "images/inventoryimages/crystal/blackcrystal.xml"
	elseif colour == "red" or "sword" or "ring" then berlian = "redcrystal" imgr = "images/inventoryimages/crystal/redcrystal.xml"
	end
Recipe( warnasaber, { Ingredient(berlian, 3, imgr), Ingredient("transistor", 5), Ingredient("nitre", 5)}, RECIPETABS.SABER, TECH.SCIENCE_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/lightsaber/"..warnasaber..".xml", warnasaber..".tex")

AddSimPostInit(function()
local _LT = GLOBAL.LootTables
local pt = diamondloot or 1
	if colour == "red" then
		table.insert(_LT['rock1'], {colour.."crystal", 0.02*pt})
		table.insert(_LT['rock2'], {colour.."crystal", 0.08*pt})
		table.insert(_LT['rock_flintless'], {colour.."crystal", 0.02*pt})
	elseif colour == "blue" then
		table.insert(_LT['rock1'], {colour.."crystal", 0.08*pt})
		table.insert(_LT['rock2'], {colour.."crystal", 0.02*pt})
		table.insert(_LT['rock_petrified_tree'], {colour.."crystal", 0.08*pt})
		table.insert(_LT['rock_petrified_tree_tall'], {colour.."crystal", 0.08*pt})
	elseif colour == "green" then
		table.insert(_LT['rock1'], {colour.."crystal", 0.05*pt})
		table.insert(_LT['rock_petrified_tree'], {colour.."crystal", 0.05*pt})
		table.insert(_LT['rock_petrified_tree_tall'], {colour.."crystal", 0.05*pt})
		table.insert(_LT['rock_flintless'], {colour.."crystal", 0.05*pt})
		table.insert(_LT['rock_moon'], {colour.."crystal", 0.20*pt})
	elseif colour == "yellow" then
		table.insert(_LT['rock_flintless'], {colour.."crystal", 0.05*pt})
		table.insert(_LT['rock_moon'], {colour.."crystal", 0.20*pt})
		table.insert(_LT['stalagmite_tall_full_rock'], {colour.."crystal", 0.08*pt})
		table.insert(_LT['rock2'], {colour.."crystal", 0.05*pt})
	elseif colour == "purple" then
		table.insert(_LT['rock_moon'], {colour.."crystal", 0.20*pt})
		table.insert(_LT['full_rock'], {colour.."crystal", 0.05*pt})
		table.insert(_LT['stalagmite_tall_full_rock'], {colour.."crystal", 0.05*pt})
		table.insert(_LT['rock_flintless'], {colour.."crystal", 0.08*pt})
	end
end)
end

GLOBAL.ACTIONS.CHOP.fn = function(act)
	if act.invobject and act.invobject.components.tool then
		if act.invobject:HasTag("greensaber") then
			act.invobject:PushEvent("ontool")
		end
	end
	return Chop(act)
end

return  LScolour("green"), LScolour("red"), LScolour("yellow"), LScolour("ring"), LScolour("white"), LScolour("sword"), LScolour("blue"), LScolour("purple"), LScolour("dark")