local function diamond(colour)
local crystalgem = colour.."crystal"
local assets =
{
Asset("ANIM", "anim/crystal.zip"),
Asset("ATLAS", "images/inventoryimages/crystal/"..crystalgem..".xml"),
Asset("IMAGE", "images/inventoryimages/crystal/"..crystalgem..".tex"),
}

local function old_onhaunt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/resurrectionstone_activate")
    inst:Remove()
    return true
end

local function DoEffects(inst)
    local x, y, z = inst.Transform:GetWorldPosition()
    SpawnPrefab("shadow_despawn").Transform:SetPosition(x, y, z)
end

local function OnblackDropped(inst)
    if inst.shadow == nil then
		inst.shadow = inst:DoTaskInTime(1.5, DoEffects)
	end
end

local function OnblackPickup(inst)
	if inst.shadow ~= nil then
		inst.shadow:Cancel()
		inst.shadow = nil
	end
end

local function BaseCrystal(inst)
	local light = inst.entity:AddLight()
	light:SetFalloff(0.7)
	light:SetIntensity(.5)
	light:SetRadius(0.3)
	light:Enable(true)
	if not TheWorld.ismastersim then
		return inst
    end
	inst:AddComponent("tradable")
	if colour == "red" then
		inst.components.tradable.goldvalue = TUNING.LIGHTSABER.DIAMONDVALUES.RED
	elseif colour == "blue" then
		inst.components.tradable.goldvalue = TUNING.LIGHTSABER.DIAMONDVALUES.BLUE
	elseif colour == "yellow" then
		inst.components.tradable.goldvalue = TUNING.LIGHTSABER.DIAMONDVALUES.YELLOW
	elseif colour == "green" then
		inst.components.tradable.goldvalue = TUNING.LIGHTSABER.DIAMONDVALUES.GREEN
	elseif colour == "white" then
		inst.components.tradable.goldvalue = TUNING.LIGHTSABER.DIAMONDVALUES.WHITE
	elseif colour == "purple" then
		inst.components.tradable.goldvalue = TUNING.LIGHTSABER.DIAMONDVALUES.PURPLE
	end
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	MakeHauntableLaunchAndSmash(inst)
end

local function lightfn()
    local inst = CreateEntity()
	local light = inst.entity:AddLight()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
	
	inst:AddTag("molebait")
	
    inst.AnimState:SetBank("crystal")
    inst.AnimState:SetBuild("crystal")
    inst.AnimState:PlayAnimation(crystalgem)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

	inst:AddComponent("edible")
    inst.components.edible.foodtype = FOODTYPE.ELEMENTAL
    inst.components.edible.hungervalue = 8

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = crystalgem
	inst.components.inventoryitem.atlasname = "images/inventoryimages/crystal/"..crystalgem..".xml"

	inst:AddComponent("bait")

    return inst
end

local function red()
	local inst = lightfn()
	inst.Light:SetColour(129/255, 9/255, 3/255)
	BaseCrystal(inst)
	return inst
end

local function blue()
	local inst = lightfn()
	inst.Light:SetColour(0/255, 128/255, 255/255)
	BaseCrystal(inst)
	return inst
end

local function yellow()
	local inst = lightfn()
	inst.Light:SetColour(255/255, 255/255, 0/255)
	BaseCrystal(inst)
	return inst
end

local function green()
	local inst = lightfn()
	inst.Light:SetColour(0/255, 255/255, 0/255)
	BaseCrystal (inst)
	return inst
end

local function purple()
	local inst = lightfn()
	inst:AddTag("quakedebris")
	inst.Light:SetColour(255/255, 0/255, 255/255)
	BaseCrystal(inst)
	return inst
end

local function white()
	local inst = lightfn()
	inst.Light:SetColour(237/255, 237/255, 209/255)
	BaseCrystal(inst)
	return inst
end

local function black()
	local inst = lightfn()
	if not TheWorld.ismastersim then
		return inst
    end
    inst.components.inventoryitem:SetOnDroppedFn(OnblackDropped)
    inst.components.inventoryitem:SetOnPickupFn(OnblackPickup)
	
	inst:AddComponent("hauntable")
    inst.components.hauntable:SetHauntValue(TUNING.HAUNT_INSTANT_REZ)
	inst.components.hauntable:SetOnHauntFn(old_onhaunt)
	return inst
end

local fn = nil
if colour == "red" then fn = red
elseif colour == "green" then fn = green
elseif colour == "blue" then fn = blue
elseif colour == "yellow" then fn = yellow
elseif colour == "white" then fn = white
elseif colour == "purple" then fn = purple
elseif colour == "black" then fn = black
end
return Prefab(crystalgem, fn, assets)
end

return diamond("purple"), diamond("blue"), diamond("red"), diamond("white"), diamond("yellow"), diamond("green"), diamond("black")
