local function Lightsaber(colour)
local symname = colour.."saber"
local stickname = colour.."_stick"
local swapname = colour.."_swap"
local prefabs = {symname.."fire"}
local assets =
{
Asset("ANIM", "anim/ground_lightsaber.zip"),
Asset("ANIM", "anim/"..symname..".zip"),
Asset("ATLAS", "images/inventoryimages/lightsaber/"..symname..".xml"),
Asset("IMAGE", "images/inventoryimages/lightsaber/"..symname..".tex"),
Asset("SOUNDPACKAGE", "sound/ls_sound.fev"),
Asset("SOUND", "sound/ls_sound.fsb"),
}

local function fuelupdate(inst)
	if inst.fire ~= nil then
		local fuelpercent = inst.components.fueled:GetPercent()
		inst.fire.Light:SetIntensity(Lerp(0.6, 0.8, fuelpercent))
		inst.fire.Light:SetRadius(Lerp(0.5, 1.9, fuelpercent))
		inst.fire.Light:SetFalloff(.5)
	end
end

local function onequip (inst, owner, stickname)
	local build = stickname or swapname
	owner.AnimState:OverrideSymbol("swap_object", symname, build) 
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function OnAttack(inst)
	if inst ~= nil and inst:IsValid() and inst.fire ~= nil and inst.fire:IsValid() then
		inst.fire:OnAttack()
		inst.SoundEmitter:PlaySound("ls_sound/sound/hit")
	end
end

local function onblink(inst, pos, caster) --ring
    if inst.components.fueled then
        inst.components.fueled:DoDelta(-0.01*inst.components.fueled.maxfuel)
    end
end

local function OnLeechesAttack(inst, owner, target) --purple
	OnAttack(inst)
	if owner.components.health and owner.components.health:GetPercent() < 1 and not target:HasTag("wall") and not target:HasTag("structure") then
		owner.components.health:DoDelta(TUNING.LIGHTSABER.LEECHES_HEALTH)
		inst.components.fueled:DoDelta(-0.01*inst.components.fueled.maxfuel)
	end
end

local function OnLightningAttack(inst, owner, target) --white
	OnAttack(inst)
	if inst.components.fueled:GetPercent() > 0.18 and target.components.health and target:HasTag("largecreature") and math.random() < 0.1 then
		SpawnPrefab("lightning").Transform:SetPosition(target:GetPosition():Get())
		SpawnPrefab("shock_fx").Transform:SetPosition(target:GetPosition():Get())
		target.components.health:DoDelta(-TUNING.LIGHTSABER_DAMAGE*20)
		inst.components.fueled:DoDelta(-0.18*inst.components.fueled.maxfuel)
	end
end

local function OnFireAttack(inst, attacker, target) --red
	OnAttack(inst)
	if target ~= nil and target.components.burnable ~= nil and not target:HasTag("wall") and math.random() < 0.3 then
		target.components.burnable:Ignite(nil, attacker)
		inst.components.fueled:DoDelta(-0.01*inst.components.fueled.maxfuel)
	end
end

local function OnIceAttack(inst, attacker, target) --blue
	OnAttack(inst)
	if target ~= nil and target.components.freezable then
		target.components.freezable:AddColdness(0.8)
		target.components.freezable:SpawnShatterFX()
		inst.components.fueled:DoDelta(-0.0025*inst.components.fueled.maxfuel)
	end
end

local function OnMonsterAttack(inst, attacker, target) --sword
	OnAttack(inst)
	if target:HasTag ("monster") then
		target.components.health:DoDelta(-TUNING.LIGHTSABER_DAMAGE)
		inst.components.fueled:DoDelta(-0.005*inst.components.fueled.maxfuel)
	end
end

local function OnDarkAttack(inst, attacker, target) --dark
	OnAttack(inst)
	if TheWorld.state.isdusk then
		target.components.health:DoDelta(-TUNING.LIGHTSABER_DAMAGE*1)
		inst.components.fueled:DoDelta(-0.005*inst.components.fueled.maxfuel)
	elseif TheWorld.state.isnight then
		target.components.health:DoDelta(-TUNING.LIGHTSABER_DAMAGE*2)
		inst.components.fueled:DoDelta(-0.01*inst.components.fueled.maxfuel)
	end
end

local function OnDepletAttack(inst) end

local function saberskill(inst)
	local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
	if colour == "ring" then
		inst:AddComponent("blinkstaff")
		inst.components.blinkstaff.onblinkfn = onblink
		inst.components.equippable.walkspeedmult = TUNING.LIGHTSABER.SPEED_MULT
		inst.components.weapon.onattack = OnAttack
	elseif colour == "blue" then
		inst.components.weapon.onattack = OnIceAttack
	elseif colour == "red" then
		inst.components.weapon.onattack = OnFireAttack
	elseif colour == "yellow" then
		inst.components.weapon.onattack = OnAttack
		owner.components.health:StartRegen(1,2)
	elseif colour == "white" then
		inst.components.weapon.onattack = OnLightningAttack
	elseif colour == "sword" then
		inst.components.weapon.onattack = OnMonsterAttack
		owner:AddTag("monster")
	elseif colour == "purple" then
		inst.components.weapon.onattack = OnLeechesAttack
	elseif colour == "green" then
		inst:AddComponent("tool")
		inst.components.tool:SetAction(ACTIONS.CHOP, 1.33)
		inst.components.weapon.onattack = OnAttack
		inst:ListenForEvent("ontool", OnAttack)
	elseif colour == "dark" then
		inst.components.weapon.onattack = OnDarkAttack
	end
end

local function saberunskill(inst)
	local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
	if colour == "ring" then
		inst:RemoveComponent("blinkstaff")
		inst.components.equippable.walkspeedmult = 1
	elseif colour == "sword" then
		if not owner:HasTag("spiderwhisperer") then
			owner:RemoveTag("monster")
		end
	elseif colour == "yellow" then
		owner.components.health:StopRegen()
	elseif colour == "green" then
		inst:RemoveComponent("tool")
		inst:RemoveEventCallback("ontool", OnAttack)
	end
end

local function saber_turnon(inst, owner)
	local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
	if inst.fire == nil then
		inst.fire = SpawnPrefab(symname.."fire")
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_object", 0, -111, 1)
		fuelupdate(inst)
	end
	inst.SoundEmitter:PlaySound("ls_sound/sound/on")
	inst.components.fueled:StartConsuming()
	inst.components.weapon:SetDamage(TUNING.LIGHTSABER_DAMAGE)
	if Ability then 
		saberskill(inst)
	else
		inst.components.weapon.onattack = OnAttack
	end
end

local function saber_turnoff(inst)
	inst.components.fueled:StopConsuming()
	if Ability then
		saberunskill(inst)
	end
	inst.components.weapon:SetDamage(0)
	inst.components.weapon.onattack = OnDepletAttack
	if inst.fire ~= nil then
		inst.fire:Remove()
		inst.fire = nil
	end
end

local function dowetparks(inst)
	local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
	if inst:GetIsWet() then
		if not inst.wetness and not inst._turnoff then
			onequip(inst, owner, stickname)
			saber_turnoff (inst)
			inst.SoundEmitter:PlaySound("ls_sound/sound/off")
			inst.wetness = true
		end
	elseif inst.wetness then
		inst.wetness = false
	end
end

local function saber_equip(inst, owner)
	if not inst.components.fueled:IsEmpty() then
		local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
		if not inst:GetIsWet() then
			if owner ~= nil then
				onequip(inst, owner)
			end
			if inst._turnoff then
				inst._turnoff = false
			end
			if inst.wetness then
				inst.wetness = false
			end
			saber_turnon(inst)
		else
			if owner ~= nil then
				onequip(inst, owner, stickname)
			end
			saber_turnoff(inst)
			if not inst.wetness then
				inst.wetness = true
			end
		end
		inst.wet_task = inst:DoPeriodicTask(1.5, dowetparks)
	elseif owner ~= nil then 
		onequip(inst, owner, stickname)
	end
end

local function saber_takefuel(inst) 
	if inst.components.equippable ~= nil and inst.components.equippable:IsEquipped() then
		saber_equip(inst)
	end
end

local function onusesaber(inst)
	if not inst.components.fueled:IsEmpty() then
		local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
		if not inst:GetIsWet() then
			if not inst._turnoff then
				onequip(inst, owner, stickname)
				saber_turnoff(inst)
				inst.SoundEmitter:PlaySound("ls_sound/sound/off")
				inst._turnoff = true
				inst.components.useableitem:StopUsingItem()
			elseif inst._turnoff then
				onequip(inst, owner)
				saber_turnon(inst)
				inst._turnoff = false
				inst.components.useableitem:StopUsingItem()
			end
		else
			inst._turnoff = true
			inst.components.useableitem:StopUsingItem()
		end
	end
end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
    anim:SetBank("ground_lightsaber")
    anim:SetBuild("ground_lightsaber")
    anim:PlayAnimation(symname)
 
	if not TheWorld.ismastersim then
        return inst
    end
	
	inst._turnoff = false
	inst.wetness = false
	
	inst:AddTag("sharp")
	inst:AddTag(symname)

	inst:AddComponent("inspectable")

	inst:AddComponent("weapon")
	inst.components.weapon:SetElectric()

	inst:AddComponent("fueled")
    inst.components.fueled.fueltype = FUELTYPE.ELECTRIC
    inst.components.fueled:InitializeFuelLevel(TUNING.LIGHTSABER_PERISHTIME)
	inst.components.fueled.accepting = true
	inst.components.fueled:SetDepletedFn(inst.Remove)
	inst.components.fueled.ontakefuelfn = saber_takefuel
	inst.components.fueled:SetUpdateFn(fuelupdate)

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = symname
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lightsaber/"..symname..".xml"

	inst:AddComponent("useableitem")
    inst.components.useableitem:SetOnUseFn(onusesaber)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(saber_equip)
    inst.components.equippable:SetOnUnequip(function(inst, owner) 
		owner.AnimState:Hide("ARM_carry") 
		owner.AnimState:Show("ARM_normal")
		saber_turnoff(inst)
		if inst.wet_task ~= nil then
			inst.wet_task:Cancel()
			inst.wet_task = nil
		end
	end)

	MakeHauntableLaunch(inst)

   return inst
end
return
Prefab(symname, fn, assets, prefabs)
end

local prefabslight = {"sparks"}

local function OnLightAttack(inst)
	local x, y, z = inst.Transform:GetWorldPosition()
	SpawnPrefab("sparks").Transform:SetPosition(x, y, z)
end

local function commonlightfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddLight()
    inst.entity:AddNetwork()

    inst:AddTag("FX")

    inst.Light:Enable(true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false

    inst.OnAttack = OnLightAttack

    return inst
end

local function bluelight()
	local inst = commonlightfn()
	inst.Light:SetColour(0/255, 128/255, 255/255)
	return inst
end

local function yellowlight()
	local inst = commonlightfn()
	inst.Light:SetColour(255/255, 255/255, 0/255)
	return inst
end

local function redlight()
	local inst = commonlightfn()
	inst.Light:SetColour(129/255, 9/255, 3/255)
	return inst
end

local function greenlight()
	local inst = commonlightfn()
	inst.Light:SetColour(0/255, 255/255, 0/255)
	return inst
end

local function purplelight()
	local inst = commonlightfn()
	inst.Light:SetColour(255/255, 0/255, 255/255)
	return inst
end

local function whitelight()
	local inst = commonlightfn()
	inst.Light:SetColour(237/255, 237/255, 209/255)
	return inst
end

return	Lightsaber("blue"), 
		Lightsaber("yellow"),
		Lightsaber("red"),
		Lightsaber("green"),
		Lightsaber("sword"),
		Lightsaber("ring"),
		Lightsaber("purple"),
		Lightsaber("white"),
		Lightsaber("dark"),
Prefab("greensaberfire", greenlight, nil, prefabslight),
Prefab("redsaberfire", redlight, nil, prefabslight),
Prefab("yellowsaberfire", yellowlight, nil, prefabslight),
Prefab("ringsaberfire", redlight, nil, prefabslight),
Prefab("swordsaberfire", redlight, nil, prefabslight),
Prefab("purplesaberfire", purplelight, nil, prefabslight),
Prefab("whitesaberfire", whitelight, nil, prefabslight),
Prefab("darksaberfire", whitelight, nil, prefabslight),
Prefab("bluesaberfire", bluelight, nil, prefabslight)