include("StatusMessagePanel");
include("InstanceManager");
local bIsHide = false;

function OnInputHandler(pInputStruct:table)
	local uiMsg = pInputStruct:GetMessageType();
	if pInputStruct:GetKey() == Keys.H and uiMsg==KeyEvents.KeyUp then
			if bIsHide then
				bIsHide = not bIsHide
				ContextPtr:LookUpControl("/InGame/TopPanel"):SetHide(false);
				ContextPtr:LookUpControl("/InGame/DiplomacyRibbon"):SetHide(false);
				ContextPtr:LookUpControl("/InGame/LaunchBar"):SetHide(false);
				ContextPtr:LookUpControl("/InGame/PartialScreenHooks"):SetHide(false);
				ContextPtr:LookUpControl("/InGame/WorldTracker"):SetHide(false);
				ContextPtr:LookUpControl("/InGame/UnitPanel"):SetHide(false);
				ContextPtr:LookUpControl("/InGame/WorldViewIconsManager"):SetHide(false);
				ContextPtr:LookUpControl("/InGame/WorldViewPlotMessages"):SetHide(false);	
			else
				bIsHide = not bIsHide
				ContextPtr:LookUpControl("/InGame/TopPanel"):SetHide(true);
				ContextPtr:LookUpControl("/InGame/DiplomacyRibbon"):SetHide(true);
				ContextPtr:LookUpControl("/InGame/LaunchBar"):SetHide(true);
				ContextPtr:LookUpControl("/InGame/PartialScreenHooks"):SetHide(true);
				ContextPtr:LookUpControl("/InGame/WorldTracker"):SetHide(true);
				ContextPtr:LookUpControl("/InGame/UnitPanel"):SetHide(true);
				ContextPtr:LookUpControl("/InGame/WorldViewIconsManager"):SetHide(true);
				ContextPtr:LookUpControl("/InGame/WorldViewPlotMessages"):SetHide(true);	
			end
	elseif pInputStruct:GetKey() == Keys.A and uiMsg==KeyEvents.KeyUp then
			if AutoplayManager.IsActive() then				
				StopAutoPlay();
			else				
				StartAutoPlay();
			end	
	end		
end

function StartAutoPlay()    	
		AutoplayManager.SetTurns(-1);
        AutoplayManager.SetReturnAsPlayer(0);
		AutoplayManager.SetObserveAsPlayer(tonumber(PlayerTypes.OBSERVER));
		AutoplayManager.SetActive(true);	
		LuaEvents.AutomationGameStarted();
		StatusMessage("挂机开启 请不要点击市中心",ReportingStatusTypes.DEFAULT);
end


function StopAutoPlay()			
		AutoplayManager.SetTurns(0);
        AutoplayManager.SetReturnAsPlayer(0);
		AutoplayManager.SetActive(false);
		LuaEvents.AutomationGameEnded();
		StatusMessage("挂机关闭 下回合后可操作",ReportingStatusTypes.DEFAULT);
end

function StatusMessage(str:string,type:number)
	LuaEvents.StatusMessage(str,1,type);
end	

ContextPtr:SetInputHandler(OnInputHandler,true);
LuaEvents.StartAuToPlay.Add(StartAutoPlay);
LuaEvents.StopAuToPlay.Add(StopAutoPlay);
LuaEvents.StatusMessage.Add(OnStatusMessage);

