local MakePlayerCharacter = require "prefabs/player_common"
local assets = {
        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
        Asset( "ANIM", "anim/w3nd1.zip" ),
}
local prefabs = {
}
local start_inv = {
"backpack",
}
local function hk_update(inst) --set stats properly
	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()
	inst.components.hunger.max = 75 + inst.hk_lvl_hunger * 12.5 --min 50 max 200 hunger
	inst.components.sanity.max = 75 + inst.hk_lvl_sanity * 5 --min 50 max 150 sanity
	inst.components.health.maxhealth = 75 + inst.hk_lvl_health * 25 --min 50 max 250 health
	inst.components.locomotor.walkspeed = 5 --125% of Wilson walkspeed
	inst.components.locomotor.runspeed = 7.5 --125% of Wilson runspeed
	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
end
local function hk_oneat(inst, food) --handle leveling up	
	if food then
		if food.components.edible.hungervalue > 74 then	
			if inst.hk_lvl_hunger < 10 then							
				inst.hk_lvl_hunger = inst.hk_lvl_hunger + 1			
				hk_update(inst)	
				if inst.hk_lvl_hunger < 10 then
					inst.components.talker:Say("Thats what I call eating!")
				else
					inst.components.talker:Say("My strength came back.")
				end
			end
		end	
		if food.components.edible.hungervalue < 0 then	
			if inst.hk_lvl_hunger > -2 then							
				inst.hk_lvl_hunger = inst.hk_lvl_hunger - 1			
				hk_update(inst)	
				if inst.hk_lvl_hunger > 0 then
					inst.components.talker:Say("Urgh! I feel really bad..")
				else
					inst.components.talker:Say("My stomach! It HURTS!!!")
				end
			end
		end
		if food.components.edible.sanityvalue > 19 then	
			if inst.hk_lvl_sanity < 15 then							
				inst.hk_lvl_sanity = inst.hk_lvl_sanity + 1			
				hk_update(inst)	
				if inst.hk_lvl_sanity < 15 then
					inst.components.talker:Say("My head hurts less!")
				else
					inst.components.talker:Say("My mind is clear... for the first time in a long time.")
				end
			end
		end			
		if food.components.edible.sanityvalue < -14 then	
			if inst.hk_lvl_sanity > -5 then		
				inst.SoundEmitter:PlaySound("dontstarve/sanity/creature2/taunt")					
				inst.hk_lvl_sanity = inst.hk_lvl_sanity - 1			
				hk_update(inst)	
				if inst.hk_lvl_sanity > 0 then
					inst.components.talker:Say("I feel dizzy...")
				else
					inst.components.talker:Say("Dark. It's dark. Everywhere. There is no hope...")
				end
			end
		end	
		if food.components.edible.healthvalue > 59 then	
			if inst.hk_lvl_health < 7 then							
				inst.hk_lvl_health = inst.hk_lvl_health + 1			
				hk_update(inst)	
				if inst.hk_lvl_health < 7 then
					inst.components.talker:Say("I feel a lot better now!")
				else
					inst.components.talker:Say("I think I'm no longer sick.")
				end
			end
		end
		if food.components.edible.healthvalue < -10 then	
			if inst.hk_lvl_health > -1 then			
				inst.SoundEmitter:PlaySound("dontstarve/sanity/creature2/taunt")				
				inst.hk_lvl_health = inst.hk_lvl_health - 1			
				hk_update(inst)	
				if inst.hk_lvl_health < 7 then
					inst.components.talker:Say("My heart hurts...")
				else
					inst.components.talker:Say("Nonono... so cold... anybody... help...")
				end
			end
		end
	end
end
local function hk_onpreload(inst, data) --load levels from save file
	if data and data.hk_lvl_hunger then --allows character to be created (hk_onpreload won't do anything before levels will be set)
		inst.hk_lvl_hunger = data.hk_lvl_hunger
		inst.hk_lvl_sanity = data.hk_lvl_sanity
		inst.hk_lvl_health = data.hk_lvl_health
		hk_update(inst)
		--re-set these from the save data, because of load-order clipping issues
		if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
		if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
		if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
		inst.components.health:DoDelta(0)
		inst.components.hunger:DoDelta(0)
		inst.components.sanity:DoDelta(0)		
	end
end
local function hk_onsave(inst, data) --save updates to save file
	data.hk_lvl_hunger = inst.hk_lvl_hunger
	data.hk_lvl_sanity = inst.hk_lvl_sanity
	data.hk_lvl_health = inst.hk_lvl_health
end
local fn = function(inst) --main character function
	inst.hk_lvl_hunger = 0
	inst.hk_lvl_sanity = 0
	inst.hk_lvl_health = 0
	inst.components.locomotor.walkspeed = 5
	inst.components.locomotor.runspeed = 7.5
	inst.soundsname = "wendy"
	inst.MiniMapEntity:SetIcon( "w3nd1.tex" )	
	inst.components.hunger:SetMax(75)
	inst.components.sanity:SetMax(75)
	inst.components.health:SetMaxHealth(75)		
	inst.components.eater:SetOnEatFn(hk_oneat)		
	inst.components.talker.colour = Vector3(0/255, 0/255, 0/255)		
	inst.OnSave = hk_onsave
	inst.OnPreLoad = hk_onpreload	
		
end
return MakePlayerCharacter("w3nd1", prefabs, assets, fn, start_inv) --creates character - most important line in this file