local STRINGS = GLOBAL.STRINGS
local SpawnPrefab = GLOBAL.SpawnPrefab
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local TECH = GLOBAL.TECH

PrefabFiles = 
{
    "nightghost",
	"ectoplasm",
	"spirit_torch",
	"spirit_flame",
}

STRINGS.NAMES.SPIRIT_TORCH = "Spirit Torch"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SPIRIT_TORCH = "It is connected with the spirits?"  
STRINGS.RECIPE_DESC.SPIRIT_TORCH = "Light the night with spirits flame."

STRINGS.NAMES.ECTOPLASM = "Ectoplasm"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ECTOPLASM = "Immaterial substance."

STRINGS.NAMES.NIGHTGHOST = "Ghost"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTGHOST = "That offends me as a Scientist."
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.NIGHTGHOST = "It remembers me!"
STRINGS.CHARACTERS.WENDY.DESCRIBE.NIGHTGHOST = "He has risen from the grave!"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.NIGHTGHOST = "It must be fake. I don't believe it."
STRINGS.CHARACTERS.WILLOW.DESCRIBE.NIGHTGHOST = "I can't kill what's already dead."
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.NIGHTGHOST = "Aaaaaaaaaaah!"
STRINGS.CHARACTERS.WOODIE.DESCRIBE.NIGHTGHOST = "Boo! Ha ha!"
STRINGS.CHARACTERS.WX78.DESCRIBE.NIGHTGHOST = "ERROR: UNKNOWN"

TUNING.SPIRIT_TORCH_FUEL_MAX = 380
TUNING.SPIRIT_TORCH_FUEL_START = 180

local ectoplasm = Ingredient( "ectoplasm", 2)
ectoplasm.atlas = "images/inventoryimages/ectoplasm.xml"

local spirit_torch = Recipe("spirit_torch", {Ingredient("goldnugget", 8), ectoplasm ,Ingredient("bluegem", 1)}, RECIPETABS.MAGIC,  TECH.MAGIC_TWO, "spirit_torch_placer")
spirit_torch.atlas = "images/inventoryimages/spirit_torch.xml"

function MoundPrefabPostInit(inst)

	local function SpawnGhost(inst)
		if not inst.components.workable then
		local r = math.random()
			if r < .5 then
			local loc = inst:GetPosition()
			loc.x = loc.x -.3
			loc.z = loc.z -.3
			local ghost = SpawnPrefab("nightghost")
			ghost.Transform:SetPosition(loc.x, loc.y, loc.z)
			end
		end
	end

	inst:ListenForEvent("dusktime", function() SpawnGhost(inst) end, GLOBAL.GetWorld())
    
end

AddPrefabPostInit("mound", MoundPrefabPostInit)

AddPrefabPostInit("world", function(inst)

	GLOBAL.assert( GLOBAL.GetPlayer() == nil )

	local player_prefab = GLOBAL.SaveGameIndex:GetSlotCharacter()

	GLOBAL.TheSim:LoadPrefabs {player_prefab}

	local oldfn = GLOBAL.Prefabs[player_prefab].fn
	GLOBAL.Prefabs[player_prefab].fn = function()
		local inst = oldfn()

		inst:AddComponent("gravedigger")
		
		return inst
	end
end)