local GraveDigger = Class(function(self, inst)
self.inst = inst

self.ghost_spawn_delay = math.random(5, 15)
self.num_of_ghosts = 3
self.num_of_graves = 0
self.attack_planned = true

self:PlanNextGhostNight()
self.inst:ListenForEvent( "finishedwork", function(inst,data) self:GravesCount(data.target) end )   
self.inst:StartUpdatingComponent(self)
end)

function GraveDigger:GravesCount(target)
	if target and target.prefab then
		if target.prefab == "mound" then
		self.num_of_graves = self.num_of_graves + 1
		self:PlanNextGhostNight()
		end
	end
end

function GraveDigger:OnSave()
	local data = {}
	data.num_of_graves = self.num_of_graves
	data.ghosts_to_spawn = self.ghosts_to_spawn
	return data
end


function GraveDigger:OnLoad(data)
	self.num_of_graves = data.num_of_graves or 0
	self.ghosts_to_spawn = data.ghosts_to_spawn or 0
end

function GraveDigger:OnUpdate(dt)

	if GetSeasonManager():GetSeason() == "summer" or GetSeasonManager():GetSeason() == "winter" then
		if GetClock():IsDusk() and GetClock():GetMoonPhase() == "new" then
	    local day = GetClock().numcycles
		    if day > 4 then
				if self.ghosts_to_spawn >= 0 then 
					if self.ghost_spawn_delay > 0 then
					self.ghost_spawn_delay = self.ghost_spawn_delay - dt
					else
					self:SpawnGhost()
					self.ghost_spawn_delay = 5
					end
				end
			end
					self.attack_planned = false
			end
		end
				if GetClock():IsDay() and GetClock():GetMoonPhase() == "quarter" then
					if self.attack_planned == false then
					self:PlanNextGhostNight()
					end
				end
end

function GraveDigger:GetSpawnPoint(pt)

    local theta = math.random() * 2 * PI
    local radius = math.random(15, 30)

	local offset = FindWalkableOffset(pt, theta, radius, 12, true)
	if offset then
		return pt+offset
	end
end

function GraveDigger:SpawnGhost(dt)
	local pt = Vector3(GetPlayer().Transform:GetWorldPosition())
		
	local spawn_pt = self:GetSpawnPoint(pt)
	
	if spawn_pt then
		self.ghosts_to_spawn = self.ghosts_to_spawn - 1
		
		local prefab = "nightghost"
	
		local ghost = SpawnPrefab(prefab)
		if ghost then
			ghost.Physics:Teleport(spawn_pt:Get())
		end
	end
	
end

function GraveDigger:PlanNextGhostNight()
	if self.num_of_graves > 1 then
	self.attack_planned = true
	self.ghosts_to_spawn = self.num_of_ghosts + math.random(1 ,self.num_of_graves)
	else
	self.attack_planned = true
	self.ghosts_to_spawn = self.num_of_ghosts + 2
	end
end

return GraveDigger
