local assets =
{
	Asset("ANIM", "anim/ghost.zip"),
	Asset("ANIM", "anim/ghost_build.zip"),
	Asset("SOUND", "sound/ghost.fsb"),
}

local prefabs = 
{
  "ectoplasm"
}

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
    local light = inst.entity:AddLight()
    inst.entity:AddPhysics()
    anim:SetBloomEffectHandle( "shaders/anim.ksh" )
    
    MakeGhostPhysics(inst, 1, .5)
    
    light:SetIntensity(.6)
    light:SetRadius(.5)
    light:SetFalloff(.6)
    light:Enable(true)
	
	local r = math.random(100, 255)
	local g = math.random(50, 255)
	local b = math.random(100, 255)
	
	light:SetColour(r - math.random(50, 100)/255, g - math.random(25, 50)/255, b - math.random(45, 100)/255)
    
    local brain = require "brains/nightghostbrain"
    inst:SetBrain(brain)
    
    anim:SetBank("ghost")
    anim:SetBuild("ghost_build")
    anim:PlayAnimation("idle", true)
    --inst.AnimState:SetMultColour(1,1,1,.6)
    
    inst:AddTag("monster")
    inst:AddTag("hostile")
    inst:AddTag("ghost")
    inst:AddTag("noauradamage")

    inst:AddComponent("locomotor")
    inst.components.locomotor.walkspeed = math.random(2,4)
    inst.components.locomotor.runspeed = math.random(2,4)
    inst.components.locomotor.directdrive = true
    
    inst:SetStateGraph("SGghost")
    
    
	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = -TUNING.SANITYAURA_MED
    
    inst:AddComponent("inspectable")
    
	inst:AddComponent("lootdropper")
    inst.components.lootdropper:AddChanceLoot("ectoplasm", 0.4)
	
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(TUNING.GHOST_HEALTH)
    
    inst:AddComponent("combat")
    inst.components.combat.defaultdamage = TUNING.GHOST_DAMAGE
    inst.components.combat.playerdamagepercent = TUNING.GHOST_DMG_PLAYER_PERCENT

    inst:AddComponent("aura")
    inst.components.aura.radius = TUNING.GHOST_RADIUS
    inst.components.aura.tickperiod = TUNING.GHOST_DMG_PERIOD
    
    ------------------    
    inst.SoundEmitter:PlaySound("dontstarve/ghost/ghost_howl_LP", "howl")
    
    return inst
end

return Prefab( "common/monsters/nightghost", fn, assets, prefabs) 