local assets =
{
	Asset("ANIM", "anim/spirit_torch.zip"),
	Asset("ATLAS", "images/inventoryimages/spirit_torch.xml"),
}

local prefabs =
{
    "spirit_flame",
}    

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_metal")
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle")
end

local function onextinguish(inst)
    if inst.components.fueled then
        inst.components.fueled:InitializeFuelLevel(0)
    end
end

local function onbuilt(inst)
	inst.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel")
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("idle", false)
end

local function addfuel(inst)
	local x,y,z = inst.Transform:GetWorldPosition()
	local nearbyspirittorches = TheSim:FindEntities(x,y,z, 600, {"spiritfire"} )
	for i = 1, #nearbyspirittorches do
		if nearbyspirittorches[i] ~= nil and nearbyspirittorches[i].components.fueled then
			nearbyspirittorches[i].components.fueled.currentfuel = nearbyspirittorches[i].components.fueled.currentfuel + nearbyspirittorches[i].components.fueled.maxfuel/4
			if not nearbyspirittorches[i].components.burnable:IsBurning() then
                nearbyspirittorches[i].components.burnable:Ignite()
			end
		end
	end
end

local function fn(Sim)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()

    anim:SetBank("nightmare_torch")
    anim:SetBuild("spirit_torch")
    anim:PlayAnimation("idle",false)

	inst:AddTag("spiritfire")
    inst:AddTag("structure")
    MakeObstaclePhysics(inst, .1)    

    -----------------------
    inst:AddComponent("burnable")
    inst.components.burnable:AddBurnFX("spirit_flame", Vector3(0,0,0), "fire_marker")
    inst:ListenForEvent("onextinguish", onextinguish)
    
    -------------------------
    inst:AddComponent("lootdropper")
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(4)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit)    

    -------------------------
    inst:AddComponent("fueled")
    inst.components.fueled.maxfuel = TUNING.SPIRIT_TORCH_FUEL_MAX
    inst.components.fueled.accepting = true
    inst.components.fueled.fueltype = "CAVE"
    inst.components.fueled:SetSections(4)
    inst.components.fueled.ontakefuelfn = function() inst.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel") addfuel(inst) end
    
    inst.components.fueled:SetUpdateFn( function()
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
        
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish() 
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
            
        end
    end)
        
    inst.components.fueled:InitializeFuelLevel(TUNING.SPIRIT_TORCH_FUEL_START)
    
    -----------------------------
    
    inst:AddComponent("inspectable")
    
    inst:ListenForEvent( "onbuilt", onbuilt)
    
    return inst
end

return Prefab( "common/objects/spirit_torch", fn, assets, prefabs),
		MakePlacer( "common/spirit_torch_placer", "nightmare_torch", "spirit_torch", "idle" ) 
