Scriptname SKK_ContainerScript extends ObjectReference  

SKK_DisplayScript Property MyDisplay Auto
Form[] Property Items Auto Hidden
Int Property ItemCount Auto Hidden

Int MaxCount

Function SKKLog(string msg)
    ;Debug.MessageBox("SKK_" + msg)
    ;Debug.Trace("SKK_" + msg)
EndFunction


; The RejectItem function was designed by fg109
Function RejectItem(Form akBaseItem, int aiItemCount, ObjectReference akSourceContainer, Int iMessageBox)
    ;SKKLog("CS: RejectItem " + akBaseItem + " - " + iMessageBox);
    string plural = "s"
    GoToState("Inactive")
    RemoveItem(akBaseItem, aiItemCount, True, akSourceContainer)
    if (iMessageBox == 0)
        GotoState("Active")
        Return
    elseif (iMessageBox == 1)
        Debug.MessageBox("The display case is full.")
    elseif (iMessageBox == 2)
        if(aiItemCount == 1)
            plural = ""
        endif
        Debug.MessageBox("Case is full.  Returning " + aiItemCount + "item" + plural + ".");
    elseif (MyDisplay.DCType < 3)
        Debug.MessageBox("The display case only accepts circlets and necklaces.")
    else
        Debug.MessageBox("The display case only accepts rings.")
    endif
    GoToState("Active")
EndFunction

Event OnInit()
    if (MyDIsplay.DCType < 3)
        MaxCount = 4
        Items = new Form[4]
    else
        MaxCount = 10
        Items = new Form[10]
    endif
EndEvent

Event OnActivate(ObjectReference ref)
    GoToState("Active")
    RegisterForSingleUpdate(1)
EndEvent

Event OnUpdate()
    MyDisplay.ContainerClosed()
EndEvent

State Active
    
Event OnItemAdded(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer)
    ;if akItemReference != None
        ;;SKKLog("CS: OnItemAdded - " + akItemReference.GetDisplayName() + " (" + akItemReference + ") (" + akBaseItem + ")")
        ;RejectItem(akBaseItem, aiItemCount, akSourceContainer, 4)
        ;Return
    ;else
        ;SKKLog("CS: OnItemAdded (" + akItemReference + ") (" + akBaseItem + ")")
    ;endif

    ;This check needs to come first!!
    if (ItemCount == MaxCount)
        RejectItem(akBaseItem, aiItemCount, akSourceContainer, 1)
        Return
    endif
    ;This check needs to come after the if(ItemCount == MaxCount) because if this condition passes, ItemCount will always equal MaxCount
    if (aiItemCount + ItemCount > MaxCount)
        int newadd = MaxCount - ItemCount
        RejectItem(akBaseItem, newadd, akSourceContainer, 2)
        ;Don't return, let it run and add the ones it can
    endif
    if !(akBaseItem as Armor)
        RejectItem(akBaseItem, aiItemCount, akSourceContainer, 3)
        Return
    endif
    Armor skkFix = akBaseItem as Armor
    ;SKKLog("    Adding " + akBaseItem + " (" + skkFix.GetSlotMask() + ")")
    if  (MyDisplay.DCType < 3 && (skkFix.GetSlotMask() == 0x00000020)) || \
        (MyDisplay.DCType < 3 && (skkFix.GetSlotMask() == 0x00001000)) || \
        (MyDisplay.DCType > 2 && (skkFix.GetSlotMask() == 0x00000040))
        Items[ItemCount] = akBaseItem as Form
        ItemCount += 1
        ;SKKLog("    ADDED  " + Items[ItemCount - 1] + " (" + ItemCount + ")")
    else
        RejectItem(akBaseItem, aiItemCount, akSourceContainer, 3)
    endif
EndEvent

Event OnItemRemoved(Form akBaseItem, int aiItemCount, ObjectReference akItemReference, ObjectReference akDestContainer)
    ;;SKKLog("CS: OnItemRemoved " + akBaseItem);
   
    int index
    int removed
    while (index < ItemCount && removed < aiItemCount)
        if (Items[index] == akBaseItem)
            while (index < ItemCount - 1)
                Items[index] = Items[index + 1]
                index += 1
            endwhile
            Items[index] = None
            ItemCount -= 1
            removed += 1
        else
            index += 1
        endif
    endwhile

    

EndEvent

EndState

State Inactive
EndState