Scriptname SKK_DisplayScript extends ObjectReference  

{1 = large angled, 2 = large flat, 3 = small angled, 4 = small flat}
Int Property DCType Auto
SKK_TriggerScript Property MyTrigger Auto
SKK_ContainerScript Property MyContainer Auto

Bool Busy
Bool Changed
Bool Open
Int MaxCount
ObjectReference[] Items
ObjectReference Opener 
Int ItemCount
bool NeedWait

Function SKKLog(string msg)
    ;Debug.Notification("SKK_" + msg)
    ;Debug.Trace("SKK_" + msg)
EndFunction

Function SKKWait(float f)
    ;SKKLog("    Waiting " + f)
    Utility.Wait(f)
endfunction

;Event OnCellDetach()
    ;;SKKLog("OnCellDetach");
    ;GetParentCell().reset()
    ;EndEvent

Event OnInit()
    if (DCType < 3)
        MaxCount = 4
        Items = new ObjectReference[4]
    else
        MaxCount = 10
        Items = new ObjectReference[10]
    endif
    BlockActivation()
EndEvent

Event OnCellAttach()
    if(DCType == 1)
        GoToState("LargeAngled")
    elseif(DCType == 2)
        GoToState("LargeFlat")
    elseif(DCType == 3)
        GoToState("SmallAngled")
    else
        GoToState("SmallFlat")
    endif
    
    HandleJewelryPlacement_()
EndEvent

Event OnOpen(ObjectReference who)
    ;MyTrigger.GoToState("Active")
EndEvent

Event OnClose(ObjectReference who)
    ;MyTrigger.GoToState("Inactive")
    If Changed
        ;SKKLog("DisplayOnCloseHandlePlace")
        HandleJewelryPlacement_()
    endif
EndEvent

Event OnActivate(ObjectReference akActionRef)
    if (Busy)
        Return
    elseif (akActionRef as Actor)
        Opener = akActionRef
        If((akActionRef as Actor).IsSneaking())
            Busy = True
            MyTrigger.GoToState("Off")
            if !Open
                Self.Activate(Opener, true)
                Open = true
            endif
            CopyToContainer()
            MyContainer.Activate(Opener)
        else
            Open = !Open
            Self.Activate(Opener, true)
            if Open
                MyTrigger.GoToState("On")
            else
                MyTrigger.GoToState("Off");
            endif
        endif
    endif
EndEvent

Function HandleJewelryPlacement_()
    ;SKKLog("DS: HandleJewelryPlacement_");
    HandleJewelryPlacement()
EndFunction

Function TriggerLeave(ObjectReference TriggerRef)
    ;SKKLog("DS: TriggerLeave - " + TriggerRef.GetDisplayName());
    int index
    while index < ItemCount
        if(Items[index] == TriggerRef)
            while(index < (ItemCount - 1))
                Items[index] = Items[index + 1]
                index += 1
            EndWhile
            Items[index] = None
            ItemCount -= 1
            Changed = true
            Return
        EndIf
        index += 1
    EndWhile
EndFunction

Function ContainerClosed()
    ;SKKLog("DS: Container Closed")
    Changed = false
    if Open
        ;SKKLog("    Try to auto close!")
        Self.Activate(Opener, True)
        Open = false
    endif
    CopyFromContainer()
    ;SKKWait(1)
    ;SKKLog("    ContainerClosedHandlePlace")
    HandleJewelryPlacement_()
    Busy = False;
EndFunction

Form[] Function CopyArray(Form[] a)
    Form[] ret;
    if(DCType < 3)
        ret = new Form[4]
    Else
        ret = new Form[10]
    EndIf
    
    int index
    while(index < MaxCount)
        ret[index] = a[index]
        index += 1
    EndWhile
    
    return ret
EndFunction

Function CopyToContainer()
    ;SKKLog("    Copy To Container (" + ItemCount + ")")
    int index
    while index < ItemCount
        if Items[index] != None
            MyContainer.AddItem(Items[index])
            Items[index] = None
        EndIf
        index += 1
    endwhile
EndFunction

Function CopyFromContainer()
    ItemCount = MyContainer.ItemCount
    ;SKKLog("    Copy From Container (" + ItemCount + ")")
    Form[] contItems = CopyArray(MyContainer.Items)
    int index
    While index < ItemCount
        if contItems[index] != None
            Items[index] = MyContainer.DropObject(contItems[index])
            ;SKKLog("     -- Copied " + Items[index].GetDisplayName() + " (" + Items[index] + ")")
        endif
        index += 1
    EndWhile
EndFunction
    


; This function was written by fg109
;This function will take values for X and Y offsets relative to an object's heading (based on Z axis rotation)
;and return the global values.  There is no conversion done for the Z axis value.
Float[] Function ConvertOffsets(ObjectReference akSource, Float OffsetX, Float OffsetY, Float OffsetZ = 0.0)
    Float[] Pos = new Float[3]
    Float AngleZ = akSource.GetAngleZ()
    Pos[0] = OffsetX * Math.Cos(AngleZ) + OffsetY * Math.Sin(AngleZ) + akSource.X
    Pos[1] = OffsetY * Math.Cos(AngleZ) - OffsetX * Math.Sin(AngleZ) + akSource.Y
    Pos[2] = OffsetZ + akSource.Z
    Return Pos
EndFunction

; This function was written by fg109
;This function will take values for X and Y offsets relative to a heading (based on Z axis rotation)
;and return the global values.  There is no conversion done for the Z axis value.
Float[] Function ConvertAngles(Float AngleX, Float AngleY, Float AngleZ)
    if (AngleZ < 180.0)
        AngleZ + 360.0
    elseif (AngleZ > 180)
        AngleZ - 360.0
    endif
    Float[] Rot = new Float[3]
    Rot[0] = AngleX * Math.Cos(AngleZ) + AngleY * Math.Sin(AngleZ)
    Rot[1] = AngleY * Math.Cos(AngleZ) - AngleX * Math.Sin(AngleZ)
    Rot[2] = AngleZ
    Return Rot
EndFunction

;Dummy function
Function HandleJewelryPlacement()
EndFunction

; The general logic and method behind these functions was designed by fg109

State LargeAngled

Function HandleJewelryPlacement()
    ;SKKLog("DS: HandleJewelryPlacement LargeAngled (" + ItemCount + ")" + Items)
    float OffsetX
    float OffsetY
    float OffsetZ = 47
    float[] Rot = ConvertAngles(20, 0, Self.GetAngleZ() - 180)
    float[] Pos

    OffsetX = 123.0 / (ItemCount + 1)
    int index = 0
    while (index < ItemCount)
        if(Items[index] != None)
            ;SKKLog("    Placing " + Items[index] + " (" + index + ")")
            While !(Items[index].Is3dLoaded())
                SKKWait(0.1)
            EndWhile
            Items[index].SetMotionType(4)
            Items[index].SetAngle(Rot[0], Rot[1], Rot[2])
            Pos = ConvertOffsets(Self, -64.0 + OffsetX * (index + 1), OffsetY, OffsetZ)
            Items[index].MoveTo(Items[index], Pos[0] - Items[index].X, Pos[1] - Items[index].Y, Pos[2] - Items[index].Z)
        EndIf
        ;SKKLog("    Place Loop index " + index + " done")
        index += 1
    endwhile
EndFunction

EndState

State LargeFlat

Function HandleJewelryPlacement()
    ;;SKKLog("DS: HandleJewelryPlacement LargeFlat (" + ItemCount + ")" + Items)
    float OffsetX
    float OffsetY
    float OffsetZ = 5.25
    float[] Pos

    OffsetX = 128.0 / (ItemCount + 1)
    int index = 0
    while (index < ItemCount)
        if(Items[index] != None)
            ;;SKKLog("    Placing " + Items[index] + " (" + index + ")")
            While !(Items[index].Is3dLoaded())
                SKKWait(0.1)
            EndWhile
            Items[index].SetMotionType(4)
            Items[index].SetAngle(0, 0, GetAngleZ() - 180)
            Pos = ConvertOffsets(Self, -64.0 + OffsetX * (index + 1), OffsetY, OffsetZ)
            Items[index].MoveTo(Items[index], Pos[0] - Items[index].X, Pos[1] - Items[index].Y, Pos[2] - Items[index].Z)
        endif
        ;;SKKLog("    Place Loop index " + index + " done")
        index += 1
    endwhile

EndFunction

EndState

State SmallAngled

Function HandleJewelryPlacement()
    ;;SKKLog("DS: HandleJewelryPlacement SmallAngled (" + ItemCount + ")" + Items)
    int Row01
    int Row02
    float OffsetX
    float OffsetY
    float OffsetZ = 5
    float[] Rot = ConvertAngles(-20, 0, Self.GetAngleZ())
    float[] Pos

    ;figure out how many rings should be in each row
    if (ItemCount > 5)
        Row01 = Math.Ceiling(ItemCount / 2.0)
        Row02 = ItemCount - Row01
    else
        Row01 = ItemCount
        Row02 = 0
    endif

    ;lay out the first row
    OffsetX = 68.0 / (Row01 + 1)
    if (Row02)
        OffsetY = 3.0
        OffsetZ = 6
    endif
    int index = 0
    while (index < Row01)
        if(Items[index] != None)
            ;;SKKLog("    Placing Row 1 " + Items[index] + " (" + index + ")")
            While !(Items[index].Is3dLoaded())
                SKKWait(0.1)
            EndWhile
            Items[index].SetMotionType(4)
            Items[index].SetAngle(Rot[0], Rot[1], Rot[2])
            Pos = ConvertOffsets(Self, -34.0 + OffsetX * (index + 1), OffsetY, OffsetZ)
            Items[index].MoveTo(Items[index], Pos[0] - Items[index].X, Pos[1] - Items[index].Y, Pos[2] - Items[index].Z)
        endif
        ;;SKKLog("    Place Loop Row 1index " + index + " done")
        index += 1
    endwhile
    
    ;lay out the second row
    OffsetX = 68.0 / (Row02 + 1)
    OffsetY = -3.0
    OffsetZ = 4
    while (index < ItemCount)
        if(Items[index] != None)
            ;;SKKLog("    Placing Row 2 " + Items[index] + " (" + index + ")")
            While !(Items[index].Is3dLoaded())
                SKKWait(0.1)
            EndWhile
            Items[index].SetMotionType(4)
            Items[index].SetAngle(Rot[0], Rot[1], Rot[2])
            Pos = ConvertOffsets(Self, -34.0 + OffsetX * (index - Row01 + 1), OffsetY, OffsetZ)
            Items[index].MoveTo(Items[index], Pos[0] - Items[index].X, Pos[1] - Items[index].Y, Pos[2] - Items[index].Z)
        endif
        ;;SKKLog("    Place Loop Row 2 index " + index + " done")
        index += 1
    endwhile

EndFunction

EndState

State SmallFlat

Function HandleJewelryPlacement()
    ;;SKKLog("DS: HandleJewelryPlacement SmallFlat " + ItemCount + ")" + Items)
    int Row01
    int Row02
    float OffsetX
    float OffsetY
    float OffsetZ = 5.25
    float[] Pos

    ;figure out how many rings should be in each row
    if (ItemCount > 5)
        Row01 = Math.Ceiling(ItemCount / 2.0)
        Row02 = ItemCount - Row01
    else
        Row01 = ItemCount
        Row02 = 0
    endif

    ;lay out the first row
    OffsetX = 68.0 / (Row01 + 1)
    if (Row02)
        OffsetY = 3.0
    endif
    int index = 0
    SKKWait(0.5) ; Needed?
    While (index < Row01)
        if(Items[index] != None)
            ;;SKKLog("    Placing Row 1 " + Items[index] + " (" + index + ")")
            While !(Items[index].Is3dLoaded())
                SKKWait(0.1)
            EndWhile
            Items[index].SetMotionType(4)
            Items[index].SetAngle(0, 0, 0)
            Pos = ConvertOffsets(Self, -34.0 + OffsetX * (index + 1), OffsetY, OffsetZ)
            Items[index].MoveTo(Items[index], Pos[0] - Items[index].X, Pos[1] - Items[index].Y, Pos[2] - Items[index].Z)
        endif
        ;;SKKLog("    Place Loop Row 1 index " + index + " done")
        index += 1
    endwhile
    
    ;lay out the second row
    OffsetX = 68.0 / (Row02 + 1)
    OffsetY = -3.0
    while (index < ItemCount)
        if(Items[index] != None)
            ;;SKKLog("    Placing Row 2 " + Items[index] + " (" + index + ")")
            While !(Items[index].Is3dLoaded())
                SKKWait(0.1)
            EndWhile
            Items[index].SetMotionType(4)
            Items[index].SetAngle(0, 0, 0)
            Pos = ConvertOffsets(Self, -34.0 + OffsetX * (index - Row01 + 1), OffsetY, OffsetZ)
            Items[index].MoveTo(Items[index], Pos[0] - Items[index].X, Pos[1] - Items[index].Y, Pos[2] - Items[index].Z)
        endif
        ;;SKKLog("    Place Loop Row 2 index " + index + " done")
        index += 1
    endwhile

EndFunction

EndState