	
GLOBAL.TUNING.KOISHI = {}
GLOBAL.TUNING.PW = GetModConfigData("power")
GLOBAL.TUNING.LANG = GetModConfigData("lan")
GLOBAL.TUNING.VISION = GetModConfigData("vision")
GLOBAL.TUNING.SYS = GetModConfigData("system")

PrefabFiles = {
	"koishi", "koishi_none", "koi_knife", "koishi_hat", "third_eye", "blue_rose", "bluerose", "spell_dream", "spell_rose",  "spell_philosophy", "rose_blue", "rose_red"
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/koishi.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/koishi.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/koishi.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/koishi.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/koishi_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/koishi_silho.xml" ),

    Asset( "IMAGE", "bigportraits/koishi.tex" ),
    Asset( "ATLAS", "bigportraits/koishi.xml" ),
	
	Asset( "IMAGE", "images/map_icons/koishi.tex" ),
	Asset( "ATLAS", "images/map_icons/koishi.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_koishi.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_koishi.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_koishi.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_koishi.xml" ),
	
	Asset( "IMAGE", "bigportraits/koishi_none.tex" ),
    Asset( "ATLAS", "bigportraits/koishi_none.xml" ),
	
	Asset( "IMAGE", "images/names_koishi.tex" ),
    Asset( "ATLAS", "images/names_koishi.xml" ),

	Asset( "ATLAS", "images/hud/koishitab.xml" ),
	Asset( "IMAGE", "images/hud/koishitab.tex" ),
}

local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local Recipe = GLOBAL.Recipe
local EventHandler = GLOBAL.EventHandler
local Action = GLOBAL.Action
local ACTIONS = GLOBAL.ACTIONS
local ActionHandler = GLOBAL.ActionHandler
local TUNING = GLOBAL.TUNING
local STRINGS = GLOBAL.STRINGS
local Lerp = GLOBAL.Lerp
local SpawnPrefab = GLOBAL.SpawnPrefab
local FindWalkableOffset = GLOBAL.FindWalkableOffset
local PI = GLOBAL.PI
local Vector3 = GLOBAL.Vector3
--local debug = GLOBAL.debug
local GetPlayer = GLOBAL.GetPlayer
local IsHUDPaused = GLOBAL.IsPaused
local TheInput = GLOBAL.TheInput
local TheFrontEnd = GLOBAL.TheFrontEnd
local TheSim = GLOBAL.TheSim

--modinfo
local IsServer = GLOBAL.TheNet:GetIsServer()

local koishitab = AddRecipeTab( "Koishi's Tab", 515, "images/hud/koishitab.xml", "koishitab.tex", "koishi_builder")

local bluerose1 = GLOBAL.Ingredient( "bluerose", 5,"images/inventoryimages/bluerose.xml")
local bluerose2 = GLOBAL.Ingredient( "bluerose", 10,"images/inventoryimages/bluerose.xml")
local bluerose3 = GLOBAL.Ingredient( "bluerose", 30,"images/inventoryimages/bluerose.xml")

AddRecipe("spell_dream", 
{GLOBAL.Ingredient("papyrus", 1), bluerose1, GLOBAL.Ingredient("nightmarefuel", 3)}, 
koishitab, TECH.NONE, nil, nil, nil, nil, "koishi_builder", 
"images/inventoryimages/spell_dream.xml", "spell_dream.tex" )

AddRecipe("spell_philosophy", 
{GLOBAL.Ingredient("papyrus", 1), bluerose2, GLOBAL.Ingredient("petals_evil", 10)}, 
koishitab, TECH.NONE, nil, nil, nil, nil, "koishi_builder", 
"images/inventoryimages/spell_philosophy.xml", "spell_philosophy.tex" )

AddRecipe("spell_rose", 
{GLOBAL.Ingredient("papyrus", 1), bluerose3, GLOBAL.Ingredient("petals", 20), GLOBAL.Ingredient("bluegem", 3)}, 
koishitab, TECH.SCIENCE_TWO, nil, nil, nil, nil, "koishi_builder", 
"images/inventoryimages/spell_rose.xml", "spell_rose.tex" )

-- The character select screen lines
if TUNING.LANG == 1 then
	STRINGS.CHARACTER_TITLES.koishi = "The Closed Eyes of Love"
	STRINGS.CHARACTER_NAMES.koishi = "Koishi Komeiji"
	STRINGS.CHARACTER_DESCRIPTIONS.koishi = "*A Lovely but Dreadful Youkai\n*Manipulates the Subconscious\n*May Appear behind You Anytime"
	STRINGS.CHARACTER_QUOTES.koishi = "\"Hello, hello! Now, I'm right BEHIND you!  \""
else
	STRINGS.CHARACTER_TITLES.koishi = "紧闭的恋之瞳"
	STRINGS.CHARACTER_NAMES.koishi = "古明地恋"
	STRINGS.CHARACTER_DESCRIPTIONS.koishi = "*操纵无意识程度的能力\n*可以在超我与本我之间切换\n*可以突然出现在敌人背后"
	STRINGS.CHARACTER_QUOTES.koishi = "\"喂喂！现在，我就在你身后哦！\""
end

-- Custom speech strings
if TUNING.LANG == 1 then
	STRINGS.CHARACTERS.KOISHI = require "speech_koishi"
else
	STRINGS.CHARACTERS.KOISHI = require "speech_koishi_cn"
end

-- The character's name as appears in-game 
if TUNING.LANG == 1 then
	STRINGS.NAMES.KOISHI = "Koishi"
else
	STRINGS.NAMES.KOISHI = "恋恋"
end
-- The default responses of examining the character
if TUNING.LANG == 1 then
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.KOISHI = 
	{
		GENERIC = "Strange...There's nobody there...",
		ATTACKER = "I feel sense of an attacker...Where is it from?",
		MURDERER = "There's something frightenning here!...What is it?",
		REVIVER = "Something's saved me...But I don't remember...",
		GHOST = "Koishi needs a 1up.",
	}
else
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.koishi = 
	{
		GENERIC = "奇怪……那明明没有人啊……",
		ATTACKER = "有一股杀气……是哪来的？",
		MURDERER = "有个怪物藏在这里！到底是什么！",
		REVIVER = "好像有什么东西救了我一命……但是我想不起来……",
		GHOST = "恋恋需要一个残机.",
	}
end

AddMinimapAtlas("images/map_icons/koishi.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("koishi", "FEMALE")

