local assets =
{
    Asset("ANIM", "anim/blue_rose.zip"),
}

local prefabs =
{
}
local names = {"f10"}
local ROSE_NAME = "rose"
local ROSE_CHANCE = 1

local function setflowertype(inst, name)
    if inst.animname == nil or (name ~= nil and inst.animname ~= name) then
        inst.animname = name or (math.random() < ROSE_CHANCE and ROSE_NAME or names[math.random(#names)])
        inst.AnimState:PlayAnimation(inst.animname)
        if inst.animname == ROSE_NAME then
            inst:AddTag("thorny")
		end
	end
end

local function onsave(inst, data)
    data.anim = inst.animname
end

local function onload(inst, data)
    setflowertype(inst, data ~= nil and data.anim or nil)
end

local function onpickedfn(inst, picker)
    if not picker:HasTag("koishi") and not picker:HasTag("yuuka") then
        picker.components.combat:GetAttacked(inst, 2)
        picker.components.sanity:DoDelta(-3)
        picker:PushEvent("thorns")
    end
    inst:Remove()
end

local function GetStatus(inst)
    return inst.animname == ROSE_NAME and "ROSE" or nil
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    inst.AnimState:SetBank("flowers")
    inst.AnimState:SetBuild("blue_rose")
    inst.AnimState:SetRayTestOnBB(true)

    inst:AddTag("cattoy")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = GetStatus

    inst:AddComponent("pickable")
    inst.components.pickable.picksound = "dontstarve/wilson/pickup_plants"
    inst.components.pickable:SetUp("bluerose", 10)
    inst.components.pickable.onpickedfn = onpickedfn
    inst.components.pickable.quickpick = true

    MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)

    if not POPULATING then
        setflowertype(inst)
    end
    --------SaveLoad
    inst.OnSave = onsave
    inst.OnLoad = onload

    return inst

end
if TUNING.LANG == 1 then
	STRINGS.NAMES.BLUE_ROSE = "Blue Rose"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLUE_ROSE = "Why is there a blue rose here?"
else
	STRINGS.NAMES.BLUE_ROSE = "蓝色蔷薇"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLUE_ROSE = "为什么这里会有一朵蓝色的蔷薇呢？"
end

return Prefab("blue_rose", fn, assets, prefabs)